/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatResolver;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.CsvFormatParser;
import com.intellij.database.run.actions.ShowCsvFormatsAction;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChoosePasteFormatAction
extends ActionGroup
implements DumbAware {
    private static final String PASTE_FORMAT_KEY = "database.data.paste.format";

    public ChoosePasteFormatAction() {
        this.setPopup(true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ChoosePasteFormatAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabledAndVisible(!DatabaseSettings.getSettings().getCsvFormats().isEmpty());
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = ContainerUtil.concat((List[])new List[]{Arrays.asList(new AnAction[]{new PasteTypeAction(PasteType.AUTO, "Detect"), new PasteTypeAction(PasteType.SINGLE_VALUE, "Single Value"), new Separator()}), ContainerUtil.map(DatabaseSettings.getSettings().getCsvFormats(), f -> new FormatAction((CsvFormat)f)), Arrays.asList(new AnAction[]{new Separator(), new ShowCsvFormatsAction.ForImport()})}).toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            ChoosePasteFormatAction.$$$reportNull$$$0(1);
        }
        return anActionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ChoosePasteFormatAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ChoosePasteFormatAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class FormatParser
    implements Parser {
        private FormatParser() {
        }

        @Override
        @NotNull
        public List<String[]> parse(@NotNull Project project, @NotNull String value2) {
            CsvFormat format;
            if (project == null) {
                FormatParser.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                FormatParser.$$$reportNull$$$0(1);
            }
            CsvDocumentDataHookUp.CsvMarkup markup = (format = this.getFormat(project, value2)) == null ? null : new CsvFormatParser(format).parse(value2);
            List list = markup == null ? SingleValueParser.INSTANCE.parse(project, value2) : ContainerUtil.map(markup.rows, row -> (String[])ContainerUtil.map((Object[])row.values, o -> o == null ? null : o.toString(), (Object[])ArrayUtilRt.EMPTY_STRING_ARRAY));
            if (list == null) {
                FormatParser.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Nullable
        abstract CsvFormat getFormat(@NotNull Project var1, @NotNull String var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChoosePasteFormatAction$FormatParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChoosePasteFormatAction$FormatParser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SingleValueParser
    implements Parser {
        static final SingleValueParser INSTANCE = new SingleValueParser();

        private SingleValueParser() {
        }

        @Override
        @NotNull
        public List<String[]> parse(@NotNull Project project, @NotNull String value2) {
            if (project == null) {
                SingleValueParser.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                SingleValueParser.$$$reportNull$$$0(1);
            }
            List<String[]> list = Collections.singletonList(new String[]{value2});
            if (list == null) {
                SingleValueParser.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChoosePasteFormatAction$SingleValueParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChoosePasteFormatAction$SingleValueParser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Parser {
        @NotNull
        public List<String[]> parse(@NotNull Project var1, @NotNull String var2);
    }

    public static enum PasteType {
        AUTO{

            @Override
            @NotNull
            String getValueToSave(@Nullable CsvFormat format) {
                return PasteType.AUTO_PREFIX;
            }

            @Override
            boolean isCurrent(@NotNull String value2) {
                if (value2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return value2.equals(PasteType.AUTO_PREFIX);
            }

            @Override
            @NotNull
            public Parser getParser() {
                return new FormatParser(){

                    @Override
                    @Nullable
                    CsvFormat getFormat(@NotNull Project project, @NotNull String text2) {
                        if (project == null) {
                            PasteType.1.$$$reportNull$$$0(0);
                        }
                        if (text2 == null) {
                            PasteType.1.$$$reportNull$$$0(1);
                        }
                        return CsvFormatResolver.simplifyFormat(CsvFormatResolver.getFormat(project, (VirtualFile)new LightVirtualFile("dummy", (CharSequence)text2)));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "project";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "text";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/database/run/actions/ChoosePasteFormatAction$PasteType$1$1";
                        objectArray[2] = "getFormat";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }

            @Override
            @Nullable
            CsvFormat getFormat() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/actions/ChoosePasteFormatAction$PasteType$1", "isCurrent"));
            }
        }
        ,
        SINGLE_VALUE{

            @Override
            @NotNull
            String getValueToSave(@Nullable CsvFormat format) {
                return PasteType.SINGLE_PREFIX;
            }

            @Override
            boolean isCurrent(@NotNull String value2) {
                if (value2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return value2.equals(PasteType.SINGLE_PREFIX);
            }

            @Override
            @NotNull
            public Parser getParser() {
                SingleValueParser singleValueParser = SingleValueParser.INSTANCE;
                if (singleValueParser == null) {
                    2.$$$reportNull$$$0(1);
                }
                return singleValueParser;
            }

            @Override
            @Nullable
            CsvFormat getFormat() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/actions/ChoosePasteFormatAction$PasteType$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/actions/ChoosePasteFormatAction$PasteType$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getParser";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isCurrent";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
        ,
        FORMAT{

            @Override
            @NotNull
            String getValueToSave(@Nullable CsvFormat format) {
                String string = PasteType.FORMAT_PREFIX + Objects.requireNonNull(format).id;
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            boolean isCurrent(@NotNull String value2) {
                if (value2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                return value2.startsWith(PasteType.FORMAT_PREFIX);
            }

            @Override
            @NotNull
            public Parser getParser() {
                final CsvFormat format = CsvFormatResolver.simplifyFormat(this.getFormat());
                return format == null ? SingleValueParser.INSTANCE : new FormatParser(){

                    @Override
                    CsvFormat getFormat(@NotNull Project project, @NotNull String text2) {
                        if (project == null) {
                            PasteType.1.$$$reportNull$$$0(0);
                        }
                        if (text2 == null) {
                            PasteType.1.$$$reportNull$$$0(1);
                        }
                        return format;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "project";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "text";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/database/run/actions/ChoosePasteFormatAction$PasteType$3$1";
                        objectArray[2] = "getFormat";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }

            @Override
            @Nullable
            CsvFormat getFormat() {
                String value2 = PropertiesComponent.getInstance().getValue(ChoosePasteFormatAction.PASTE_FORMAT_KEY);
                String id = value2 == null || value2.length() <= PasteType.FORMAT_PREFIX.length() ? null : value2.substring(PasteType.FORMAT_PREFIX.length());
                List<CsvFormat> formats = DatabaseSettings.getSettings().getCsvFormats();
                return id == null ? null : (CsvFormat)ContainerUtil.find(formats, f -> f.id.equals(id));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/actions/ChoosePasteFormatAction$PasteType$3";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueToSave";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/actions/ChoosePasteFormatAction$PasteType$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isCurrent";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };

        private static final String FORMAT_PREFIX = "format:";
        private static final String AUTO_PREFIX = "auto";
        private static final String SINGLE_PREFIX = "single";

        void save(@Nullable CsvFormat format) {
            PropertiesComponent.getInstance().setValue(ChoosePasteFormatAction.PASTE_FORMAT_KEY, this.getValueToSave(format));
        }

        @NotNull
        public abstract Parser getParser();

        @NotNull
        abstract String getValueToSave(@Nullable CsvFormat var1);

        @Nullable
        abstract CsvFormat getFormat();

        abstract boolean isCurrent(@NotNull String var1);

        @NotNull
        public static PasteType get() {
            String value2 = PropertiesComponent.getInstance().getValue(ChoosePasteFormatAction.PASTE_FORMAT_KEY);
            if (value2 != null) {
                for (PasteType type : PasteType.values()) {
                    if (!type.isCurrent(value2)) continue;
                    PasteType pasteType = type;
                    if (pasteType == null) {
                        PasteType.$$$reportNull$$$0(0);
                    }
                    return pasteType;
                }
            }
            PasteType pasteType = AUTO;
            if (pasteType == null) {
                PasteType.$$$reportNull$$$0(1);
            }
            return pasteType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChoosePasteFormatAction$PasteType", "get"));
        }
    }

    private static class FormatAction
    extends PasteTypeAction {
        private final CsvFormat myFormat;

        FormatAction(@NotNull CsvFormat format) {
            if (format == null) {
                FormatAction.$$$reportNull$$$0(0);
            }
            super(PasteType.FORMAT, format.name);
            this.myFormat = format;
        }

        @Override
        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                FormatAction.$$$reportNull$$$0(1);
            }
            CsvFormat format = this.myType.getFormat();
            return super.isSelected(e) && StringUtil.equals((CharSequence)this.myFormat.id, (CharSequence)(format == null ? null : format.id));
        }

        @Override
        @Nullable
        CsvFormat getFormat() {
            return this.myFormat;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ChoosePasteFormatAction$FormatAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PasteTypeAction
    extends ToggleAction
    implements DumbAware {
        protected final PasteType myType;

        PasteTypeAction(@NotNull PasteType type, @NotNull String name) {
            if (type == null) {
                PasteTypeAction.$$$reportNull$$$0(0);
            }
            if (name == null) {
                PasteTypeAction.$$$reportNull$$$0(1);
            }
            super(name);
            this.myType = type;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                PasteTypeAction.$$$reportNull$$$0(2);
            }
            return PasteType.get() == this.myType;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                PasteTypeAction.$$$reportNull$$$0(3);
            }
            if (state) {
                this.myType.save(this.getFormat());
            }
        }

        @Nullable
        CsvFormat getFormat() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ChoosePasteFormatAction$PasteTypeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

