/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.GuiUtils;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbPsiFacadeImpl
extends DbPsiFacade {
    private final Project myProject;
    private final Map<DasDataSource, DbDataSource> myDataSourceMap;
    private volatile State myState;
    private final Alarm myAlarm;

    public DbPsiFacadeImpl(@NotNull Project project) {
        if (project == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(0);
        }
        this.myDataSourceMap = ContainerUtil.createWeakMap();
        this.myProject = project;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.myProject);
        this.myProject.getMessageBus().connect().subscribe(DataSourceManager.TOPIC, (Object)new DataSourceManager.Listener(){

            public <T extends DasDataSource> void dataSourceAdded(@NotNull DataSourceManager<T> manager, @NotNull T dataSource2) {
                if (manager == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (dataSource2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.clearCaches(manager, null);
            }

            public <T extends DasDataSource> void dataSourceRemoved(@NotNull DataSourceManager<T> manager, @NotNull T dataSource2) {
                if (manager == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (dataSource2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.clearCaches(manager, null);
            }

            public <T extends DasDataSource> void dataSourceChanged(@Nullable DataSourceManager<T> manager, @Nullable T dataSource2) {
                this.clearCaches(manager, dataSource2 == null ? null : dataSource2.getUniqueId());
            }

            private <T extends DasDataSource> void clearCaches(@Nullable DataSourceManager<T> manager, @Nullable String dataSourceId) {
                GuiUtils.invokeLaterIfNeeded(() -> DbPsiFacadeImpl.this.clearCachesImpl(manager, dataSourceId == null ? null : DbPsiFacadeImpl.this.findDataSource(dataSourceId)), (ModalityState)ModalityState.defaultModalityState(), (Condition)DbPsiFacadeImpl.this.myProject.getDisposed());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "manager";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSource";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/psi/DbPsiFacadeImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        DataSourceManager.EP_NAME.getExtensions((AreaInstance)project);
    }

    @NotNull
    public DataSourceManager<DasDataSource> getDataSourceManager(@NotNull DbDataSource dataSource2) {
        if (dataSource2 == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(1);
        }
        DataSourceManager<DasDataSource> dataSourceManager = ((DbDataSourceImpl)dataSource2).getDbManager();
        if (dataSourceManager == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(2);
        }
        return dataSourceManager;
    }

    public void clearCaches() {
        this.clearCachesImpl(null, null);
    }

    private void clearCachesImpl(@Nullable DataSourceManager<?> manager, @Nullable DbDataSource dataSource2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.incModificationCount();
        if (dataSource2 == null) {
            State state = this.myState;
            this.myState = null;
            if (state != null) {
                for (DbDataSource source : state.dataSources) {
                    if (manager != null && this.getDataSourceManager(source) != manager) continue;
                    ((DbDataSourceImpl)source).clearCaches();
                }
            }
        } else {
            ((DbDataSourceImpl)dataSource2).clearCaches();
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            ((DbPsiFacade.Listener)this.myProject.getMessageBus().syncPublisher(TOPIC)).onChanged((DbPsiFacade)this);
            PsiManager.getInstance((Project)this.myProject).dropPsiCaches();
            FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx((Project)this.getProject());
            String id = dataSource2 == null ? null : dataSource2.getUniqueId();
            for (VirtualFile file : fileEditorManager.getOpenFiles()) {
                DatabaseElementVirtualFileImpl dbFile = (DatabaseElementVirtualFileImpl)((Object)((Object)ObjectUtils.tryCast((Object)file, DatabaseElementVirtualFileImpl.class)));
                if (dbFile == null || id != null && !Objects.equals(dbFile.getDataSourceId(), id) || !dbFile.isValid()) continue;
                fileEditorManager.updateFilePresentation(file);
            }
        }, 300, ModalityState.NON_MODAL);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(3);
        }
        return project;
    }

    @NotNull
    public List<DbDataSource> getDataSources() {
        List<DbDataSource> list = this.getState().dataSources;
        if (list == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public DbDataSource findDataSource(@Nullable String id) {
        return this.getState().dataSourcesMap.get(id);
    }

    @Nullable
    public DbDataSource findDataSource(@Nullable DasObject o) {
        if (o == null) {
            return null;
        }
        if (o instanceof DbElement) {
            return ((DbElement)o).getDataSource();
        }
        if (o instanceof BasicElement) {
            BasicModel model = ((BasicElement)o).getModel();
            if (model == null) {
                return null;
            }
            return this.getState().rootsMap.get(model.getRoot());
        }
        return this.getState().rootsMap.get(DasUtil.dasParents((DasObject)o).last());
    }

    @Nullable
    public DbElement findElement(@Nullable DasObject o) {
        if (o == null) {
            return null;
        }
        if (o instanceof DbElement) {
            return (DbElement)o;
        }
        DbDataSource dataSource2 = this.findDataSource(o);
        return dataSource2 == null ? null : DbImplUtil.findElement(dataSource2, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public DbDataSource createDataSourceWrapperElement(@NotNull DasDataSource info, @NotNull DataSourceManager<?> manager) {
        if (info == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(5);
        }
        if (manager == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(6);
        }
        Map<DasDataSource, DbDataSource> map2 = this.myDataSourceMap;
        // MONITORENTER : map2
        DbDataSource dataSource2 = this.myDataSourceMap.get(info);
        if (dataSource2 == null) {
            dataSource2 = new DbDataSourceImpl(this.getProject(), info, manager);
            this.myDataSourceMap.put(info, dataSource2);
        }
        DbDataSource dbDataSource = dataSource2;
        // MONITOREXIT : map2
        if (dbDataSource != null) return dbDataSource;
        DbPsiFacadeImpl.$$$reportNull$$$0(7);
        return dbDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private State getState() {
        State state;
        State curState = this.myState;
        if (curState != null) {
            State state2 = curState;
            if (state2 == null) {
                DbPsiFacadeImpl.$$$reportNull$$$0(8);
            }
            return state2;
        }
        if (this.myProject.isDefault()) {
            state = new State(Collections.emptyList());
        } else {
            ArrayList<DbDataSource> result = new ArrayList<DbDataSource>();
            for (DataSourceManager manager : DataSourceManager.getManagers((Project)this.myProject)) {
                for (DasDataSource system : manager.getDataSources()) {
                    result.add(this.createDataSourceWrapperElement(system, manager));
                }
            }
            state = new State((List<DbDataSource>)ContainerUtil.immutableList(result));
        }
        this.myState = state;
        Map<DasDataSource, DbDataSource> map2 = this.myDataSourceMap;
        synchronized (map2) {
            this.myDataSourceMap.values().retainAll(state.dataSources);
        }
        State state3 = state;
        if (state3 == null) {
            DbPsiFacadeImpl.$$$reportNull$$$0(9);
        }
        return state3;
    }

    public void flushUpdates() {
        this.myAlarm.drainRequestsInTest();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbPsiFacadeImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbPsiFacadeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceWrapperElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceWrapperElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class State {
        final List<DbDataSource> dataSources;
        final Map<String, DbDataSource> dataSourcesMap;
        final Map<DasObject, DbDataSource> rootsMap;

        State(@NotNull List<DbDataSource> dataSources2) {
            if (dataSources2 == null) {
                State.$$$reportNull$$$0(0);
            }
            this.dataSources = dataSources2;
            this.dataSourcesMap = dataSources2.isEmpty() ? Collections.emptyMap() : new THashMap();
            for (DbDataSource dataSource2 : dataSources2) {
                this.dataSourcesMap.put(dataSource2.getUniqueId(), dataSource2);
            }
            this.rootsMap = ConcurrentFactoryMap.create(key -> {
                for (DbDataSource o : this.dataSources) {
                    DasModel model = o.getDelegate().getModel();
                    if (model instanceof BasicModel) {
                        if (((BasicModel)model).getRoot() != key) continue;
                        return o;
                    }
                    for (DasObject root2 : model.getModelRoots()) {
                        if (root2 != key && root2.getDasParent() != key) continue;
                        return o;
                    }
                }
                return null;
            }, () -> ContainerUtil.createConcurrentWeakKeyWeakValueMap((TObjectHashingStrategy)ContainerUtil.identityStrategy()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/psi/DbPsiFacadeImpl$State", "<init>"));
        }
    }
}

