/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.icons.AllIcons;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IconDeferrer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TObjectIntHashMap;
import icons.DatabaseIcons;
import java.util.Comparator;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbPresentation {
    public static final Comparator<String> NAMES_COMPARATOR = (s1, s2) -> StringUtil.compare((String)s1, (String)s2, (boolean)true);
    public static final String UNNAMED = "<unnamed>";
    private static final Map<ObjectKind, Icon> ourIcons = ContainerUtil.immutableMapBuilder().put((Object)ObjectKind.DATABASE, (Object)DatabaseIcons.Database).put((Object)ObjectKind.SCHEMA, (Object)DatabaseIcons.Schema).put((Object)ObjectKind.SEQUENCE, (Object)DatabaseIcons.Sequence).put((Object)ObjectKind.CLUSTER, (Object)DatabaseIcons.UnspecifiedCluster).put((Object)ObjectKind.TABLE, (Object)DatabaseIcons.Table).put((Object)ObjectKind.COLUMN, (Object)DatabaseIcons.Col).put((Object)ObjectKind.INDEX, (Object)DatabaseIcons.Index).put((Object)ObjectKind.KEY, (Object)DatabaseIcons.GoldKeyAlt).put((Object)ObjectKind.FOREIGN_KEY, (Object)DatabaseIcons.BlueKey).put((Object)ObjectKind.MAT_LOG, (Object)DatabaseIcons.MaterializedLog).put((Object)ObjectKind.MAT_VIEW, (Object)DatabaseIcons.MaterializedView).put((Object)ObjectKind.VIEW, (Object)AllIcons.Nodes.DataSchema).put((Object)ObjectKind.CHECK, (Object)DatabaseIcons.CheckConstraint).put((Object)ObjectKind.DEFAULT, (Object)DatabaseIcons.DefaultConstraint).put((Object)ObjectKind.RULE, (Object)DatabaseIcons.Rule).put((Object)ObjectKind.TRIGGER, (Object)DatabaseIcons.Trigger).put((Object)ObjectKind.PACKAGE, (Object)DatabaseIcons.Package).put((Object)ObjectKind.ALIAS_TYPE, (Object)AllIcons.Nodes.Type).put((Object)ObjectKind.TABLE_TYPE, (Object)AllIcons.Nodes.Type).put((Object)ObjectKind.OBJECT_TYPE, (Object)AllIcons.Nodes.Type).put((Object)ObjectKind.OBJECT_ATTRIBUTE, (Object)AllIcons.Nodes.ObjectTypeAttribute).put((Object)ObjectKind.COLLECTION_TYPE, (Object)DatabaseIcons.CollectionType).put((Object)ObjectKind.BODY, (Object)DatabaseIcons.Body).put((Object)ObjectKind.ROUTINE, (Object)DatabaseIcons.Routine).put((Object)ObjectKind.ARGUMENT, (Object)DatabaseIcons.Argument).put((Object)ObjectKind.OPERATOR, (Object)DatabaseIcons.Operator).put((Object)ObjectKind.VARIABLE, (Object)AllIcons.Nodes.Variable).put((Object)ObjectKind.SYNONYM, (Object)DatabaseIcons.Synonym).put((Object)ObjectKind.VIRTUAL_TABLE, (Object)DatabaseIcons.Table).put((Object)ObjectKind.SCRIPT, (Object)DatabaseIcons.Scripting_script).put((Object)ObjectKind.COLLATION, (Object)DatabaseIcons.Collation).put((Object)ObjectKind.CONNECTION, (Object)DatabaseIcons.Connector).put((Object)ObjectKind.USER, (Object)AllIcons.General.User).put((Object)ObjectKind.ROLE, (Object)DatabaseIcons.Role).put((Object)ObjectKind.FOREIGN_DATA_WRAPPER, (Object)DatabaseIcons.Foreign_datawrapper).put((Object)ObjectKind.FOREIGN_TABLE, (Object)DatabaseIcons.Foreign_table).put((Object)ObjectKind.SERVER, (Object)DatabaseIcons.Foreign_server).put((Object)ObjectKind.USER_MAPPING, (Object)DatabaseIcons.User_mapping).put((Object)ObjectKind.DB_LINK, (Object)DatabaseIcons.DatabaseLink).put((Object)ObjectKind.EXTERNAL_SCHEMA, (Object)DatabaseIcons.External_schema_object).put((Object)ObjectKind.SCHEDULED_EVENT, (Object)DatabaseIcons.ScheduledEvent).put((Object)ObjectKind.ACCESS_METHOD, (Object)DatabaseIcons.Access_method).put((Object)ObjectKind.AGGREGATE, (Object)DatabaseIcons.Aggregate).put((Object)ObjectKind.EXCEPTION, (Object)AllIcons.Nodes.ExceptionClass).put((Object)ObjectKind.EXTENSION, (Object)DatabaseIcons.Extension).put((Object)ObjectKind.LANGUAGE, (Object)DatabaseIcons.Extension).put((Object)ObjectKind.TABLESPACE, (Object)DatabaseIcons.Tablespace).put((Object)ObjectKind.MACRO, (Object)DatabaseIcons.Macro).put((Object)ObjectKind.PROJECTION, (Object)DatabaseIcons.Projection).put((Object)ObjectKind.DATA_FILE, (Object)DatabaseIcons.DataFile).put((Object)ObjectKind.PARTITION, (Object)DatabaseIcons.Partition).put((Object)ObjectKind.METHOD, (Object)AllIcons.Nodes.Method).put((Object)ObjectKind.WAREHOUSE, (Object)DatabaseIcons.Warehouse).put((Object)ObjectKind.FORMAT, (Object)DatabaseIcons.FileFormat).put((Object)ObjectKind.INDEX_EXTENSION, (Object)DatabaseIcons.IndexFun).put((Object)ObjectKind.INDEX_SEARCH_METHOD, (Object)DatabaseIcons.Access_method).put((Object)ObjectKind.CONSTANT, (Object)DatabaseIcons.Constant).build();
    private static final TObjectIntHashMap<ObjectKind> KIND_WEIGHTS = DbPresentation.buildWeights(ObjectKind.DATABASE, ObjectKind.DB_LINK, ObjectKind.SCHEMA, ObjectKind.EXTERNAL_SCHEMA, ObjectKind.TABLE, ObjectKind.FOREIGN_TABLE, ObjectKind.VIRTUAL_TABLE, ObjectKind.MAT_VIEW, ObjectKind.VIEW, ObjectKind.CLUSTER, ObjectKind.BODY, ObjectKind.ROUTINE, ObjectKind.AGGREGATE, ObjectKind.PACKAGE, ObjectKind.OPERATOR, ObjectKind.SEQUENCE, ObjectKind.ALIAS_TYPE, ObjectKind.OBJECT_TYPE, ObjectKind.TABLE_TYPE, ObjectKind.COLLECTION_TYPE, ObjectKind.COLLATION, ObjectKind.SYNONYM, ObjectKind.EXCEPTION, ObjectKind.VARIABLE, ObjectKind.OBJECT_ATTRIBUTE, ObjectKind.COLUMN, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.INDEX, ObjectKind.CHECK, ObjectKind.DEFAULT, ObjectKind.RULE, ObjectKind.TRIGGER, ObjectKind.PARTITION);

    @Nullable
    public static Icon getIcon(@Nullable ObjectKind kind) {
        return ourIcons.get(kind);
    }

    @Nullable
    public static Icon getIcon(@NotNull Dbms dbms, @Nullable ObjectKind kind) {
        if (dbms == null) {
            DbPresentation.$$$reportNull$$$0(0);
        }
        ModelHelper helper = ModelFacade.forDbms(dbms).getModelHelper();
        return helper.getIcon(kind);
    }

    @Nullable
    public static Icon getIcon(@NotNull BasicMetaObject<?> meta) {
        if (meta == null) {
            DbPresentation.$$$reportNull$$$0(1);
        }
        return DbPresentation.getIcon(meta.getModel().dbms, meta.kind);
    }

    @Nullable
    public static Icon getIcon(@NotNull DasObject c2) {
        if (c2 == null) {
            DbPresentation.$$$reportNull$$$0(2);
        }
        Dbms dbms = DbImplUtil.getDbms(c2);
        ModelHelper helper = ModelFacade.forDbms(dbms).getModelHelper();
        return helper.getIcon(c2);
    }

    @NotNull
    public static String getPresentableName(@NotNull DasObject o, boolean unnamed) {
        if (o == null) {
            DbPresentation.$$$reportNull$$$0(3);
        }
        DasObject d2 = o instanceof DbElement ? ((DbElement)o).getDelegate() : o;
        String name = d2 instanceof BasicNode ? ((BasicNode)d2).getDisplayName() : o.getName();
        String string = StringUtil.isEmpty((String)name) && unnamed ? UNNAMED : name;
        if (string == null) {
            DbPresentation.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static boolean isUnnamed(@NotNull DasObject o) {
        if (o == null) {
            DbPresentation.$$$reportNull$$$0(5);
        }
        if (StringUtil.isNotEmpty((String)o.getName())) {
            return false;
        }
        if (o.getKind() != ObjectKind.ROUTINE) {
            return true;
        }
        DasObject parent2 = o.getDasParent();
        return parent2 == null || parent2.getKind() != ObjectKind.PACKAGE;
    }

    @NotNull
    public static String getPresentableName(@NotNull ObjectKind o, @NotNull Dbms dbms) {
        if (o == null) {
            DbPresentation.$$$reportNull$$$0(6);
        }
        if (dbms == null) {
            DbPresentation.$$$reportNull$$$0(7);
        }
        String name = ModelFacade.forDbms(dbms).getModelHelper().getName(o);
        String string = StringUtil.toLowerCase((String)name);
        if (string == null) {
            DbPresentation.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String getPresentableName(@NotNull BasicMetaObject<?> meta) {
        if (meta == null) {
            DbPresentation.$$$reportNull$$$0(9);
        }
        return DbPresentation.getPresentableName(meta.kind, meta.getModel().dbms);
    }

    public static int getWeight(@NotNull ObjectKind kind, int groupCount) {
        int w;
        if (kind == null) {
            DbPresentation.$$$reportNull$$$0(10);
        }
        return (w = KIND_WEIGHTS.get((Object)kind)) != 0 ? w : 1000000 + kind.getOrder() * 1000 + groupCount;
    }

    public static int getWeight(@NotNull Object o, boolean sortPositioned) {
        int weight;
        BasicElement element2;
        Dbms dbms;
        int weight2;
        if (o == null) {
            DbPresentation.$$$reportNull$$$0(11);
        }
        if (o instanceof BasicElement && (weight2 = DatabaseStructure.Provider.forDbms(dbms = DbImplUtil.getDbms(element2 = (BasicElement)o)).getWeight(element2)) != -1) {
            return weight2;
        }
        ObjectKind kind = o instanceof DasObject ? ((DasObject)o).getKind() : ObjectKind.NONE;
        int n = weight = o instanceof WeighedItem ? ((WeighedItem)o).getWeight() : KIND_WEIGHTS.get((Object)kind);
        if (kind == ObjectKind.KEY && o instanceof DasTableKey && ((DasTableKey)o).isPrimary()) {
            --weight;
        }
        if (!sortPositioned && o instanceof DasPositioned) {
            return weight + ((DasPositioned)o).getPosition();
        }
        return weight;
    }

    @NotNull
    private static TObjectIntHashMap<ObjectKind> buildWeights(ObjectKind ... kinds) {
        TObjectIntHashMap res2 = new TObjectIntHashMap();
        for (int i2 = 0; i2 < kinds.length; ++i2) {
            res2.put((Object)kinds[i2], 1000 * (i2 + 1));
        }
        res2.compact();
        TObjectIntHashMap tObjectIntHashMap = res2;
        if (tObjectIntHashMap == null) {
            DbPresentation.$$$reportNull$$$0(12);
        }
        return tObjectIntHashMap;
    }

    public static String arrowToColumns(@Nullable String schemaName, @Nullable String tableName, @NotNull MultiRef<? extends DasTypedObject> columnsRef) {
        if (columnsRef == null) {
            DbPresentation.$$$reportNull$$$0(13);
        }
        String prefix = schemaName != null ? schemaName + "." : "";
        return StringUtil.isEmpty((String)tableName) ? "" : DbPresentation.arrow() + " " + prefix + tableName + " " + DbPresentation.multiRef(columnsRef);
    }

    @NotNull
    public static String multiRef(@NotNull MultiRef<? extends DasTypedObject> ref) {
        if (ref == null) {
            DbPresentation.$$$reportNull$$$0(14);
        }
        String string = ref.size() == 0 ? "" : "(" + StringUtil.join((Iterable)JBIterable.from((Iterable)ref.names()).filter(n -> n != null), (String)", ") + ")";
        if (string == null) {
            DbPresentation.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static String arrow() {
        String string = ApplicationManager.getApplication().isUnitTestMode() ? "->" : UIUtil.rightArrow();
        if (string == null) {
            DbPresentation.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbPresentation";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsRef";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbPresentation";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "buildWeights";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "multiRef";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "arrow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 15: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUnnamed";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getWeight";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "arrowToColumns";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "multiRef";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Provider
    extends PresentationProvider<DasObject> {
        @Nullable
        public String getName(@Nullable DasObject object) {
            return object == null ? null : DbPresentation.getPresentableName(object, true);
        }

        @Nullable
        public Icon getIcon(@Nullable DasObject object) {
            if (object == null) {
                return null;
            }
            Icon baseIcon = DbPresentation.getIcon(object.getKind());
            return IconDeferrer.getInstance().defer(baseIcon, (Object)object, DbPresentation::getIcon);
        }

        @Nullable
        public String getTypeName(DasObject object) {
            if (object == null) {
                return null;
            }
            Dbms dbms = DbImplUtil.getDbms(object);
            return DbPresentation.getPresentableName(object.getKind(), dbms);
        }
    }
}

