/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObjectWithSource;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SingleFragmentText;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nullable;

public interface BasicMixinSourceAware
extends DasObjectWithSource {
    @Nullable
    default public CompositeText getSourceText() {
        CompositeText compositeText;
        BasicSourceAware self = (BasicSourceAware)this;
        int length = self.getSourceTextLength();
        if (length == 0) {
            return null;
        }
        BasicModModel model = (BasicModModel)ObjectUtils.tryCast((Object)self.getModel(), BasicModModel.class);
        CompositeText compositeText2 = compositeText = model == null ? null : model.loadSourceText(self);
        if (compositeText == null) {
            String text2 = String.format("-- The source text is lost (family: %s, kind: %s, name:%s, source text length: %d)", (model == null ? Dbms.UNKNOWN : model.getDbms()).getName(), self.getKind().code(), self.getRealName(), length);
            return new SingleFragmentText(text2, CompositeText.Kind.COMMENT);
        }
        return compositeText;
    }

    @Nullable
    default public CharSequence getOriginalSourceText() {
        int length = ((BasicSourceAware)this).getSourceTextLength();
        if (length == 0) {
            return null;
        }
        CompositeText ct = this.getSourceText();
        if (ct != null) {
            if (ct instanceof SingleFragmentText) {
                return ct.getText();
            }
            CompositeText.Fragment content = ct.getContent();
            if (content == null) {
                return null;
            }
            return content.getText();
        }
        return null;
    }
}

