/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbElement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableConsumer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgDialectHelper {
    public static String getTableDefinition(DasTable table, DatabaseConnection connection2) throws Exception {
        Serializable idx;
        String tableName = table.getName();
        String schemaName = DasUtil.getSchema((DasObject)table);
        Dbms dbms = connection2.getDbms();
        String columnsQuery = "select  att.*,  def.*,  pg_catalog.pg_get_expr(def.adbin, def.adrelid) as defval,  case when att.attndims > 0 then 1 else 0 end as isarray,  format_type(ty.oid, NULL) as typname,  format_type(ty.oid, att.atttypmod) as displaytypname,  tn.nspname as typnspname,  et.typname as elemtypname,  ty.typstorage as defaultstorage,  cl.relname,  na.nspname,  att.attstattarget,  description,  cs.relname as sername,  ns.nspname as serschema,  (select     count(1)   from pg_type t2 where t2.typname = ty.typname) > 1 as isdup,  indkey from pg_attribute att  join pg_type ty on ty.oid = atttypid  join pg_namespace tn on tn.oid = ty.typnamespace  join pg_class cl on cl.oid = att.attrelid  join pg_namespace na on na.oid = cl.relnamespace  left outer join pg_type et on et.oid = ty.typelem  left outer join pg_attrdef def on adrelid = att.attrelid and adnum = att.attnum  left outer join pg_description des on des.objoid = att.attrelid and des.objsubid = att.attnum  left outer join (pg_depend join pg_class cs on objid = cs.oid and cs.relkind = 'S') on refobjid = att.attrelid and refobjsubid = att.attnum  left outer join pg_namespace ns on ns.oid = cs.relnamespace  left outer join pg_index pi on pi.indrelid = att.attrelid and indisprimary where     cl.relname = " + PgDialectHelper.str(tableName) + "      and na.nspname = " + PgDialectHelper.str(schemaName) + (dbms == Dbms.COCKROACH ? "" : "      and att.attstattarget = -1") + "order by att.attnum";
        DdlBuilder builder = new DdlBuilder().withDialect(DbImplUtil.getDatabaseDialect(dbms)).qualifyReferences(true);
        if (table instanceof DbElement) {
            builder.configureFor((DbElement)table);
        }
        int spaces = 2;
        HashMap<String, String> map2 = new HashMap<String, String>();
        LinkedHashMap<String, String> columnsComments = new LinkedHashMap<String, String>();
        HashSet pkIndices = new HashSet();
        DdlBuilder.Marker marker = null;
        builder.keywords("create", "table").space().qualifiedRef((DasObject)table).space().symbol("(");
        SmartStatements statements2 = SmartStatements.poweredBy(connection2);
        try (ClosableResultsProducer producer = statements2.simple().noisy().execute(columnsQuery, StandardExecutionMode.QUERY);){
            Object rs2;
            Object object = rs2 = producer.advance() ? producer.processCurrent(StandardResultsProcessors.RESULT_SET) : null;
            while (rs2 != null && rs2.next()) {
                String defval;
                builder.newLine();
                String attname = rs2.getString("attname");
                idx = Integer.valueOf(rs2.getInt("attnum"));
                map2.put(String.valueOf(idx), attname);
                builder.space(spaces).identifier(attname).space().type(rs2.getString("displaytypname"));
                String indkey = rs2.getString("indkey");
                if (indkey != null) {
                    List indKeys = StringUtil.split((String)indkey, (String)" ");
                    pkIndices.addAll(indKeys);
                }
                if (pkIndices.size() == 1 && pkIndices.contains(String.valueOf(idx))) {
                    builder.space().keywords("primary", "key");
                }
                if (rs2.getBoolean("attnotnull")) {
                    builder.space().keywords("not", "null");
                }
                if ((defval = rs2.getString("defval")) != null) {
                    builder.space().keywords("default").space().literal(PgDialectHelper.normalizeDefaultExpression(defval));
                }
                if (marker != null) {
                    marker.finish();
                }
                marker = builder.mark();
                builder.symbol(",");
                String comment = rs2.getString("description");
                if (comment == null) continue;
                columnsComments.put(attname, comment);
                builder.space().comment(comment);
            }
        }
        boolean needComma = false;
        if (pkIndices.size() > 1) {
            builder.newLine().space(spaces).keywords("primary", "key").space().symbol("(");
            needComma = true;
            boolean first2 = true;
            for (String pk : pkIndices) {
                if (first2) {
                    first2 = false;
                } else {
                    builder.symbol(",").space();
                }
                builder.constraintRef(null, (String)ObjectUtils.notNull(map2.get(pk), (Object)pk));
            }
            builder.symbol(")");
        }
        if (map2.size() == 1) {
            builder.newLine().symbol(")").symbol(";");
        } else {
            String foreignKeysQuery = "select  ct.oid,  conname,  condeferrable,  condeferred,  confupdtype,  confdeltype,  confmatchtype,  array_to_string(conkey, ' ') as conkey,  array_to_string(confkey, ' ') as confkey,  confrelid,  nl.nspname as fknsp,  cl.relname as fktab,  nr.nspname as refnsp,  cr.relname as reftab,  description from pg_constraint ct  join pg_class cl on cl.oid = conrelid  join pg_namespace nl on nl.oid = cl.relnamespace  join pg_class cr on cr.oid = confrelid  join pg_namespace nr on nr.oid = cr.relnamespace  left outer join pg_description des on des.objoid = ct.oid where contype = 'f'      and cl.relname = " + PgDialectHelper.str(tableName) + "      and nl.nspname = " + PgDialectHelper.str(schemaName) + "order by conname";
            ArrayList<ForeignKeyWrapper> fkws = new ArrayList<ForeignKeyWrapper>(0);
            ClosableResultsProducer producer = statements2.simple().noisy().execute(foreignKeysQuery, StandardExecutionMode.QUERY);
            idx = null;
            try {
                RemoteResultSet rs3;
                RemoteResultSet remoteResultSet = rs3 = producer.advance() ? producer.processCurrent(StandardResultsProcessors.RESULT_SET) : null;
                while (rs3 != null && rs3.next()) {
                    String conkey = rs3.getString("conkey");
                    String confkey = rs3.getString("confkey");
                    String refnsp = rs3.getString("refnsp");
                    String reftab = rs3.getString("reftab");
                    String confrelid = rs3.getString("confrelid");
                    String update2 = rs3.getString("confupdtype");
                    String delete = rs3.getString("confdeltype");
                    String match2 = rs3.getString("confmatchtype");
                    fkws.add(new ForeignKeyWrapper(conkey, confkey, refnsp, reftab, confrelid, update2, delete, match2));
                }
            }
            catch (Throwable rs3) {
                idx = rs3;
                throw rs3;
            }
            finally {
                if (producer != null) {
                    if (idx != null) {
                        try {
                            producer.close();
                        }
                        catch (Throwable rs3) {
                            ((Throwable)idx).addSuppressed(rs3);
                        }
                    } else {
                        producer.close();
                    }
                }
            }
            for (ForeignKeyWrapper f : fkws) {
                String conkey = f.myConkey;
                String confkey = f.myConfkey;
                String refnsp = f.myRefnsp;
                String reftab = f.myReftab;
                String confrelid = f.myConfrelid;
                String update3 = f.myUpdate;
                String delete = f.myDelete;
                String match3 = f.myMatch;
                (needComma ? builder.symbol(",") : builder).newLine().space(spaces).keywords("foreign", "key").space().symbol("(");
                needComma = true;
                if (conkey != null) {
                    List split = StringUtil.split((String)conkey, (String)" ");
                    boolean first3 = true;
                    for (String id : split) {
                        if (first3) {
                            first3 = false;
                        } else {
                            builder.symbol(",").space();
                        }
                        builder.identifier((String)ObjectUtils.notNull(map2.get(id), (Object)id));
                    }
                }
                builder.symbol(")").space().keyword("references").space();
                if (refnsp != null) {
                    builder.identifier(refnsp).symbol(".");
                }
                builder.identifier(StringUtil.notNullize((String)reftab)).space().symbol("(");
                if (confkey != null) {
                    Ref first4 = Ref.create((Object)Boolean.TRUE);
                    List split = StringUtil.split((String)confkey, (String)" ");
                    for (String id : split) {
                        String attrQuery = "select * from pg_catalog.pg_attribute where attrelid = " + confrelid + " AND attnum = " + id;
                        statements2.simple().noisy().execute(attrQuery, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.results((ThrowableConsumer<RemoteResultSet, Exception>)((ThrowableConsumer)rs -> {
                            if (rs.next()) {
                                String attname = rs.getString("attname");
                                if (first4.get() == Boolean.TRUE) {
                                    first4.set((Object)false);
                                } else {
                                    builder.symbol(",").space();
                                }
                                builder.identifier(attname);
                            }
                        })));
                    }
                }
                builder.symbol(")");
                builder.newLine().space(spaces).keyword("match").space();
                builder.keyword("f".equals(match3) ? "full" : ("u".equals(match3) || "s".equals(match3) ? "simple" : "Unknown"));
                builder.space().keywords("on", "update").space().keyword(PgDialectHelper.getAction(update3));
                builder.space().keywords("on", "delete").space().keyword(PgDialectHelper.getAction(delete));
            }
            builder.newLine().symbol(")").symbol(";");
            String indexQuery = "select  ind_name.relname,  am.amname,  pg_get_expr(indexprs, indrelid) indexprs_txt,  pg_get_expr(indpred, indrelid) indpred_txt,  *from pg_catalog.pg_index ind  join pg_catalog.pg_class rel on rel.oid = ind.indrelid  join pg_namespace na on na.oid = rel.relnamespace  join pg_catalog.pg_class ind_name on ind_name.oid = ind.indexrelid  join pg_catalog.pg_am am on am.oid=ind_name.relam where ind.indisprimary = false and rel.relname = " + PgDialectHelper.str(tableName) + "and na.nspname = " + PgDialectHelper.str(schemaName);
            try (ClosableResultsProducer producer2 = statements2.simple().noisy().execute(indexQuery, StandardExecutionMode.QUERY);){
                RemoteResultSet rs4;
                RemoteResultSet remoteResultSet = rs4 = producer2.advance() ? producer2.processCurrent(StandardResultsProcessors.RESULT_SET) : null;
                while (rs4 != null && rs4.next()) {
                    String exprList;
                    builder.newLine().keyword("create");
                    boolean isUnique = rs4.getBoolean("indisunique");
                    if (isUnique) {
                        builder.space().keyword("unique");
                    }
                    String[] exprs = (exprList = rs4.getString("indexprs_txt")) == null ? null : exprList.split(",\\s+");
                    int exprId = 0;
                    String pred = rs4.getString("indpred_txt");
                    String indexName = rs4.getString("relname");
                    builder.space().keyword("index").space().identifier(indexName).space().keyword("on").space();
                    builder.identifier(table.getName());
                    builder.space().keyword("using").space().keyword(rs4.getString("amname")).space().symbol("(");
                    String indkey = rs4.getString("indkey");
                    if (indkey != null) {
                        List split = StringUtil.split((String)indkey, (String)" ");
                        boolean first5 = true;
                        for (String id : split) {
                            if (first5) {
                                first5 = false;
                            } else {
                                builder.symbol(",").space();
                            }
                            String col = (String)map2.get(id);
                            if (col != null) {
                                builder.identifier(col);
                                continue;
                            }
                            if (exprs != null && exprId < exprs.length) {
                                builder.symbol("(").plain(PgDialectHelper.normalizeDefaultExpression(exprs[exprId])).symbol(")");
                                ++exprId;
                                continue;
                            }
                            builder.identifier(id);
                        }
                    }
                    builder.symbol(")");
                    if (pred != null) {
                        builder.space().keyword("WHERE").space().plain(PgDialectHelper.normalizeDefaultExpression(pred));
                    }
                    builder.symbol(";");
                }
            }
        }
        if (marker != null) {
            if (!needComma) {
                marker.replace(marker.extract().replaceFirst(",", ""));
            }
            marker.finish();
        }
        PgDialectHelper.generateComments(table, connection2, tableName, schemaName, builder, columnsComments);
        return builder.getStatement();
    }

    private static void generateComments(DasTable table, DatabaseConnection connection2, String tableName, String schemaName, DdlBuilder builder, Map<String, String> columnsComments) throws Exception {
        String commentQuery = "select  obj_description(cl.oid) as description from pg_class cl  join pg_namespace na on na.oid = cl.relnamespace where     cl.relname = " + PgDialectHelper.str(tableName) + "      and na.nspname = " + PgDialectHelper.str(schemaName);
        String description = (String)SmartStatements.poweredBy(connection2).simple().noisy().execute(commentQuery, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.throwableResultsTransformer(rs -> {
            String result = null;
            if (rs.next()) {
                result = rs.getString("description");
            }
            return result;
        }));
        if (description != null) {
            builder.newLine().keywords("comment", "on", "table").space().qualifiedRef((DasObject)table).space().keyword("is").space().literal("'" + DbImplUtil.escapeStr(description) + "'").symbol(";");
        }
        for (Map.Entry<String, String> entry : columnsComments.entrySet()) {
            builder.newLine().keywords("comment", "on", "column").space().qualifiedRef((DasObject)table).symbol(".").identifier(entry.getKey()).space().keyword("is").space().literal("'" + DbImplUtil.escapeStr(entry.getValue()) + "'").symbol(";");
        }
    }

    @NotNull
    private static String getAction(@Nullable String delete) {
        String unknown = "Unknown";
        if (delete == null) {
            String string = unknown;
            if (string == null) {
                PgDialectHelper.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = delete.equals("a") ? "no action" : (delete.equals("r") ? "restrict" : (delete.equals("c") ? "cascade" : (delete.equals("d") ? "set default" : (delete.equals("n") ? "set null" : unknown))));
        if (string == null) {
            PgDialectHelper.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String normalizeDefaultExpression(@NotNull String expression) {
        if (expression == null) {
            PgDialectHelper.$$$reportNull$$$0(2);
        }
        String string = expression.replace("::character varying", "");
        if (string == null) {
            PgDialectHelper.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static String typeArg(String table, String alias, String oid, boolean isPre81) {
        if (!isPre81) {
            return String.format("%1$s.typname AS %2$s, %1$s.oid <> %3$s AS _%2$s", table, alias, oid);
        }
        String shortName = "case when %1$s.typelem = 0 then %1$s.typname else (select tmp.typname from pg_type as tmp where %1$s.typelem = tmp.oid limit 1) end";
        return String.format(shortName + " AS %2$s, %1$s.typelem <> 0 AS _%2$s", table, alias);
    }

    @NotNull
    public static String select(int limit, boolean isPre81) {
        StringBuilder b2 = new StringBuilder();
        for (int i2 = 1; i2 <= limit; ++i2) {
            b2.append(PgDialectHelper.typeArg("t" + i2, "arg" + i2, "proargtypes[" + (i2 - 1) + "]", isPre81)).append(", ");
            if (!isPre81) {
                b2.append(PgDialectHelper.typeArg("at" + i2, "targ" + i2, "proallargtypes[" + i2 + "]", isPre81)).append(", ");
            }
            b2.append("proargnames[").append(i2).append("] AS an").append(i2).append(", ");
        }
        String string = b2.toString();
        if (string == null) {
            PgDialectHelper.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String str(@Nullable String s) {
        String string = s == null ? "NULL" : "'" + s.replace("'", "''") + "'";
        if (string == null) {
            PgDialectHelper.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static String joinType(String tAlias, String oid, boolean isPre81) {
        return String.format("LEFT JOIN pg_type %1$s ON %1$s.oid = %2$s" + (isPre81 ? "" : " AND %1$s.typelem = 0 OR %1$s.typarray = %2$s"), tAlias, oid);
    }

    @NotNull
    public static String join(int limit, boolean isPre81) {
        StringBuilder b2 = new StringBuilder();
        for (int i2 = 1; i2 <= limit; ++i2) {
            b2.append(PgDialectHelper.joinType("t" + i2, "proargtypes[" + (i2 - 1) + "]", isPre81)).append("\n");
            if (isPre81) continue;
            b2.append(PgDialectHelper.joinType("at" + i2, "proallargtypes[" + i2 + "]", isPre81)).append("\n");
        }
        String string = b2.toString();
        if (string == null) {
            PgDialectHelper.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static DdlBuilder type(DdlBuilder builder, String type, boolean array) {
        builder.type(type);
        if (array) {
            builder.symbol("[]");
        }
        return builder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/PgDialectHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/PgDialectHelper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeDefaultExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "str";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "normalizeDefaultExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SignatureBuilder {
        private final boolean myPre81;
        private final RemoteResultSet myRs;
        private Object[] myModes;
        private int myLen;
        private boolean myRetTable;

        public SignatureBuilder(boolean isPre81, RemoteResultSet rs) {
            this.myPre81 = isPre81;
            this.myRs = rs;
        }

        public DdlBuilder buildArguments(DdlBuilder builder) throws Exception {
            long numArgs = this.myRs.getLong("pronargs");
            this.myModes = this.myPre81 ? null : (Object[])ObjectUtils.tryCast((Object)this.myRs.getObject("proargmodes"), Object[].class);
            String proargdefaults = this.myPre81 ? null : this.myRs.getString("proargdefaults");
            String[] defaults = proargdefaults == null ? null : proargdefaults.split(",\\s+");
            this.myLen = this.myModes == null ? (int)numArgs : this.myModes.length;
            boolean first2 = true;
            this.myRetTable = false;
            for (int i2 = 1; i2 <= this.myLen; ++i2) {
                String def;
                boolean typeArr;
                boolean hasDefault;
                Object mode;
                Object object = mode = this.myModes == null ? null : this.myModes[i2 - 1];
                if ("t".equals(mode)) {
                    this.myRetTable = true;
                    continue;
                }
                boolean bl = hasDefault = !"o".equals(mode) && defaults != null && i2 > this.myLen - defaults.length;
                mode = "o".equals(mode) ? "out" : ("i".equals(mode) ? "in" : ("b".equals(mode) ? "inout" : ("v".equals(mode) ? "variadic" : "")));
                String name = this.myRs.getString("an" + i2);
                String type = this.myPre81 ? null : this.myRs.getString("targ" + i2);
                boolean bl2 = typeArr = !this.myPre81 && this.myRs.getBoolean("_targ" + i2) == Boolean.TRUE.booleanValue();
                if (type == null) {
                    type = this.myRs.getString("arg" + i2);
                    typeArr = this.myRs.getBoolean("_arg" + i2) == Boolean.TRUE.booleanValue();
                }
                String string = def = !hasDefault ? null : PgDialectHelper.normalizeDefaultExpression(defaults[i2 - 1 - this.myLen + defaults.length]);
                if (first2) {
                    first2 = false;
                } else {
                    builder.symbol(",").space();
                }
                if (!StringUtil.isEmpty((String)String.valueOf(mode))) {
                    builder.keyword(String.valueOf(mode)).space();
                }
                if (!StringUtil.isEmpty((String)name)) {
                    builder.identifier(name).space();
                }
                if (!StringUtil.isEmpty((String)type)) {
                    PgDialectHelper.type(builder, type, typeArr);
                }
                if (StringUtil.isEmpty((String)def)) continue;
                builder.space().symbol("=").space().plain(def);
            }
            return builder;
        }

        public DdlBuilder buildReturn(DdlBuilder builder) throws Exception {
            if (this.myRs.getBoolean("proretset")) {
                if (!this.myRetTable) {
                    builder.keyword("SETOF").space();
                    PgDialectHelper.type(builder, this.myRs.getString("rettype"), this.myRs.getBoolean("_rettype") == Boolean.TRUE.booleanValue());
                } else {
                    builder.keyword("TABLE").symbol("(");
                    boolean f = true;
                    for (int i2 = 1; i2 <= this.myLen; ++i2) {
                        boolean typeArr;
                        if (!"t".equals(this.myModes[i2 - 1])) continue;
                        String name = this.myRs.getString("an" + i2);
                        String type = this.myPre81 ? null : this.myRs.getString("targ" + i2);
                        boolean bl = typeArr = this.myRs.getBoolean("_targ" + i2) == Boolean.TRUE.booleanValue();
                        if (type == null) {
                            type = this.myRs.getString("arg" + i2);
                            boolean bl2 = typeArr = this.myRs.getBoolean("_arg" + i2) == Boolean.TRUE.booleanValue();
                        }
                        if (!f) {
                            builder.symbol(",").space();
                        } else {
                            f = false;
                        }
                        builder.identifier((String)ObjectUtils.chooseNotNull((Object)name, (Object)("a" + i2))).space();
                        PgDialectHelper.type(builder, (String)ObjectUtils.chooseNotNull((Object)type, (Object)"any"), typeArr);
                    }
                    builder.symbol(")");
                }
            } else {
                PgDialectHelper.type(builder, StringUtil.notNullize((String)this.myRs.getString("rettype")), this.myRs.getBoolean("_rettype") == Boolean.TRUE.booleanValue());
            }
            return builder;
        }
    }

    static class ForeignKeyWrapper {
        @Nullable
        private final String myConkey;
        @Nullable
        private final String myConfkey;
        @Nullable
        private final String myRefnsp;
        @Nullable
        private final String myReftab;
        @Nullable
        private final String myConfrelid;
        @Nullable
        private final String myUpdate;
        @Nullable
        private final String myDelete;
        @Nullable
        private final String myMatch;

        ForeignKeyWrapper(@Nullable String conkey, @Nullable String confkey, @Nullable String refnsp, @Nullable String reftab, @Nullable String confrelid, @Nullable String update2, @Nullable String delete, @Nullable String match2) {
            this.myConkey = conkey;
            this.myConfkey = confkey;
            this.myRefnsp = refnsp;
            this.myReftab = reftab;
            this.myConfrelid = confrelid;
            this.myUpdate = update2;
            this.myDelete = delete;
            this.myMatch = match2;
        }
    }
}

