/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.TextCopyProvider;
import com.intellij.ide.actions.SearchWebAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceTestConnectionPanel {
    private JPanel myPanel;
    private JButton myTestConnectionButton;
    private JEditorPane myMessagePane;
    private JLabel myIcon;
    private ActionLink myTroubleshootLink;
    private JBScrollPane myMessageScroll;
    private JPanel myContent;
    private JPanel myActions;
    private Status myStatus;
    private JComponent myWidget;
    private final ActionToolbar myToolbar;

    public DataSourceTestConnectionPanel(@NotNull DataSourceConfigurable configurable) {
        if (configurable == null) {
            DataSourceTestConnectionPanel.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myMessagePane.addHyperlinkListener(e -> {
            if (this.myStatus == null || e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            String desc = e.getDescription();
            if (desc == null || !desc.startsWith("fix")) {
                return;
            }
            int idx = StringUtil.parseInt((String)StringUtil.trimStart((String)desc, (String)"fix"), (int)-1);
            if (idx < 0 || idx >= this.myStatus.fixes.size()) {
                return;
            }
            DataSourceUiUtil.applyFix(configurable.getProject(), this.myStatus.fixes.get(0), configurable.getController());
        });
        this.myTestConnectionButton.setAction(configurable.getTestAction());
        this.myIcon.setBorder((Border)JBUI.Borders.emptyTop((int)6));
        this.myMessageScroll.setBorder((Border)JBUI.Borders.empty());
        this.myActions.setLayout(new BoxLayout(this.myActions, 1));
        this.myToolbar = ActionManager.getInstance().createActionToolbar("toolbar", this.createToolbarGroup(), false);
        this.myToolbar.setTargetComponent((JComponent)this.myMessagePane);
        this.myToolbar.getComponent().setAlignmentX(0.5f);
        this.myToolbar.setLayoutPolicy(0);
        this.myActions.add(this.myToolbar.getComponent());
        TextComponentCopyProvider provider = new TextComponentCopyProvider(this.myMessagePane);
        DataManager.registerDataProvider((JComponent)this.myMessagePane, arg_0 -> DataSourceTestConnectionPanel.lambda$new$1((CopyProvider)provider, arg_0));
        this.applyState();
    }

    @NotNull
    private ActionGroup createToolbarGroup() {
        return new ActionGroup(){
            final AnAction myCopy = ActionManager.getInstance().getAction("$Copy");
            final AnAction mySearch = ActionUtil.copyFrom((AnAction)new SearchWebAction(){

                public void update(@NotNull AnActionEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    event.getPresentation().setIcon(AllIcons.General.Web);
                    super.update(event);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/dataSource/DataSourceTestConnectionPanel$1$1", "update"));
                }
            }, (String)"$SearchWeb");

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                AnAction[] anActionArray = DataSourceTestConnectionPanel.this.myStatus != null && ((DataSourceTestConnectionPanel)DataSourceTestConnectionPanel.this).myStatus.fail ? (AnAction[])ContainerUtil.ar((Object[])new AnAction[]{this.myCopy, this.mySearch}) : (AnAction[])ContainerUtil.ar((Object[])new AnAction[]{this.myCopy});
                if (anActionArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return anActionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceTestConnectionPanel$1", "getChildren"));
            }
        };
    }

    public void setWidget(@NotNull JComponent w) {
        if (w == null) {
            DataSourceTestConnectionPanel.$$$reportNull$$$0(1);
        }
        this.myWidget = w;
        this.myContent.add((Component)this.myWidget, "North");
    }

    public void setState(@Nullable Status status) {
        if (this.myStatus == status) {
            return;
        }
        this.myStatus = status;
        this.applyState();
    }

    private void applyState() {
        boolean failed = this.myStatus != null && this.myStatus.fail;
        String details = StringUtil.notNullize(this.myStatus == null ? null : this.myStatus.details);
        this.myIcon.setVisible(this.myStatus != null);
        this.myIcon.setIcon(failed ? AllIcons.General.Error : AllIcons.General.InspectionsOK);
        this.myToolbar.getComponent().setVisible(this.myStatus != null);
        this.myTroubleshootLink.setVisible(failed);
        this.myMessageScroll.setVisible(this.myStatus != null);
        this.myMessagePane.setVisible(this.myStatus != null);
        this.myMessagePane.setForeground((Color)(failed ? Status.FAIL_COLOR : Status.OK_COLOR));
        this.myMessagePane.setText("<html><pre style='font-family: " + this.myMessagePane.getFont().getFamily() + ";'>" + StringUtil.escapeXmlEntities((String)details) + this.formatFixes() + "</pre></html>");
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    @NotNull
    private String formatFixes() {
        if (this.myStatus == null || this.myStatus.fixes.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("<br>");
        for (int i2 = 0; i2 < this.myStatus.fixes.size(); ++i2) {
            sb.append("&emsp;<a href=\"fix").append(i2).append("\">").append(this.myStatus.fixes.get(i2).getName()).append("</a>");
        }
        String string = sb.toString();
        if (string == null) {
            DataSourceTestConnectionPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    private void createUIComponents() {
        this.myPanel = new JPanel();
        ComponentUtil.putClientProperty((JComponent)this.myPanel, DatabaseConfigEditor.DO_NOT_WATCH, (Object)true);
        this.myTroubleshootLink = new ActionLink("", new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                DataSourceUiUtil.showTroubleshooting();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceTestConnectionPanel$2", "actionPerformed"));
            }
        });
        this.myMessagePane = Messages.configureMessagePaneUi((JTextPane)new JTextPane(), (String)"<html>", (UIUtil.FontSize)UIUtil.FontSize.SMALL);
        this.myMessagePane.setPreferredSize((Dimension)JBUI.size((int)100, (int)100));
    }

    private static /* synthetic */ Object lambda$new$1(CopyProvider provider, String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return provider;
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JBScrollPane jBScrollPane;
        JPanel jPanel;
        JLabel jLabel;
        JPanel jPanel2;
        this.createUIComponents();
        JPanel jPanel3 = this.myPanel;
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myActions = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 5, 0, 0, 7, null, null, null, 0, true));
        this.myIcon = jLabel = new JLabel();
        jLabel.setAlignmentX(0.5f);
        jLabel.setText("");
        jPanel2.add((Component)jLabel, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 1, 1, 5, 0, 3, 3, 3, null, null, null));
        this.myContent = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, "Center");
        this.myMessageScroll = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(30);
        jBScrollPane.setVerticalScrollBarPolicy(21);
        jPanel.add((Component)jBScrollPane, "Center");
        JEditorPane jEditorPane = this.myMessagePane;
        jEditorPane.setEditable(false);
        jBScrollPane.setViewportView(jEditorPane);
        this.myTestConnectionButton = jButton = new JButton();
        jButton.setText("Test Connection");
        jPanel3.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        ActionLink actionLink = this.myTroubleshootLink;
        actionLink.setText("Troubleshooting");
        jPanel3.add((Component)actionLink, new GridConstraints(0, 5, 1, 1, 4, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceTestConnectionPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceTestConnectionPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setWidget";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TextComponentCopyProvider
    extends TextCopyProvider {
        private final JTextComponent myComponent;

        private TextComponentCopyProvider(@NotNull JTextComponent component) {
            if (component == null) {
                TextComponentCopyProvider.$$$reportNull$$$0(0);
            }
            this.myComponent = component;
        }

        @Nullable
        public Collection<String> getTextLinesToCopy() {
            String text2 = this.myComponent.getSelectedText();
            if (StringUtil.isEmpty((String)text2)) {
                try {
                    text2 = this.myComponent.getDocument().getText(0, this.myComponent.getDocument().getLength());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return ContainerUtil.createMaybeSingletonList((Object)StringUtil.nullize((String)text2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/dataSource/DataSourceTestConnectionPanel$TextComponentCopyProvider", "<init>"));
        }
    }

    public static class Status {
        public static final JBColor FAIL_COLOR = new JBColor(10944523, 12864337);
        public static final JBColor OK_COLOR = JBColor.GRAY;
        public final boolean fail;
        @Nullable
        public final String details;
        public final List<DatabaseErrorHandler.Fix> fixes;

        public Status(boolean fail, @Nullable String details, @NotNull List<DatabaseErrorHandler.Fix> fixes) {
            if (fixes == null) {
                Status.$$$reportNull$$$0(0);
            }
            this.fail = fail;
            this.details = details;
            this.fixes = fixes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/database/dataSource/DataSourceTestConnectionPanel$Status", "<init>"));
        }
    }
}

