/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum LogicalType {
    TEXT_ID{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                1.$$$reportNull$$$0(0);
            }
            return logicalType == BINARY_ID ? 102 : (logicalType == UUID ? 101 : super.getSuitability(logicalType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$1", "getSuitability"));
        }
    }
    ,
    UUID{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                2.$$$reportNull$$$0(0);
            }
            return logicalType == TEXT_ID ? 102 : (logicalType == BINARY_ID ? 101 : super.getSuitability(logicalType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$2", "getSuitability"));
        }
    }
    ,
    BINARY_ID{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                3.$$$reportNull$$$0(0);
            }
            return logicalType == TEXT_ID ? 102 : (logicalType == UUID ? 101 : super.getSuitability(logicalType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$3", "getSuitability"));
        }
    }
    ,
    NUMBER_RANGE,
    TIMESTAMP_RANGE,
    TIMESTAMP_TZ_RANGE,
    POINT,
    JSON,
    GEOMETRY,
    GEOGRAPHY,
    INTERVAL,
    TIMESTAMP_WITH_TZ_RANGE,
    DATE_RANGE,
    SERIAL,
    NTEXT{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                4.$$$reportNull$$$0(0);
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{NVARCHAR, NCHAR}) ? 4 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{TEXT}) ? 3 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{CLOB}) ? 2 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{VARCHAR, CHAR}) ? 1 : super.getSuitability(logicalType))));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$4", "getSuitability"));
        }
    }
    ,
    TEXT{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                5.$$$reportNull$$$0(0);
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{CLOB, JSON, XML}) ? 4 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{VARCHAR}) ? 3 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{CHAR}) ? 2 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{NTEXT, NVARCHAR, NCHAR}) ? 1 : super.getSuitability(logicalType))));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$5", "getSuitability"));
        }
    }
    ,
    CLOB{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                6.$$$reportNull$$$0(0);
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{TEXT}) ? 3 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{JSON}) ? 1 : super.getSuitability(logicalType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$6", "getSuitability"));
        }
    }
    ,
    CHAR{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                7.$$$reportNull$$$0(0);
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{TEXT, VARCHAR}) ? 2 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{NCHAR, NVARCHAR}) ? 1 : super.getSuitability(logicalType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$7", "getSuitability"));
        }
    }
    ,
    NCHAR{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                8.$$$reportNull$$$0(0);
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{NTEXT, NVARCHAR}) ? 2 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{CHAR, VARCHAR}) ? 1 : super.getSuitability(logicalType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$8", "getSuitability"));
        }
    }
    ,
    VARCHAR{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                9.$$$reportNull$$$0(0);
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{TEXT, CHAR}) ? 2 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{NVARCHAR, NCHAR}) ? 1 : super.getSuitability(logicalType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$9", "getSuitability"));
        }
    }
    ,
    NVARCHAR{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                10.$$$reportNull$$$0(0);
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{NTEXT, NCHAR}) ? 2 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{VARCHAR, CHAR}) ? 1 : super.getSuitability(logicalType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$10", "getSuitability"));
        }
    }
    ,
    YEAR{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                11.$$$reportNull$$$0(0);
            }
            return logicalType == NUMBER ? 3 : (logicalType == SERIAL ? 1 : super.getSuitability(logicalType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$11", "getSuitability"));
        }
    }
    ,
    BINARY{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                12.$$$reportNull$$$0(0);
            }
            return logicalType == BLOB ? 1 : super.getSuitability(logicalType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$12", "getSuitability"));
        }
    }
    ,
    VARBINARY{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                13.$$$reportNull$$$0(0);
            }
            return logicalType == BLOB ? 2 : super.getSuitability(logicalType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$13", "getSuitability"));
        }
    }
    ,
    BLOB,
    GRAPHIC,
    BOOLEAN,
    FIXED_POINT_NUMBER{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                14.$$$reportNull$$$0(0);
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{MONEY}) ? 3 : (LogicalType.isSimilarNumbers((LogicalType)this, logicalType) ? LogicalType.getNumbersSimilarity((LogicalType)this, logicalType) : (logicalType == YEAR ? 1 : super.getSuitability(logicalType)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$14", "getSuitability"));
        }
    }
    ,
    DOUBLE_PRECISION{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                15.$$$reportNull$$$0(0);
            }
            return LogicalType.isSimilarNumbers((LogicalType)this, logicalType) ? LogicalType.getNumbersSimilarity((LogicalType)this, logicalType) : (logicalType == YEAR ? 1 : super.getSuitability(logicalType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$15", "getSuitability"));
        }
    }
    ,
    SINGLE_PRECISION{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                16.$$$reportNull$$$0(0);
            }
            return LogicalType.isSimilarNumbers((LogicalType)this, logicalType) ? LogicalType.getNumbersSimilarity((LogicalType)this, logicalType) : (logicalType == YEAR ? 1 : super.getSuitability(logicalType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$16", "getSuitability"));
        }
    }
    ,
    DATE{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                17.$$$reportNull$$$0(0);
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{TIMESTAMP, TIMESTAMP_WITH_TIMEZONE}) ? 1 : super.getSuitability(logicalType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$17", "getSuitability"));
        }
    }
    ,
    TIME,
    TIME_WITH_TIMEZONE{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                18.$$$reportNull$$$0(0);
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{TIME}) ? 100 : super.getSuitability(logicalType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$18", "getSuitability"));
        }
    }
    ,
    TIMESTAMP{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                19.$$$reportNull$$$0(0);
            }
            return logicalType == TIMESTAMP_WITH_TIMEZONE ? 102 : (logicalType == DATE ? 101 : super.getSuitability(logicalType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$19", "getSuitability"));
        }
    }
    ,
    TIMESTAMP_WITH_TIMEZONE{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                20.$$$reportNull$$$0(0);
            }
            return logicalType == TIMESTAMP ? 2 : (logicalType == DATE ? 1 : super.getSuitability(logicalType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$20", "getSuitability"));
        }
    }
    ,
    BINARY_STRING,
    UNSIGNED_NUMBER{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                21.$$$reportNull$$$0(0);
            }
            return LogicalType.isSimilarNumbers((LogicalType)this, logicalType) ? LogicalType.getNumbersSimilarity((LogicalType)this, logicalType) : super.getSuitability(logicalType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$21", "getSuitability"));
        }
    }
    ,
    NUMBER{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                22.$$$reportNull$$$0(0);
            }
            return LogicalType.isSimilarNumbers((LogicalType)this, logicalType) ? LogicalType.getNumbersSimilarity((LogicalType)this, logicalType) : (logicalType == SERIAL ? 3 : (logicalType == YEAR ? 1 : super.getSuitability(logicalType)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$22", "getSuitability"));
        }
    }
    ,
    XML,
    MONEY,
    INET,
    TSVECTOR,
    UNKNOWN{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                23.$$$reportNull$$$0(0);
            }
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$23", "getSuitability"));
        }
    };


    public int getSuitability(@NotNull LogicalType logicalType) {
        if (logicalType == null) {
            LogicalType.$$$reportNull$$$0(0);
        }
        return logicalType == this ? Integer.MAX_VALUE : 0;
    }

    private static int getNumbersSimilarity(@NotNull LogicalType original, @NotNull LogicalType coming) {
        if (original == null) {
            LogicalType.$$$reportNull$$$0(1);
        }
        if (coming == null) {
            LogicalType.$$$reportNull$$$0(2);
        }
        return NumberCategory.of(original).similarity(NumberCategory.of(coming));
    }

    private static boolean isSimilarNumbers(@NotNull LogicalType original, @NotNull LogicalType coming) {
        if (original == null) {
            LogicalType.$$$reportNull$$$0(3);
        }
        if (coming == null) {
            LogicalType.$$$reportNull$$$0(4);
        }
        NumberCategory originalCategory = NumberCategory.getIfPresent(original);
        NumberCategory comingCategory = NumberCategory.getIfPresent(coming);
        return originalCategory != null && comingCategory != null && original != coming;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalType";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coming";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/data/types/LogicalType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuitability";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getNumbersSimilarity";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isSimilarNumbers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum NumberCategory {
        DECIMAL(SINGLE_PRECISION, DOUBLE_PRECISION, FIXED_POINT_NUMBER),
        INTEGER(UNSIGNED_NUMBER, NUMBER);

        private final LogicalType[] myTypes;

        private NumberCategory(LogicalType ... types) {
            if (types == null) {
                NumberCategory.$$$reportNull$$$0(0);
            }
            this.myTypes = types;
        }

        boolean isMine(@NotNull LogicalType type) {
            if (type == null) {
                NumberCategory.$$$reportNull$$$0(1);
            }
            return ArrayUtil.contains((Object)((Object)type), (Object[])this.myTypes);
        }

        int similarity(@NotNull NumberCategory category) {
            if (category == null) {
                NumberCategory.$$$reportNull$$$0(2);
            }
            return this == category ? 3 : 2;
        }

        @Nullable
        static NumberCategory getIfPresent(@NotNull LogicalType type) {
            if (type == null) {
                NumberCategory.$$$reportNull$$$0(3);
            }
            for (NumberCategory category : NumberCategory.values()) {
                if (!category.isMine(type)) continue;
                return category;
            }
            return null;
        }

        @NotNull
        static NumberCategory of(@NotNull LogicalType type) {
            if (type == null) {
                NumberCategory.$$$reportNull$$$0(4);
            }
            for (NumberCategory category : NumberCategory.values()) {
                if (!category.isMine(type)) continue;
                NumberCategory numberCategory = category;
                if (numberCategory == null) {
                    NumberCategory.$$$reportNull$$$0(5);
                }
                return numberCategory;
            }
            throw new IllegalArgumentException("Unexpected type: " + (Object)((Object)type));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "category";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/data/types/LogicalType$NumberCategory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/data/types/LogicalType$NumberCategory";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "of";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isMine";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "similarity";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getIfPresent";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "of";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

