/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.evaluation;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.database.Dbms;
import com.intellij.database.console.evaluation.DatabaseExpressionEvaluator;
import com.intellij.database.console.evaluation.EvaluationResultFetcher;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.extractors.DisplayHtmlValuesExtractor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.HtmlValuesExtractor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbUIUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.intellij.images.editor.impl.ImageEditorManagerImpl;
import org.intellij.images.editor.impl.ImageEditorUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTableResult
implements DatabaseExpressionEvaluator.Result {
    private static final int MAX = 120;
    final ObjectFormatter myFormatter;
    final EvaluationResultFetcher myFetcher;
    final Dbms myDbms;
    private MyRootNodeUpdater myUpdater;
    private int myLastShown;
    EvaluationColumnsPresentation myPresentation;

    private AbstractTableResult(@NotNull Dbms dbms, @NotNull EvaluationResultFetcher fetcher) {
        if (dbms == null) {
            AbstractTableResult.$$$reportNull$$$0(0);
        }
        if (fetcher == null) {
            AbstractTableResult.$$$reportNull$$$0(1);
        }
        this.myDbms = dbms;
        this.myFetcher = fetcher;
        this.myFormatter = new ObjectFormatter();
    }

    void init() {
        this.myPresentation = this.createColumnsPresentation();
        this.myUpdater = this.createRootNodeUpdater();
    }

    @Override
    @NotNull
    public String representation() {
        this.myFetcher.fetchCached();
        StringBuilder sb = new StringBuilder();
        List<DataConsumer.Column> columns = this.myFetcher.getColumns();
        for (int i2 = 0; i2 < columns.size(); ++i2) {
            DataConsumer.Column column = columns.get(i2);
            sb.append(column.name).append(i2 < columns.size() - 1 ? "\t" : "");
        }
        sb.append("\n");
        List<DataConsumer.Row> rows = this.myFetcher.getRows();
        for (DataConsumer.Row row : rows) {
            for (int i3 = 0; i3 < columns.size(); ++i3) {
                DataConsumer.Column column = columns.get(i3);
                sb.append(AbstractTableResult.notNullValue(this.myFormatter, column, this.myDbms, column.getValue(row), false)).append(i3 < columns.size() - 1 ? "\t" : "");
            }
            sb.append("\n");
        }
        String string = sb.toString();
        if (string == null) {
            AbstractTableResult.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            AbstractTableResult.$$$reportNull$$$0(3);
        }
        if (place == null) {
            AbstractTableResult.$$$reportNull$$$0(4);
        }
        this.myUpdater.update((Obsolescent)node, place, this.getResultName(), this.getResultSeparator());
    }

    @Override
    public void computeChildren(@NotNull XCompositeNode node) {
        XValueChildrenList columns;
        if (node == null) {
            AbstractTableResult.$$$reportNull$$$0(5);
        }
        if ((columns = this.columns()).size() != 0) {
            node.addChildren(columns, false);
        }
        String name = this.getResultName();
        String separator = this.getResultSeparator();
        if (this.myFetcher.isBusy()) {
            this.myUpdater.update((Obsolescent)node, XValuePlace.TREE, name, separator);
            return;
        }
        this.myFetcher.fetch(() -> {
            node.addChildren(this.rows(), true);
            this.myUpdater.update((Obsolescent)node, XValuePlace.TREE, name, separator);
        });
    }

    @NotNull
    protected abstract String getResultSeparator();

    @NotNull
    protected abstract String getResultName();

    @NotNull
    EvaluationColumnsPresentation createColumnsPresentation() {
        return new EvaluationColumnsPresentation(this.myDbms);
    }

    @NotNull
    MyRootNodeUpdater createRootNodeUpdater() {
        return new MyRootNodeUpdater(this.myFetcher, this.myPresentation, this.myFormatter, this.myDbms);
    }

    @NotNull
    private XValueChildrenList rows() {
        XValueChildrenList list = new XValueChildrenList();
        List<DataConsumer.Row> rows = this.myFetcher.getRows();
        for (int i2 = this.myLastShown; i2 < rows.size(); ++i2) {
            final DataConsumer.Row row = rows.get(i2);
            list.add(new XNamedValue(String.valueOf(i2 + 1)){

                public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (place == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    Function converter = c2 -> AbstractTableResult.cut(AbstractTableResult.notNullValue(AbstractTableResult.this.myFormatter, c2, AbstractTableResult.this.myDbms, c2.getValue(row), true));
                    String type = StringUtil.join(AbstractTableResult.this.myFetcher.getColumns(), (Function)converter, (String)", ");
                    node.setPresentation(null, (XValuePresentation)new XRegularValuePresentation("", AbstractTableResult.cut(type), " "), AbstractTableResult.this.hasChildren());
                }

                public void computeChildren(@NotNull XCompositeNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    node.addChildren(AbstractTableResult.this.rowValuesList(row), true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "node";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "place";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "computePresentation";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "computeChildren";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        this.myLastShown = rows.size();
        XValueChildrenList xValueChildrenList = list;
        if (xValueChildrenList == null) {
            AbstractTableResult.$$$reportNull$$$0(6);
        }
        return xValueChildrenList;
    }

    private boolean hasChildren() {
        return !this.myFetcher.getColumns().isEmpty();
    }

    @NotNull
    private XValueChildrenList rowValuesList(@NotNull DataConsumer.Row row) {
        if (row == null) {
            AbstractTableResult.$$$reportNull$$$0(7);
        }
        XValueChildrenList rowChildren = new XValueChildrenList();
        for (final DataConsumer.Column column : this.myFetcher.getColumns()) {
            final Object value2 = column.getValue(row);
            final String originalValue = AbstractTableResult.notNullValue(this.myFormatter, column, this.myDbms, value2, true);
            final String stringValue = AbstractTableResult.cut(originalValue);
            rowChildren.add(new XNamedValue(column.name){

                public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                    if (node == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (place == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    node.setPresentation(null, (XValuePresentation)new XRegularValuePresentation(stringValue, AbstractTableResult.this.myPresentation.compute((DataConsumer.Column)column).typeName), false);
                    if (!AbstractTableResult.this.setImageEvaluator(node, value2) && stringValue.length() < originalValue.length()) {
                        node.setFullValueEvaluator(new XFullValueEvaluator(){

                            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                                if (callback == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                callback.evaluated(AbstractTableResult.notNullValue(AbstractTableResult.this.myFormatter, column, AbstractTableResult.this.myDbms, value2, true, false));
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/AbstractTableResult$2$1", "startEvaluation"));
                            }
                        });
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "node";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "place";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/database/console/evaluation/AbstractTableResult$2";
                    objectArray[2] = "computePresentation";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        XValueChildrenList xValueChildrenList = rowChildren;
        if (xValueChildrenList == null) {
            AbstractTableResult.$$$reportNull$$$0(8);
        }
        return xValueChildrenList;
    }

    @NotNull
    private XValueChildrenList columns() {
        XValueChildrenList list = new XValueChildrenList();
        if (this.myFetcher.getRows().size() == 0) {
            list.add(new XNamedValue("columns"){

                public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                    if (node == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (place == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    String columns = StringUtil.join(AbstractTableResult.this.myFetcher.getColumns(), ColumnDescriptor::getName, (String)", ");
                    node.setPresentation(null, (XValuePresentation)new XRegularValuePresentation("", columns, " "), AbstractTableResult.this.hasChildren());
                }

                public void computeChildren(@NotNull XCompositeNode node) {
                    if (node == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    node.addChildren(AbstractTableResult.this.columnsList(), true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "node";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "place";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "computePresentation";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "computeChildren";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        XValueChildrenList xValueChildrenList = list;
        if (xValueChildrenList == null) {
            AbstractTableResult.$$$reportNull$$$0(9);
        }
        return xValueChildrenList;
    }

    @NotNull
    private XValueChildrenList columnsList() {
        XValueChildrenList list = new XValueChildrenList();
        for (final DataConsumer.Column column : this.myFetcher.getColumns()) {
            list.add(new XNamedValue(column.name){

                public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                    if (node == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (place == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    XRegularValuePresentation presentation = new XRegularValuePresentation("", AbstractTableResult.this.myPresentation.compute((DataConsumer.Column)column).typeName, " ");
                    node.setPresentation(AbstractTableResult.this.myPresentation.compute((DataConsumer.Column)column).icon, (XValuePresentation)presentation, false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "node";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "place";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/database/console/evaluation/AbstractTableResult$4";
                    objectArray[2] = "computePresentation";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        XValueChildrenList xValueChildrenList = list;
        if (xValueChildrenList == null) {
            AbstractTableResult.$$$reportNull$$$0(10);
        }
        return xValueChildrenList;
    }

    private boolean setImageEvaluator(@NotNull XValueNode node, @Nullable Object value2) {
        if (node == null) {
            AbstractTableResult.$$$reportNull$$$0(11);
        }
        if (!(value2 instanceof ObjectFormatter.ImageInfo)) {
            return false;
        }
        ObjectFormatter.ImageInfo info = (ObjectFormatter.ImageInfo)value2;
        final BufferedImage image = info.createImage();
        if (image == null) {
            return false;
        }
        XFullValueEvaluator evaluator = new XFullValueEvaluator(){

            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                if (callback == null) {
                    5.$$$reportNull$$$0(0);
                }
                DbUIUtil.invokeLaterIfNeeded(() -> {
                    if (callback.isObsolete()) {
                        return;
                    }
                    ImageEditorUI ui = ImageEditorManagerImpl.createImageEditorUI((BufferedImage)image);
                    JBPopup popup = DebuggerUIUtil.createValuePopup((Project)AbstractTableResult.this.myFetcher.getProject(), (JComponent)ui, null);
                    JFrame frame = Objects.requireNonNull(WindowManager.getInstance().getFrame(AbstractTableResult.this.myFetcher.getProject()));
                    Dimension frameSize = frame.getSize();
                    Dimension size = new Dimension(frameSize.width / 2, frameSize.height / 2);
                    popup.setSize(size);
                    callback.evaluated("");
                    popup.show(new RelativePoint((Component)frame, new Point(size.width / 2, size.height / 2)));
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/AbstractTableResult$5", "startEvaluation"));
            }
        };
        evaluator.setShowValuePopup(false);
        node.setFullValueEvaluator(evaluator);
        return true;
    }

    @NotNull
    public static String notNullValue(@NotNull ObjectFormatter formatter, @NotNull DataConsumer.Column column, @NotNull Dbms dbms, @Nullable Object value2, boolean quoteIfEmpty) {
        if (formatter == null) {
            AbstractTableResult.$$$reportNull$$$0(12);
        }
        if (column == null) {
            AbstractTableResult.$$$reportNull$$$0(13);
        }
        if (dbms == null) {
            AbstractTableResult.$$$reportNull$$$0(14);
        }
        return AbstractTableResult.notNullValue(formatter, column, dbms, value2, quoteIfEmpty, true);
    }

    @NotNull
    public static String notNullValue(@NotNull ObjectFormatter formatter, @NotNull DataConsumer.Column column, @NotNull Dbms dbms, @Nullable Object value2, boolean quoteIfEmpty, boolean forDisplay) {
        if (formatter == null) {
            AbstractTableResult.$$$reportNull$$$0(15);
        }
        if (column == null) {
            AbstractTableResult.$$$reportNull$$$0(16);
        }
        if (dbms == null) {
            AbstractTableResult.$$$reportNull$$$0(17);
        }
        String result = StringUtil.notNullize((String)formatter.objectToString(value2, column, dbms, forDisplay), (String)"null");
        String string = quoteIfEmpty && StringUtil.isEmptyOrSpaces((String)result) ? StringUtil.wrapWithDoubleQuote((String)result) : result;
        if (string == null) {
            AbstractTableResult.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public static String cut(@NotNull String s) {
        if (s == null) {
            AbstractTableResult.$$$reportNull$$$0(19);
        }
        String string = StringUtil.shortenTextWithEllipsis((String)s, (int)120, (int)0);
        if (string == null) {
            AbstractTableResult.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fetcher";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/evaluation/AbstractTableResult";
                break;
            }
            case 3: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "representation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "rows";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "rowValuesList";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "columns";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "columnsList";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullValue";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "cut";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 20: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "rowValuesList";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setImageEvaluator";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "notNullValue";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "cut";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EvaluationColumnsPresentation {
        private final Map<DataConsumer.Column, Presentation> myMap;
        private final Dbms myDbms;

        EvaluationColumnsPresentation(@NotNull Dbms dbms) {
            if (dbms == null) {
                EvaluationColumnsPresentation.$$$reportNull$$$0(0);
            }
            this.myDbms = dbms;
            this.myMap = new HashMap<DataConsumer.Column, Presentation>();
        }

        @NotNull
        final Presentation compute(@NotNull DataConsumer.Column column) {
            if (column == null) {
                EvaluationColumnsPresentation.$$$reportNull$$$0(1);
            }
            Presentation presentation = this.myMap.computeIfAbsent(column, c2 -> this.computeInner((DataConsumer.Column)c2));
            if (presentation == null) {
                EvaluationColumnsPresentation.$$$reportNull$$$0(2);
            }
            return presentation;
        }

        @NotNull
        Presentation computeInner(@NotNull DataConsumer.Column column) {
            Domain domain;
            if (column == null) {
                EvaluationColumnsPresentation.$$$reportNull$$$0(3);
            }
            String typeName = (domain = DomainRegistry.getDomain(this.myDbms, null, column, false)) == null ? column.typeName : domain.name();
            return new Presentation(DatabaseIcons.Col, typeName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "computeInner";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class Presentation {
            public final Icon icon;
            public final String typeName;

            Presentation(@NotNull Icon icon, @NotNull String typeName) {
                if (icon == null) {
                    Presentation.$$$reportNull$$$0(0);
                }
                if (typeName == null) {
                    Presentation.$$$reportNull$$$0(1);
                }
                this.icon = icon;
                this.typeName = typeName;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "icon";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "typeName";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation$Presentation";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class DasPresentation
        extends EvaluationColumnsPresentation {
            private final DasTable myTable;

            DasPresentation(@NotNull Dbms dbms, @NotNull DasTable table) {
                if (dbms == null) {
                    DasPresentation.$$$reportNull$$$0(0);
                }
                if (table == null) {
                    DasPresentation.$$$reportNull$$$0(1);
                }
                super(dbms);
                this.myTable = table;
            }

            @Override
            @NotNull
            Presentation computeInner(@NotNull DataConsumer.Column column) {
                if (column == null) {
                    DasPresentation.$$$reportNull$$$0(2);
                }
                JBIterable children2 = this.myTable.getDasChildren(ObjectKind.COLUMN).filter(DasColumn.class);
                for (DasColumn child : children2) {
                    if (!StringUtil.equals((CharSequence)child.getName(), (CharSequence)column.name)) continue;
                    return new Presentation((Icon)ObjectUtils.notNull((Object)DbPresentation.getIcon((DasObject)child), (Object)DatabaseIcons.Col), child.getDataType().getSpecification());
                }
                Presentation presentation = super.computeInner(column);
                if (presentation == null) {
                    DasPresentation.$$$reportNull$$$0(3);
                }
                return presentation;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dbms";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "table";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "column";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation$DasPresentation";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation$DasPresentation";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "computeInner";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "computeInner";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static class MyPresentation
    extends XRegularValuePresentation {
        private final long myRowCount;

        MyPresentation(@NotNull String name, @NotNull String separator, long count2) {
            if (name == null) {
                MyPresentation.$$$reportNull$$$0(0);
            }
            if (separator == null) {
                MyPresentation.$$$reportNull$$$0(1);
            }
            super(name, null, separator);
            this.myRowCount = count2;
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
            if (renderer == null) {
                MyPresentation.$$$reportNull$$$0(2);
            }
            super.renderValue(renderer);
            String text2 = String.format(" (%s %s)", this.myRowCount, ImportUtil.pluralize("row", this.myRowCount));
            renderer.renderComment(text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "separator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$MyPresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyRootNodeUpdater {
        private final EvaluationResultFetcher myFetcher;
        private final EvaluationColumnsPresentation myPresentation;
        private final ObjectFormatter myFormatter;
        private final Dbms myDbms;

        private MyRootNodeUpdater(@NotNull EvaluationResultFetcher fetcher, @NotNull EvaluationColumnsPresentation presentation, @NotNull ObjectFormatter formatter, @NotNull Dbms dbms) {
            if (fetcher == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(0);
            }
            if (presentation == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(1);
            }
            if (formatter == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(2);
            }
            if (dbms == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(3);
            }
            this.myFetcher = fetcher;
            this.myPresentation = presentation;
            this.myFormatter = formatter;
            this.myDbms = dbms;
        }

        @NotNull
        public XRegularValuePresentation createRegularPresentation(@NotNull String name, @NotNull String separator) {
            if (name == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(4);
            }
            if (separator == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(5);
            }
            return this.myFetcher.isRowCountPrecise() ? new MyPresentation(name, separator, this.myFetcher.getRowCount()) : new XRegularValuePresentation(name, null, separator);
        }

        void update(@NotNull Obsolescent node, @NotNull XValuePlace place, @NotNull String name, @NotNull String separator) {
            if (node == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(6);
            }
            if (place == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(7);
            }
            if (name == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(8);
            }
            if (separator == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(9);
            }
            if (this.isSingleValue()) {
                this.updateSingleValue((XValueNode)node);
                return;
            }
            ObjectUtils.consumeIfCast((Object)node, XValueNode.class, n -> {
                this.updateEvaluator((XValueNode)n, place, name, separator);
                this.updatePresentation((XValueNode)n, place, name, separator);
            });
            if (!this.isTree(place) || !this.myFetcher.canFetch()) {
                return;
            }
            ObjectUtils.consumeIfCast((Object)node, XCompositeNode.class, n -> n.tooManyChildren(this.myFetcher.isRowCountPrecise() && this.myFetcher.getRowCount() <= Integer.MAX_VALUE ? (int)this.myFetcher.getRowCount() - this.myFetcher.getRows().size() : -1));
        }

        boolean isSingleValue() {
            return this.myFetcher.getColumns().size() == 1 && this.myFetcher.getRowCount() == 1L;
        }

        private void updateEvaluator(@NotNull XValueNode n, @NotNull XValuePlace place, @NotNull String name, @NotNull String separator) {
            if (n == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(10);
            }
            if (place == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(11);
            }
            if (name == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(12);
            }
            if (separator == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(13);
            }
            if (!this.isTree(place) || this.myFetcher.isRowCountPrecise()) {
                return;
            }
            n.setFullValueEvaluator((XFullValueEvaluator)new MyCountEvaluator(n, name, separator, this.myFetcher.getRowCount()));
        }

        private void updateSingleValue(@NotNull XValueNode node) {
            if (node == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(14);
            }
            this.myFetcher.fetchCached();
            final DataConsumer.Column column = (DataConsumer.Column)Objects.requireNonNull(ContainerUtil.getFirstItem(this.myFetcher.getColumns()));
            DataConsumer.Row row = (DataConsumer.Row)Objects.requireNonNull(ContainerUtil.getFirstItem(this.myFetcher.getRows()));
            final Object value2 = column.getValue(row);
            String representation = AbstractTableResult.notNullValue(this.myFormatter, column, this.myDbms, value2, true);
            String stringValue = AbstractTableResult.cut(representation);
            if (representation.length() > stringValue.length()) {
                node.setFullValueEvaluator(new XFullValueEvaluator(){

                    public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                        if (callback == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        callback.evaluated(AbstractTableResult.notNullValue(myFormatter, column, myDbms, value2, true, false));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater$1", "startEvaluation"));
                    }
                });
            }
            node.setPresentation(null, this.myPresentation.compute((DataConsumer.Column)column).typeName, stringValue, false);
        }

        private boolean isTree(@NotNull XValuePlace place) {
            if (place == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(15);
            }
            return this.myFetcher.getRowCount() == 0L || this.myFetcher.getColumns().isEmpty() || place == XValuePlace.TREE;
        }

        private void updatePresentation(@NotNull XValueNode node, @NotNull XValuePlace place, @NotNull String name, @NotNull String separator) {
            boolean tree;
            if (node == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(16);
            }
            if (place == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(17);
            }
            if (name == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(18);
            }
            if (separator == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(19);
            }
            TablePresentation presentation = (tree = this.isTree(place)) ? this.createRegularPresentation(name, separator) : new TablePresentation(this.myDbms, this.myFetcher, this.myPresentation);
            node.setPresentation(DatabaseIcons.Table, (XValuePresentation)presentation, tree);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fetcher";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 4: 
                case 8: 
                case 12: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 5: 
                case 9: 
                case 13: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "separator";
                    break;
                }
                case 6: 
                case 14: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 7: 
                case 11: 
                case 15: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "n";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createRegularPresentation";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateEvaluator";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateSingleValue";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isTree";
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MyCountEvaluator
        extends XFullValueEvaluator {
            private final XValueNode myNode;
            private final String myName;
            private final String mySeparator;

            private MyCountEvaluator(@NotNull XValueNode node, @NotNull String name, String separator, long rows) {
                if (node == null) {
                    MyCountEvaluator.$$$reportNull$$$0(0);
                }
                if (name == null) {
                    MyCountEvaluator.$$$reportNull$$$0(1);
                }
                if (separator == null) {
                    MyCountEvaluator.$$$reportNull$$$0(2);
                }
                super("(" + rows + "+ " + ImportUtil.pluralize("row", rows) + ")");
                this.myNode = node;
                this.myName = name;
                this.mySeparator = separator;
                this.setShowValuePopup(false);
            }

            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                if (callback == null) {
                    MyCountEvaluator.$$$reportNull$$$0(3);
                }
                MyRootNodeUpdater.this.myFetcher.count(() -> {
                    if (callback.isObsolete()) {
                        return;
                    }
                    MyRootNodeUpdater.this.update((Obsolescent)this.myNode, XValuePlace.TREE, this.myName, this.mySeparator);
                    this.myNode.setFullValueEvaluator(new XFullValueEvaluator(""){

                        public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                            if (callback == null) {
                                1.$$$reportNull$$$0(0);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater$MyCountEvaluator$1", "startEvaluation"));
                        }
                    });
                    callback.evaluated("");
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "separator";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "callback";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater$MyCountEvaluator";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startEvaluation";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static class DasTableResult
    extends AbstractTableResult {
        private final DasTable myTable;

        public DasTableResult(@NotNull Dbms dbms, @NotNull EvaluationResultFetcher support, @NotNull DasTable table) {
            if (dbms == null) {
                DasTableResult.$$$reportNull$$$0(0);
            }
            if (support == null) {
                DasTableResult.$$$reportNull$$$0(1);
            }
            if (table == null) {
                DasTableResult.$$$reportNull$$$0(2);
            }
            super(dbms, support);
            this.myTable = table;
            this.init();
        }

        @Override
        @NotNull
        protected String getResultName() {
            String string = this.myTable.getName();
            if (string == null) {
                DasTableResult.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        protected String getResultSeparator() {
            return " = ";
        }

        @Override
        @NotNull
        EvaluationColumnsPresentation createColumnsPresentation() {
            return new EvaluationColumnsPresentation.DasPresentation(this.myDbms, this.myTable);
        }

        @Override
        @NotNull
        MyRootNodeUpdater createRootNodeUpdater() {
            return new MyRootNodeUpdater(this.myFetcher, this.myPresentation, this.myFormatter, this.myDbms){

                @Override
                boolean isSingleValue() {
                    return false;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "support";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/AbstractTableResult$DasTableResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$DasTableResult";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResultName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class TableResult
    extends AbstractTableResult {
        public TableResult(@NotNull Dbms dbms, @NotNull EvaluationResultFetcher support) {
            if (dbms == null) {
                TableResult.$$$reportNull$$$0(0);
            }
            if (support == null) {
                TableResult.$$$reportNull$$$0(1);
            }
            super(dbms, support);
            this.init();
        }

        @Override
        @NotNull
        public String representation() {
            if (this.myFetcher.getRowCount() != 1L || this.myFetcher.getColumns().size() != 1) {
                String string = super.representation();
                if (string == null) {
                    TableResult.$$$reportNull$$$0(2);
                }
                return string;
            }
            this.myFetcher.fetchCached();
            DataConsumer.Column column = (DataConsumer.Column)Objects.requireNonNull(ContainerUtil.getFirstItem(this.myFetcher.getColumns()));
            DataConsumer.Row row = (DataConsumer.Row)Objects.requireNonNull(ContainerUtil.getFirstItem(this.myFetcher.getRows()));
            String string = TableResult.notNullValue(this.myFormatter, column, this.myDbms, column.getValue(row), true);
            if (string == null) {
                TableResult.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        protected String getResultSeparator() {
            return "";
        }

        @Override
        @NotNull
        protected String getResultName() {
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "support";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/AbstractTableResult$TableResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$TableResult";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "representation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class TablePresentation
    extends XValuePresentation {
        private final Dbms myDbms;
        private final EvaluationResultFetcher myFetcher;
        private final ObjectFormatter myFormatter;
        private final EvaluationColumnsPresentation myPresentation;

        TablePresentation(@NotNull Dbms dbms, @NotNull EvaluationResultFetcher support, @NotNull EvaluationColumnsPresentation presentation) {
            if (dbms == null) {
                TablePresentation.$$$reportNull$$$0(0);
            }
            if (support == null) {
                TablePresentation.$$$reportNull$$$0(1);
            }
            if (presentation == null) {
                TablePresentation.$$$reportNull$$$0(2);
            }
            this.myPresentation = presentation;
            this.myFormatter = new ObjectFormatter(){

                @Override
                public String objectToString(@Nullable Object o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                    String unescaped = AbstractTableResult.cut(StringUtil.notNullize((String)super.objectToString(o, column, dbms, true), (String)"null"));
                    return HtmlValuesExtractor.escapeChars(unescaped);
                }
            };
            this.myDbms = dbms;
            this.myFetcher = support;
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
            if (renderer == null) {
                TablePresentation.$$$reportNull$$$0(3);
            }
            renderer.renderValue(this.getText());
        }

        @NotNull
        public JComponent presentationComponent(@NotNull Editor editor) {
            if (editor == null) {
                TablePresentation.$$$reportNull$$$0(4);
            }
            Ref consumerRef = Ref.create();
            Ref scrollPaneRef = Ref.create();
            this.myFetcher.fetchCached();
            MyHyperlinkListener listener2 = new MyHyperlinkListener((Ref<? extends JScrollPane>)scrollPaneRef, (Ref<? extends Consumer<? super String>>)consumerRef);
            JComponent label = HintUtil.createInformationLabel((String)this.getText(), (HyperlinkListener)listener2, null, (Ref)consumerRef);
            Dimension preferredSize = label.getPreferredSize();
            JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)label, (boolean)true);
            Dimension cropped = TablePresentation.cropToFitScreen(editor, pane, preferredSize);
            if (!cropped.equals(preferredSize)) {
                pane.setPreferredSize(cropped);
            }
            scrollPaneRef.set((Object)pane);
            JComponent jComponent = (JComponent)scrollPaneRef.get();
            if (jComponent == null) {
                TablePresentation.$$$reportNull$$$0(5);
            }
            return jComponent;
        }

        @NotNull
        private static Dimension cropToFitScreen(@NotNull Editor editor, @NotNull JScrollPane pane, @NotNull Dimension preferredSize) {
            if (editor == null) {
                TablePresentation.$$$reportNull$$$0(6);
            }
            if (pane == null) {
                TablePresentation.$$$reportNull$$$0(7);
            }
            if (preferredSize == null) {
                TablePresentation.$$$reportNull$$$0(8);
            }
            Rectangle screenRect = ScreenUtil.getScreenRectangle((Component)editor.getComponent());
            int width = Math.min(preferredSize.width, (int)((double)screenRect.width * 0.9));
            int height = Math.min(preferredSize.height, (int)((double)screenRect.height * 0.9));
            boolean widthChanged = width < preferredSize.width;
            JScrollBar bar = pane.getHorizontalScrollBar();
            int hsbHeight = bar == null || !widthChanged || SystemInfo.isMac ? 0 : bar.getPreferredSize().height;
            return new Dimension(width, height + hsbHeight);
        }

        @NotNull
        private String getText() {
            DisplayHtmlValuesExtractor extractor = new DisplayHtmlValuesExtractor(HintUtil.getInformationColor(), this.myFormatter, 99){

                @Override
                @NotNull
                protected String getName(@NotNull DataConsumer.Column column) {
                    if (column == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    String string = super.getName(column) + ": " + ((TablePresentation)this).myPresentation.compute((DataConsumer.Column)column).typeName;
                    if (string == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "column";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getName";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            StringBuilder builder = new StringBuilder(this.getHeader());
            List<DataConsumer.Row> rows = this.myFetcher.getRows();
            List<DataConsumer.Column> columns = this.myFetcher.getColumns();
            CharOut out = CharOut.Util.newSink(builder);
            int[] columnsToExtract = columns.stream().mapToInt(c2 -> c2.columnNum).toArray();
            ExtractorsUtil.extract(out, this.myDbms, columns, extractor, rows, columnsToExtract);
            if (this.myFetcher.canFetch()) {
                builder.append("<div style='margin-top: 3px;margin-bottom: 2px;'>").append(TablePresentation.getLink("More...", "more")).append("</div>");
            }
            String string = builder.append(DisplayHtmlValuesExtractor.getTail()).toString();
            if (string == null) {
                TablePresentation.$$$reportNull$$$0(9);
            }
            return string;
        }

        @NotNull
        private String getHeader() {
            StringBuilder sb = new StringBuilder(DisplayHtmlValuesExtractor.getHeader());
            if (!this.myFetcher.canFetch() && this.myFetcher.getRows().size() <= this.myFetcher.getFetchSize()) {
                String string = sb.toString();
                if (string == null) {
                    TablePresentation.$$$reportNull$$$0(10);
                }
                return string;
            }
            long rowsCount = this.myFetcher.getRowCount();
            sb.append("<div style='margin-bottom: 3px; margin-top: 2px'>Rows: <b>");
            if (this.myFetcher.isRowCountPrecise()) {
                sb.append(rowsCount);
            } else {
                sb.append(TablePresentation.getLink(rowsCount + "+", "count"));
            }
            sb.append("</b></div>");
            String string = sb.toString();
            if (string == null) {
                TablePresentation.$$$reportNull$$$0(11);
            }
            return string;
        }

        @NotNull
        private static String getLink(@NotNull String text2, @NotNull String url) {
            if (text2 == null) {
                TablePresentation.$$$reportNull$$$0(12);
            }
            if (url == null) {
                TablePresentation.$$$reportNull$$$0(13);
            }
            String string = String.format("<a href='%s'>%s</a>", url, text2);
            if (string == null) {
                TablePresentation.$$$reportNull$$$0(14);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "support";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pane";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preferredSize";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "presentationComponent";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHeader";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "renderValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "presentationComponent";
                    break;
                }
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 14: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "cropToFitScreen";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getLink";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class MyHyperlinkListener
        implements HyperlinkListener {
            @NotNull
            private final Ref<? extends JScrollPane> myScrollPaneRef;
            private final Ref<? extends Consumer<? super String>> myConsumerRef;

            MyHyperlinkListener(@NotNull Ref<? extends JScrollPane> scrollPaneRef, Ref<? extends Consumer<? super String>> consumerRef) {
                if (scrollPaneRef == null) {
                    MyHyperlinkListener.$$$reportNull$$$0(0);
                }
                if (consumerRef == null) {
                    MyHyperlinkListener.$$$reportNull$$$0(1);
                }
                this.myScrollPaneRef = scrollPaneRef;
                this.myConsumerRef = consumerRef;
            }

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED || TablePresentation.this.myFetcher.isBusy()) {
                    return;
                }
                String link = e.getDescription();
                LinkRunner runner = LinkRunner.get(link);
                if (runner == null) {
                    return;
                }
                runner.run(TablePresentation.this.myFetcher, () -> {
                    JViewport viewport = ((JScrollPane)this.myScrollPaneRef.get()).getViewport();
                    Point position = viewport.getViewPosition();
                    ((Consumer)this.myConsumerRef.get()).consume((Object)TablePresentation.this.getText());
                    if (runner == LinkRunner.COUNT) {
                        DbUIUtil.invokeLater(() -> {
                            if (viewport.isShowing()) {
                                viewport.setViewPosition(position);
                            }
                        });
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "scrollPaneRef";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "consumerRef";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$MyHyperlinkListener";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static enum LinkRunner {
            COUNT{

                @Override
                void run(@NotNull EvaluationResultFetcher fetcher, @NotNull Runnable callback) {
                    if (fetcher == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (callback == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    fetcher.count(callback);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "fetcher";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "callback";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$LinkRunner$1";
                    objectArray[2] = "run";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
            ,
            MORE{

                @Override
                void run(@NotNull EvaluationResultFetcher fetcher, @NotNull Runnable callback) {
                    if (fetcher == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (callback == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    fetcher.fetch(callback);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "fetcher";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "callback";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$LinkRunner$2";
                    objectArray[2] = "run";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };


            abstract void run(@NotNull EvaluationResultFetcher var1, @NotNull Runnable var2);

            @Nullable
            static LinkRunner get(@NotNull String link) {
                if (link == null) {
                    LinkRunner.$$$reportNull$$$0(0);
                }
                for (LinkRunner runner : LinkRunner.values()) {
                    if (!StringUtil.equalsIgnoreCase((CharSequence)runner.name(), (CharSequence)link)) continue;
                    return runner;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$LinkRunner", "get"));
            }
        }
    }
}

