/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.vertica;

import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystem;
import com.intellij.sql.dialects.vertica.VertDialect;
import com.intellij.sql.psi.SqlType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VertTypeSystem
extends SqlTypeSystem {
    public static final VertTypeSystem INSTANCE = new VertTypeSystem();

    private VertTypeSystem() {
        super((SqlLanguageDialectEx)VertDialect.INSTANCE);
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            VertTypeSystem.$$$reportNull$$$0(0);
        }
        if ((name2 = super.getNormalizedTypeName(name2)).endsWith("[]")) {
            String string = this.getNormalizedTypeName(name2.substring(0, name2.length() - 2)) + "[]";
            if (string == null) {
                VertTypeSystem.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = name2;
        if (string == null) {
            VertTypeSystem.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            VertTypeSystem.$$$reportNull$$$0(3);
        }
        switch (cat) {
            case INTEGER: {
                return "integer";
            }
            case REAL: {
                return "double precision";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE_TIME: {
                return "date";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "interval";
            }
            case BYTES: {
                return "varbinary";
            }
            case ARRAY: {
                return "anyarray";
            }
            case TABLE: {
                return "anyarray";
            }
            case RECORD: {
                return "record";
            }
        }
        return null;
    }

    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            VertTypeSystem.$$$reportNull$$$0(4);
        }
        if (typeName.endsWith("[]")) {
            SqlType.Category category = SqlType.Category.ARRAY;
            if (category == null) {
                VertTypeSystem.$$$reportNull$$$0(5);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            VertTypeSystem.$$$reportNull$$$0(6);
        }
        return category;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/vertica/VertTypeSystem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/vertica/VertTypeSystem";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

