/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redshift;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.dialects.postgresbase.PgDialectBase;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RsDialect
extends PgDialectBase
implements DatabaseDialect {
    protected RsDialect() {
        super(new TypeHelper.PgTypeHelper(), BasicNamespace.LOWER_CASING);
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.REDSHIFT;
        if (dbms == null) {
            RsDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @NotNull
    public String getDisplayName() {
        return "Redshift";
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            RsDialect.$$$reportNull$$$0(1);
        }
        if (sequence == null) {
            RsDialect.$$$reportNull$$$0(2);
        }
        throw new UnsupportedOperationException("Drop sequence is not supported by Redshift");
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSequenceDefinition(@NotNull DasObject element) {
        if (element == null) {
            RsDialect.$$$reportNull$$$0(3);
        }
        throw new UnsupportedOperationException("Sequence definition is not supported by Redshift");
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        DasObject schema;
        if (identifier == null) {
            RsDialect.$$$reportNull$$$0(4);
        }
        if (qualifier == null) {
            RsDialect.$$$reportNull$$$0(5);
        }
        DasObject schemaOrExternal = (schema = DasUtil.getSchemaObject((DasObject)qualifier)) == null ? DasUtil.getParentOfKind((DasObject)qualifier, (ObjectKind)ObjectKind.EXTERNAL_SCHEMA, (boolean)false) : schema;
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schemaOrExternal, DasUtil.getName((DasObject)schemaOrExternal), null, null, null, null);
        if (ddlBuilder == null) {
            RsDialect.$$$reportNull$$$0(6);
        }
        return ddlBuilder;
    }

    @Override
    public boolean hasRowId(@Nullable DasDataSource system) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/redshift/RsDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/redshift/RsDialect";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceDefinition";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

