/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.postgres.PgObjectBuilder;
import com.intellij.database.dialects.postgres.model.PgAccessMethod;
import com.intellij.database.dialects.postgres.model.PgAggregate;
import com.intellij.database.dialects.postgres.model.PgForeignDataWrapper;
import com.intellij.database.dialects.postgres.model.PgForeignServer;
import com.intellij.database.dialects.postgres.model.PgLikeStoredTable;
import com.intellij.database.dialects.postgres.model.PgLocalTableColumn;
import com.intellij.database.dialects.postgres.model.PgMatView;
import com.intellij.database.dialects.postgres.model.PgRole;
import com.intellij.database.dialects.postgres.model.PgRoutine;
import com.intellij.database.dialects.postgres.model.PgTrigger;
import com.intellij.database.dialects.postgres.model.PgUserMapping;
import com.intellij.database.dialects.postgresgreenplumbase.PgGPlumBaseObjectBuilder;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseLikeColumn;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.PgAccessMethodType;
import com.intellij.database.model.properties.PgIdentityKind;
import com.intellij.database.model.properties.PgRoutineConcurrencyKind;
import com.intellij.database.script.CompositeText;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.dialects.postgres.PgElementTypes;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.dialects.postgres.psi.PgCreateAggregateStatementImpl;
import com.intellij.sql.dialects.postgres.psi.PgCreateTriggerStatementImpl;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlCreateStatementImpl;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J \u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u001c\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u001e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010 \u001a\u00020\b2\u0006\u0010\t\u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\b\u0010\u000b\u001a\u0004\u0018\u00010%H\u0002J\u0014\u0010)\u001a\u0004\u0018\u00010(2\b\u0010\u000b\u001a\u0004\u0018\u00010%H\u0002R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006*"}, d2={"Lcom/intellij/database/dialects/postgres/PgObjectBuilder;", "Lcom/intellij/database/dialects/postgresgreenplumbase/PgGPlumBaseObjectBuilder;", "()V", "lazyCodeBlock", "Lcom/intellij/psi/tree/IElementType;", "getLazyCodeBlock", "()Lcom/intellij/psi/tree/IElementType;", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/sql/database/SqlObjectBuilder$Context;", "buildAccessMethod", "Lcom/intellij/database/dialects/postgres/model/PgAccessMethod;", "buildAggregate", "Lcom/intellij/database/dialects/postgres/model/PgAggregate;", "buildBasicElement", "buildForeignDataWrapper", "Lcom/intellij/database/dialects/postgres/model/PgForeignDataWrapper;", "buildForeignServer", "Lcom/intellij/database/dialects/postgres/model/PgForeignServer;", "buildMatView", "Lcom/intellij/database/dialects/postgres/model/PgMatView;", "buildRole", "Lcom/intellij/database/dialects/postgres/model/PgRole;", "buildRoutine", "Lcom/intellij/database/dialects/postgres/model/PgRoutine;", "buildTrigger", "Lcom/intellij/database/dialects/postgres/model/PgTrigger;", "buildUserMapping", "Lcom/intellij/database/dialects/postgres/model/PgUserMapping;", "findConcurrencyKind", "Lcom/intellij/database/model/properties/PgRoutineConcurrencyKind;", "element", "Lcom/intellij/psi/PsiElement;", "findOptions", "", "", "findUser", "intellij.database.dialects.postgres"})
public class PgObjectBuilder
extends PgGPlumBaseObjectBuilder {
    @Override
    @Nullable
    protected IElementType getLazyCodeBlock() {
        return PgElementTypes.Misc.PG_LAZY_CODE_BLOCK;
    }

    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof PgRoutine) {
            this.buildRoutine((PgRoutine)obj2, source, context);
        } else if (basicModElement instanceof PgForeignDataWrapper) {
            this.buildForeignDataWrapper((PgForeignDataWrapper)obj2, source, context);
        } else if (basicModElement instanceof PgForeignServer) {
            this.buildForeignServer((PgForeignServer)obj2, source, context);
        } else if (basicModElement instanceof PgUserMapping) {
            this.buildUserMapping((PgUserMapping)obj2, source, context);
        } else if (basicModElement instanceof PgRole) {
            this.buildRole((PgRole)obj2, source, context);
        } else if (basicModElement instanceof PgAggregate) {
            this.buildAggregate((PgAggregate)obj2, source, context);
        } else if (basicModElement instanceof PgAccessMethod) {
            this.buildAccessMethod((PgAccessMethod)obj2, source, context);
        } else if (basicModElement instanceof PgMatView) {
            this.buildMatView((PgMatView)obj2, source, context);
        } else if (basicModElement instanceof PgTrigger) {
            this.buildTrigger((PgTrigger)obj2, source, context);
        } else {
            super.build(obj2, source, context);
        }
    }

    @Override
    protected void buildBasicElement(@NotNull BasicModElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super.buildBasicElement(obj2, source, context);
        if (obj2 instanceof PgLocalTableColumn && source instanceof SqlColumnDefinition) {
            boolean wasNotNull = ((PgLocalTableColumn)obj2).isNotNull();
            PgIdentityKind identityKind = null;
            SqlObjectBuilderImpl this_$iv = this;
            boolean $i$f$forEachChild = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement maybeClause = tmp$iv$iv;
                boolean bl = false;
                if (!(maybeClause instanceof SqlClause)) continue;
                SqlObjectBuilderImpl this_$iv2 = this;
                boolean $i$f$forEachChild2 = false;
                SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this_$iv2;
                PsiElement first$iv$iv2 = maybeClause.getFirstChild();
                boolean $i$f$forEachSibling2 = false;
                for (PsiElement tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                    PsiElement byDefaultStart;
                    PsiElement child = tmp$iv$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)child), (Object)PgTypes.PG_GENERATED)) continue;
                    IElementType iElementType = PgTypes.PG_ALWAYS;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"PG_ALWAYS");
                    PsiElement always = this.findSibling(child, iElementType);
                    if (always != null) {
                        identityKind = PgIdentityKind.ALWAYS;
                        continue;
                    }
                    IElementType iElementType2 = PgTypes.PG_BY;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"PG_BY");
                    if (this.findSibling(child, iElementType2) == null) {
                        continue;
                    }
                    IElementType iElementType3 = PgTypes.PG_DEFAULT;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType3, (String)"PG_DEFAULT");
                    if (this.findSibling(byDefaultStart, iElementType3) == null) {
                        continue;
                    }
                    identityKind = PgIdentityKind.BY_DEFAULT;
                }
            }
            ((PgLocalTableColumn)obj2).setIdentityKind(identityKind);
            ((PgLocalTableColumn)obj2).setNotNull(identityKind != null || wasNotNull);
        }
    }

    private final void buildTrigger(PgTrigger obj2, DasObject source, SqlObjectBuilder.Context context) {
        if (!context.isIntrospector()) {
            super.buildTrigger(obj2, source, context);
        }
        if (source instanceof PgCreateTriggerStatementImpl) {
            PgLikeStoredTable pgLikeStoredTable = obj2.getParent();
            if (pgLikeStoredTable == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)pgLikeStoredTable, (String)"obj.parent ?: return");
            PgLikeStoredTable table = pgLikeStoredTable;
            CasingProvider casingProvider = BasicMixinElement.getCasingProvider((BasicElement)((BasicElement)table));
            if (casingProvider == null) {
                casingProvider = DasUtil.NO_CASING_PROVIDER;
            }
            CasingProvider casingProvider2 = casingProvider;
            ArrayList columnIndices = new ArrayList();
            String whenCondition = null;
            SqlObjectBuilderImpl this_$iv = this;
            boolean $i$f$forEachChild = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement psiElement;
                block20: {
                    PsiElement c = tmp$iv$iv;
                    boolean bl = false;
                    IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)c);
                    if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_TRIGGER_EVENT_CLAUSE)) {
                        PsiElement of;
                        PsiElement update;
                        if (context.isIntrospector()) continue;
                        IElementType iElementType2 = PgTypes.PG_UPDATE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"PG_UPDATE");
                        if (this.findChild(c, iElementType2) == null) {
                            continue;
                        }
                        IElementType iElementType3 = PgTypes.PG_OF;
                        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType3, (String)"PG_OF");
                        if (this.findSibling(update, iElementType3) == null) {
                            continue;
                        }
                        SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceElementType, (String)"SqlCompositeElementTypes\u2026QL_COLUMN_SHORT_REFERENCE");
                        PsiElement psiElement2 = this.findSibling(of, (IElementType)sqlReferenceElementType);
                        if (!(psiElement2 instanceof SqlReferenceExpression)) {
                            psiElement2 = null;
                        }
                        SqlReferenceExpression column2 = (SqlReferenceExpression)psiElement2;
                        while (column2 != null) {
                            int n;
                            Iterable $this$indexOfFirst$iv;
                            block19: {
                                Intrinsics.checkExpressionValueIsNotNull((Object)DbSqlUtil.byName((String)column2.getName(), (boolean)DbSqlUtil.isQuoted((SqlNameElement)((SqlNameElement)column2)), null, (CasingProvider)casingProvider2), (String)"DbSqlUtil.byName<PgGPlum\u2026n), null, casingProvider)");
                                ModPositioningNamingFamily<? extends PgGPlumBaseLikeColumn> modPositioningNamingFamily = table.getColumns();
                                Intrinsics.checkExpressionValueIsNotNull(modPositioningNamingFamily, (String)"table.columns");
                                $this$indexOfFirst$iv = (Iterable)modPositioningNamingFamily;
                                boolean $i$f$indexOfFirst = false;
                                int index$iv = 0;
                                for (Object item$iv : $this$indexOfFirst$iv) {
                                    Condition condition;
                                    boolean bl2 = false;
                                    if (index$iv < 0) {
                                        CollectionsKt.throwIndexOverflow();
                                    }
                                    PgGPlumBaseLikeColumn it = (PgGPlumBaseLikeColumn)item$iv;
                                    boolean bl3 = false;
                                    if (condition.value((Object)it)) {
                                        n = index$iv;
                                        break block19;
                                    }
                                    ++index$iv;
                                }
                                n = -1;
                            }
                            long col = (long)n + 1L;
                            if (col != 0L) {
                                $this$indexOfFirst$iv = columnIndices;
                                Long l = col;
                                boolean bl4 = false;
                                $this$indexOfFirst$iv.add(l);
                            }
                            PsiElement psiElement3 = column2.getNextSibling();
                            SqlReferenceElementType sqlReferenceElementType2 = SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE;
                            Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceElementType2, (String)"SqlCompositeElementTypes\u2026QL_COLUMN_SHORT_REFERENCE");
                            PsiElement psiElement4 = this.findSibling(psiElement3, (IElementType)sqlReferenceElementType2);
                            if (!(psiElement4 instanceof SqlReferenceExpression)) {
                                psiElement4 = null;
                            }
                            column2 = (SqlReferenceExpression)psiElement4;
                        }
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_WHEN_CLAUSE)) continue;
                    IElementType iElementType4 = PgTypes.PG_WHEN;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType4, (String)"PG_WHEN");
                    if (this.findChild(c, iElementType4) == null) {
                        continue;
                    }
                    SqlObjectBuilderImpl this_$iv2 = this;
                    boolean $i$f$findSibling = false;
                    for (PsiElement tmp$iv = whenChild; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                        PsiElement it = tmp$iv;
                        boolean bl5 = false;
                        if (!(it instanceof SqlExpression)) continue;
                        psiElement = tmp$iv;
                        break block20;
                    }
                    psiElement = null;
                }
                if (psiElement == null) {
                    continue;
                }
                PsiElement expression = psiElement;
                whenCondition = expression.getText();
            }
            if (!context.isIntrospector()) {
                obj2.setColumnIndices(columnIndices);
            }
            obj2.setWhenCondition(whenCondition);
        }
    }

    private final void buildMatView(PgMatView obj2, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement(obj2, source, context);
        ((BasicModModel)obj2.getModel()).writeSources(new Runnable(this, obj2, source){
            final /* synthetic */ PgObjectBuilder this$0;
            final /* synthetic */ PgMatView $obj;
            final /* synthetic */ DasObject $source;

            public final void run() {
                Object object;
                DasObject dasObject = this.$source;
                if (!(dasObject instanceof SqlCreateViewStatement)) {
                    dasObject = null;
                }
                this.$obj.setSourceText((CompositeText)((object = (SqlCreateViewStatement)dasObject) != null && (object = object.getQueryExpression()) != null && (object = object.getText()) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null));
            }
            {
                this.this$0 = pgObjectBuilder;
                this.$obj = pgMatView;
                this.$source = dasObject;
            }
        });
    }

    private final void buildAccessMethod(PgAccessMethod obj2, DasObject source, SqlObjectBuilder.Context context) {
        if (source instanceof SqlCreateStatementImpl) {
            PgAccessMethodType type = PgAccessMethodType.UNKNOWN;
            String handler = null;
            SqlObjectBuilderImpl this_$iv = this;
            boolean $i$f$forEachChild = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement child = tmp$iv$iv;
                boolean bl = false;
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)child);
                if (!Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_CLAUSE)) continue;
                SqlObjectBuilderImpl this_$iv2 = this;
                boolean $i$f$forEachChild2 = false;
                SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this_$iv2;
                PsiElement first$iv$iv2 = child.getFirstChild();
                boolean $i$f$forEachSibling2 = false;
                for (PsiElement tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                    PsiElement it = tmp$iv$iv2;
                    boolean bl2 = false;
                    IElementType iElementType2 = PsiTreeUtilKt.getElementType((PsiElement)it);
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_INDEX)) {
                        type = PgAccessMethodType.INDEX;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_HANDLER)) continue;
                    PgGPlumBaseObjectBuilder.Reference reference = this.findFunctionReference(it);
                    handler = reference != null ? reference.getFullName() : null;
                }
            }
            obj2.setType(type);
            obj2.setHandler(handler);
        }
    }

    private final void buildAggregate(PgAggregate obj2, DasObject source, SqlObjectBuilder.Context context) {
        super.buildAggregate(obj2, source, context);
        if (source instanceof PgCreateAggregateStatementImpl) {
            boolean finalExtra = false;
            String combineFunction = null;
            String serializationFunction = null;
            String deserializationFunction = null;
            String movingTransition = null;
            String inverseTransition = null;
            DataType movingStateType = DataType.UNKNOWN;
            long stateSize = 0L;
            long movingStateSize = 0L;
            String movingFinalFunction = null;
            boolean movingFinalExtra = false;
            String movingInitialCondition = null;
            PgRoutineConcurrencyKind concurrencyKind = PgRoutineConcurrencyKind.UNSAFE;
            SqlObjectBuilderImpl this_$iv = this;
            boolean $i$f$forEachChild = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement child = tmp$iv$iv;
                boolean bl = false;
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)child);
                if (!Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE)) continue;
                SqlObjectBuilderImpl this_$iv2 = this;
                boolean $i$f$forEachChild2 = false;
                SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this_$iv2;
                PsiElement first$iv$iv2 = child.getFirstChild();
                boolean $i$f$forEachSibling2 = false;
                for (PsiElement tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                    PsiElement it = tmp$iv$iv2;
                    boolean bl2 = false;
                    IElementType iElementType2 = PsiTreeUtilKt.getElementType((PsiElement)it);
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_FINALFUNC_EXTRA)) {
                        finalExtra = true;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_COMBINEFUNC)) {
                        PgGPlumBaseObjectBuilder.Reference reference = this.findFunctionReference(it);
                        combineFunction = reference != null ? reference.getFullName() : null;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_SERIALFUNC)) {
                        PgGPlumBaseObjectBuilder.Reference reference = this.findFunctionReference(it);
                        serializationFunction = reference != null ? reference.getFullName() : null;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_DESERIALFUNC)) {
                        PgGPlumBaseObjectBuilder.Reference reference = this.findFunctionReference(it);
                        deserializationFunction = reference != null ? reference.getFullName() : null;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_MSFUNC)) {
                        PgGPlumBaseObjectBuilder.Reference reference = this.findFunctionReference(it);
                        movingTransition = reference != null ? reference.getFullName() : null;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_MINVFUNC)) {
                        PgGPlumBaseObjectBuilder.Reference reference = this.findFunctionReference(it);
                        inverseTransition = reference != null ? reference.getFullName() : null;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_MSTYPE)) {
                        SqlTypeElement sqlTypeElement;
                        SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_TYPE_ELEMENT;
                        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlElementTypes.SQL_TYPE_ELEMENT");
                        PsiElement psiElement = this.findSibling(it, (IElementType)sqlCompositeElementType);
                        if (!(psiElement instanceof SqlTypeElement)) {
                            psiElement = null;
                        }
                        if ((sqlTypeElement = (SqlTypeElement)psiElement) != null && (sqlTypeElement = sqlTypeElement.getDataType()) != null) {
                            SqlTypeElement sqlTypeElement2 = sqlTypeElement;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            SqlTypeElement it2 = sqlTypeElement2;
                            boolean bl5 = false;
                            movingStateType = it2;
                        }
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_SSPACE)) {
                        Float f = this.findNumberInSiblings(it);
                        stateSize = f != null ? (long)f.floatValue() : 0L;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_MSSPACE)) {
                        Float f = this.findNumberInSiblings(it);
                        movingStateSize = f != null ? (long)f.floatValue() : 0L;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_MFINALFUNC)) {
                        PgGPlumBaseObjectBuilder.Reference reference = this.findFunctionReference(it);
                        movingFinalFunction = reference != null ? reference.getFullName() : null;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_MFINALFUNC_EXTRA)) {
                        movingFinalExtra = true;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_MINITCOND)) {
                        String string = this.findString(it);
                        if (string == null) {
                            Float f = this.findNumberInSiblings(it);
                            string = f != null ? String.valueOf((int)f.floatValue()) : null;
                        }
                        movingInitialCondition = string;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_PARALLEL)) continue;
                    concurrencyKind = this.findConcurrencyKind(it);
                }
            }
            obj2.setCombine(combineFunction);
            obj2.setSerialization(serializationFunction);
            obj2.setDeserialization(deserializationFunction);
            obj2.setFinalExtra(finalExtra);
            obj2.setMovingTransition(movingTransition);
            obj2.setInverseTransition(inverseTransition);
            obj2.setMovingStateType(movingStateType);
            obj2.setStateSize(stateSize);
            obj2.setMovingStateSize(movingStateSize);
            obj2.setMovingFinal(movingFinalFunction);
            obj2.setMovingFinalExtra(movingFinalExtra);
            obj2.setMovingInitialValue(movingInitialCondition);
            obj2.setConcurrencyKind(concurrencyKind);
        }
    }

    private final void buildRole(PgRole obj2, DasObject source, SqlObjectBuilder.Context context) {
        super.buildRole(obj2, source, context);
        boolean isReplication = false;
        boolean isBypassRls = false;
        if (source instanceof SqlCreateStatement) {
            SqlObjectBuilderImpl this_$iv = this;
            boolean $i$f$forEachChild = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                boolean bl = false;
                if (!(it instanceof SqlClause)) continue;
                PsiElement c = ((SqlClause)it).getFirstChild();
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)c);
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_REPLICATION)) {
                    isReplication = true;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_BYPASSRLS)) continue;
                isBypassRls = true;
            }
        }
        obj2.setReplication(isReplication);
        obj2.setBypassRls(isBypassRls);
    }

    private final void buildForeignDataWrapper(PgForeignDataWrapper obj2, DasObject source, SqlObjectBuilder.Context context) {
        if (source instanceof SqlCreateStatementImpl) {
            PgGPlumBaseObjectBuilder.Reference handler = null;
            PgGPlumBaseObjectBuilder.Reference validator = null;
            List<String> options = CollectionsKt.emptyList();
            SqlObjectBuilderImpl this_$iv = this;
            boolean $i$f$forEachChild = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                boolean bl = false;
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)it);
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_HANDLER)) {
                    handler = this.findFunctionReference(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_VALIDATOR)) {
                    validator = this.findFunctionReference(it);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_OPTIONS)) continue;
                options = this.findOptions(it);
            }
            PgGPlumBaseObjectBuilder.Reference reference = handler;
            obj2.setHandler(reference != null ? reference.getName() : null);
            PgGPlumBaseObjectBuilder.Reference reference2 = handler;
            obj2.setHandlerSchema(reference2 != null ? reference2.getQualifier() : null);
            PgGPlumBaseObjectBuilder.Reference reference3 = validator;
            obj2.setValidator(reference3 != null ? reference3.getName() : null);
            PgGPlumBaseObjectBuilder.Reference reference4 = validator;
            obj2.setValidatorSchema(reference4 != null ? reference4.getQualifier() : null);
            obj2.setOptions(options);
        }
    }

    private final void buildForeignServer(PgForeignServer obj2, DasObject source, SqlObjectBuilder.Context context) {
        if (source instanceof SqlCreateStatementImpl) {
            String type = null;
            List<String> options = CollectionsKt.emptyList();
            String version = null;
            SqlObjectBuilderImpl this_$iv = this;
            boolean $i$f$forEachChild = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                boolean bl = false;
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)it);
                if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_CLAUSE)) {
                    PsiElement first2;
                    if (it.getFirstChild() == null) {
                        continue;
                    }
                    IElementType iElementType2 = PsiTreeUtilKt.getElementType((PsiElement)first2);
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_TYPE)) {
                        type = this.findString(first2);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_VERSION)) continue;
                    version = this.findString(first2);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_OPTIONS)) continue;
                options = this.findOptions(it);
            }
            obj2.setType(type);
            obj2.setOptions(options);
            obj2.setVersion(version);
        }
    }

    private final void buildUserMapping(PgUserMapping obj2, DasObject source, SqlObjectBuilder.Context context) {
        if (source instanceof SqlCreateStatementImpl) {
            String user = null;
            List<String> options = CollectionsKt.emptyList();
            SqlObjectBuilderImpl this_$iv = this;
            boolean $i$f$forEachChild = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                boolean bl = false;
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)it);
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_FOR)) {
                    user = this.findUser(it);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_OPTIONS)) continue;
                options = this.findOptions(it);
            }
            obj2.setUser(user);
            obj2.setOptions(options);
        }
    }

    private final void buildRoutine(PgRoutine obj2, DasObject source, SqlObjectBuilder.Context context) {
        super.buildRoutine(obj2, source, context);
        if (source instanceof SqlCreateProcedureStatement) {
            ArrayList<String> assignments = new ArrayList<String>();
            PgRoutineConcurrencyKind concurrencyKind = PgRoutineConcurrencyKind.UNSAFE;
            boolean isWindow = false;
            float rows = 0.0f;
            SqlObjectBuilderImpl this_$iv = this;
            boolean $i$f$forEachChild = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                IElementType iElementType;
                PsiElement s;
                PsiElement it = tmp$iv$iv;
                boolean bl = false;
                PsiElement psiElement = s = it.getFirstChild();
                Object object = iElementType = psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null;
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SET)) {
                    SqlObjectBuilderImpl this_$iv2 = this;
                    boolean $i$f$forEachSibling2 = false;
                    for (PsiElement tmp$iv = s; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                        PsiElement it2 = tmp$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it2), (Object)PgTypes.PG_SET_ASSIGNMENT)) continue;
                        assignments.add(it2.getText());
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_PARALLEL)) {
                    PsiElement psiElement2 = s;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"s");
                    concurrencyKind = this.findConcurrencyKind(psiElement2);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_WINDOW)) {
                    isWindow = true;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SECURITY) && !Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_ROWS)) continue;
                Float f = this.findNumberInSiblings(s);
                rows = f != null ? f.floatValue() : 0.0f;
            }
            obj2.setConcurrencyKind(concurrencyKind);
            obj2.setWindow(isWindow);
            obj2.setRows(rows);
        }
    }

    private final PgRoutineConcurrencyKind findConcurrencyKind(PsiElement element) {
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$forEachSibling = false;
        for (PsiElement tmp$iv = element; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
            PsiElement it = tmp$iv;
            boolean bl = false;
            ASTNode aSTNode = it.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it.node");
            IElementType iElementType = aSTNode.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SAFE)) {
                return PgRoutineConcurrencyKind.SAFE;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_RESTRICTED)) {
                return PgRoutineConcurrencyKind.RESTRICTED;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_UNSAFE)) continue;
            return PgRoutineConcurrencyKind.UNSAFE;
        }
        return PgRoutineConcurrencyKind.UNSAFE;
    }

    private final List<String> findOptions(PsiElement source) {
        return this.findOptions(source, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)new Function1<PsiElement, PsiElement>(this){
            final /* synthetic */ PgObjectBuilder this$0;

            @Nullable
            public final PsiElement invoke(@NotNull PsiElement current) {
                PsiElement psiElement;
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                    SqlObjectBuilderImpl this_$iv = this.this$0;
                    boolean $i$f$findSibling = false;
                    for (PsiElement tmp$iv = current; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                        PsiElement it = tmp$iv;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual((Object)it, (Object)current) ^ true && Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)SqlElementTypes.SQL_STRING_LITERAL) ^ true && Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)SqlElementTypes.WHITE_SPACE) ^ true)) continue;
                        psiElement = tmp$iv;
                        break block1;
                    }
                    psiElement = null;
                }
                return psiElement;
            }
            {
                this.this$0 = pgObjectBuilder;
                super(1);
            }
        }), (Function1<? super String, String>)((Function1)findOptions.2.INSTANCE));
    }

    private final String findUser(PsiElement source) {
        SqlReferenceElementType sqlReferenceElementType = SqlElementTypes.SQL_USER_REFERENCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceElementType, (String)"SqlElementTypes.SQL_USER_REFERENCE");
        PsiElement userReference = this.findSibling(source, (IElementType)sqlReferenceElementType);
        if (userReference instanceof SqlReferenceExpression) {
            return ((SqlReferenceExpression)userReference).getName();
        }
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$forEachSibling = false;
        for (PsiElement tmp$iv = source; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
            PsiElement it = tmp$iv;
            boolean bl = false;
            ASTNode aSTNode = it.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it.node");
            IElementType iElementType = aSTNode.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_USER_REFERENCE)) {
                if (!(userReference instanceof SqlReferenceExpression)) continue;
                return ((SqlReferenceExpression)userReference).getName();
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_USER)) {
                return "user";
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_CURRENT_USER)) {
                return "current_user";
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_PUBLIC)) continue;
            return "public";
        }
        return null;
    }

    public static final /* synthetic */ PsiElement access$findSibling(PgObjectBuilder $this, PsiElement element, Function1 action) {
        return $this.findSibling(element, (Function1<? super PsiElement, Boolean>)action);
    }
}

