/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.introspector;

import com.google.common.collect.ImmutableSet;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.mssql.generator.MsNamingService;
import com.intellij.database.dialects.mssql.introspector.MsIntroQueries;
import com.intellij.database.dialects.mssql.introspector.MsIntrospectorKt;
import com.intellij.database.dialects.mssql.model.MsCustomType;
import com.intellij.database.dialects.mssql.model.MsExtendedPropertiesHolder;
import com.intellij.database.dialects.mssql.model.MsKey;
import com.intellij.database.dialects.mssql.model.MsSchemaObject;
import com.intellij.database.dialects.mssql.model.MsTable;
import com.intellij.database.dialects.mssql.model.MsTableType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.NameValueType;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.basic.BasicColumniation;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMixinColumniation;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.DataTypeFactory;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u00a0\u0001\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0012\u0010\u0012\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\u001a*\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0001H\u0002\u001a7\u0010\u001e\u001a\u0002H\u001f\"\b\b\u0000\u0010\u001f*\u00020 2\u000e\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u001f0\"2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010$\u001a\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a\f\u0010(\u001a\u00020\n*\u00020)H\u0002\u001a\u0016\u0010*\u001a\u00020\n*\u00020\n2\b\u0010+\u001a\u0004\u0018\u00010\nH\u0002\u001a\u0014\u0010,\u001a\u0004\u0018\u00010\n*\b\u0012\u0004\u0012\u00020)0-H\u0002\u001a\u001c\u0010.\u001a\u0004\u0018\u00010/*\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020\n0-H\u0002\u001a\u0018\u00102\u001a\b\u0012\u0004\u0012\u0002030-*\b\u0012\u0004\u0012\u00020)0-H\u0002\u001a \u00104\u001a\u000205*\u0002062\b\u00107\u001a\u0004\u0018\u0001082\b\u00109\u001a\u0004\u0018\u000108H\u0002\u001a\u001c\u0010:\u001a\u000205*\u00020;2\u000e\u0010<\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010-H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"2\u0010\b\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"ALIAS_TYPE_KIND", "", "FULLTEXT_INDEX_POSITION", "", "SURROGATE_NAME_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "TABLE_TYPE_KIND", "VARIABLE_TYPES", "Lcom/google/common/collect/ImmutableSet;", "", "canCheckOutdated", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "catalogPrefix", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "detectSurrogateName", "name", "makeCascadeRule", "Lcom/intellij/database/model/properties/CascadeRule;", "code", "makeDataType", "Lcom/intellij/database/model/DataType;", "type_name", "max_length", "", "precision", "scale", "renewType", "T", "Lcom/intellij/database/dialects/mssql/model/MsCustomType;", "family", "Lcom/intellij/database/model/families/ModNamingFamily;", "typeId", "(Lcom/intellij/database/model/families/ModNamingFamily;ILjava/lang/String;)Lcom/intellij/database/dialects/mssql/model/MsCustomType;", "unpackEvents", "", "Lcom/intellij/database/model/TrigEvent;", "asLiteral", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneProperty;", "cast", "type", "comment", "", "findKeyByColumns", "Lcom/intellij/database/dialects/mssql/model/MsKey;", "Lcom/intellij/database/dialects/mssql/model/MsTable;", "names", "properties", "Lcom/intellij/database/model/NameValueType;", "setCreatedAndModifiedTimestamps", "", "Lcom/intellij/database/dialects/mssql/model/MsSchemaObject;", "createdTimestamp", "Ljava/util/Date;", "modifiedTimestamp", "setExtProps", "Lcom/intellij/database/dialects/mssql/model/MsExtendedPropertiesHolder;", "props", "intellij.database.dialects.mssql"})
public final class MsIntrospectorKt {
    private static final byte ALIAS_TYPE_KIND = 1;
    private static final byte TABLE_TYPE_KIND = 2;
    private static final Pattern SURROGATE_NAME_PATTERN = Pattern.compile("^\\s*\\w{2}\\S{2,18}__[\\dA-F]{8,16}\\s*$", 2);
    private static final ImmutableSet<String> VARIABLE_TYPES = ImmutableSet.of((Object)"decimal", (Object)"numeric", (Object)"varbinary", (Object)"varchar", (Object)"binary", (Object)"char", (Object[])new String[]{"nvarchar", "nchar", "time", "datetime2", "datetimeoffset"});
    private static final short FULLTEXT_INDEX_POSITION = Short.MAX_VALUE;

    private static final void setExtProps(@NotNull MsExtendedPropertiesHolder $this$setExtProps, List<MsIntroQueries.OneProperty> props) {
        List list = props;
        $this$setExtProps.setComment(list != null ? MsIntrospectorKt.comment(list) : null);
        List list2 = props;
        if (list2 == null || (list2 = MsIntrospectorKt.properties(list2)) == null) {
            list2 = CollectionsKt.emptyList();
        }
        $this$setExtProps.setExtendedProperties(list2);
    }

    private static final String comment(@NotNull List<MsIntroQueries.OneProperty> $this$comment) {
        Object v0;
        block1: {
            Iterable iterable = $this$comment;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                MsIntroQueries.OneProperty it = (MsIntroQueries.OneProperty)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.name, (Object)"MS_Description")) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        MsIntroQueries.OneProperty oneProperty = v0;
        return oneProperty != null ? oneProperty.value : null;
    }

    private static final List<NameValueType> properties(@NotNull List<MsIntroQueries.OneProperty> $this$properties) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$properties), (Function1)properties.1.INSTANCE), (Function1)properties.2.INSTANCE));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final String asLiteral(@NotNull MsIntroQueries.OneProperty $this$asLiteral) {
        String string;
        String string2 = $this$asLiteral.type;
        if (string2 != null) {
            switch (string2) {
                case "varbinary": 
                case "binary": {
                    String string3 = $this$asLiteral.value;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"value");
                    string = ScriptGeneratorHelperKt.getSqlString(string3);
                    return string;
                }
                case "nvarchar": 
                case "nchar": {
                    StringBuilder stringBuilder = new StringBuilder().append("N");
                    String string4 = $this$asLiteral.value;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"value");
                    string = stringBuilder.append(ScriptGeneratorHelperKt.getSqlString(string4)).toString();
                    return string;
                }
                case "numeric": 
                case "tinyint": 
                case "smallmoney": 
                case "real": 
                case "float": 
                case "int": 
                case "smallint": 
                case "money": 
                case "decimal": 
                case "bigint": {
                    String string5 = $this$asLiteral.value;
                    string = string5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"value");
                    return string;
                }
            }
        }
        String string6 = $this$asLiteral.value;
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"value");
        string = ScriptGeneratorHelperKt.getSqlString(string6);
        return string;
    }

    private static final String cast(@NotNull String $this$cast, String type) {
        return "cast(" + $this$cast + " as " + type + ')';
    }

    private static final <T extends MsCustomType> T renewType(ModNamingFamily<? extends T> family, int typeId, String name2) {
        MsCustomType type = null;
        type = (MsCustomType)family.find(new Predicate<T>(typeId){
            final /* synthetic */ int $typeId;

            public final boolean test(T it) {
                T t = it;
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"it");
                return t.getTypeId() == this.$typeId;
            }
            {
                this.$typeId = n;
            }
        });
        if (type != null) {
            type.setName(name2);
            type.resetSyncPending();
            return (T)type;
        }
        type = (MsCustomType)family.get(name2);
        if (type != null && type.getTypeId() == 0) {
            type.setTypeId(typeId);
            type.resetSyncPending();
            return (T)type;
        }
        type = (MsCustomType)family.createNewOne();
        type.setTypeId(typeId);
        type.setName(name2);
        return (T)type;
    }

    private static final MsKey findKeyByColumns(@NotNull MsTable $this$findKeyByColumns, List<String> names) {
        Object v1;
        block1: {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)$this$findKeyByColumns.getKeys();
            Intrinsics.checkExpressionValueIsNotNull((Object)modNamingIdentifyingFamily, (String)"this.keys");
            Iterable $this$firstOrNull$iv = (Iterable)modNamingIdentifyingFamily;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MsKey it = (MsKey)element$iv;
                boolean bl = false;
                if (!BasicMixinColumniation.areColNames((BasicColumniation)((BasicColumniation)it), names)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final Set<TrigEvent> unpackEvents(byte e) {
        byte $this$and$iv;
        EnumSet<TrigEvent> events = EnumSet.noneOf(TrigEvent.class);
        byte by = e;
        byte that$iv = 1;
        boolean $i$f$and = false;
        byte $this$toUnsignedInt$iv$iv = $this$and$iv;
        boolean $i$f$toUnsignedInt = false;
        int n = Byte.toUnsignedInt($this$toUnsignedInt$iv$iv);
        $this$toUnsignedInt$iv$iv = that$iv;
        int n2 = n;
        $i$f$toUnsignedInt = false;
        int n3 = Byte.toUnsignedInt($this$toUnsignedInt$iv$iv);
        if ((byte)(n2 & n3) != 0) {
            events.add(TrigEvent.INSERT);
        }
        $this$and$iv = e;
        that$iv = 2;
        $i$f$and = false;
        $this$toUnsignedInt$iv$iv = $this$and$iv;
        $i$f$toUnsignedInt = false;
        int n4 = Byte.toUnsignedInt($this$toUnsignedInt$iv$iv);
        $this$toUnsignedInt$iv$iv = that$iv;
        n2 = n4;
        $i$f$toUnsignedInt = false;
        n3 = Byte.toUnsignedInt($this$toUnsignedInt$iv$iv);
        if ((byte)(n2 & n3) != 0) {
            events.add(TrigEvent.UPDATE);
        }
        $this$and$iv = e;
        that$iv = 4;
        $i$f$and = false;
        $this$toUnsignedInt$iv$iv = $this$and$iv;
        $i$f$toUnsignedInt = false;
        int n5 = Byte.toUnsignedInt($this$toUnsignedInt$iv$iv);
        $this$toUnsignedInt$iv$iv = that$iv;
        n2 = n5;
        $i$f$toUnsignedInt = false;
        n3 = Byte.toUnsignedInt($this$toUnsignedInt$iv$iv);
        if ((byte)(n2 & n3) != 0) {
            events.add(TrigEvent.DELETE);
        }
        EnumSet<TrigEvent> enumSet = events;
        Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"events");
        return enumSet;
    }

    private static final void setCreatedAndModifiedTimestamps(@NotNull MsSchemaObject $this$setCreatedAndModifiedTimestamps, Date createdTimestamp, Date modifiedTimestamp) {
        $this$setCreatedAndModifiedTimestamps.setCreatedTimestamp(createdTimestamp);
        $this$setCreatedAndModifiedTimestamps.setModifiedTimestamp(modifiedTimestamp);
    }

    private static final String catalogPrefix(BasicDatabase database) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = database.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"database.name");
        return stringBuilder.append(MsNamingService.INSTANCE.nameToScript(string, false)).append(".sys").toString();
    }

    private static final boolean detectSurrogateName(String name2) {
        if (name2 == null) {
            return false;
        }
        return SURROGATE_NAME_PATTERN.matcher(name2).matches();
    }

    private static final DataType makeDataType(String type_name, int max_length, int precision, byte scale) {
        DataType dt = null;
        if (type_name != null) {
            if (VARIABLE_TYPES.contains((Object)type_name)) {
                if (Intrinsics.areEqual((Object)type_name, (Object)"time") || Intrinsics.areEqual((Object)type_name, (Object)"datetime2") || Intrinsics.areEqual((Object)type_name, (Object)"datetimeoffset")) {
                    int size = scale >= 0 && scale <= 6 ? (int)scale : -1;
                    LengthUnit units = size >= 0 ? LengthUnit.DIGIT : null;
                    DataType dataType = DataTypeFactory.of(null, (String)type_name, (int)size, (int)0, (LengthUnit)units, null, (boolean)false, (boolean)false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(null,\u2026nits, null, false, false)");
                    dt = dataType;
                } else if (precision > 0) {
                    DataType dataType = DataTypeFactory.of(null, (String)type_name, (int)precision, (int)scale, null, null, (boolean)false, (boolean)false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(null,\u2026null, null, false, false)");
                    dt = dataType;
                } else if (Intrinsics.areEqual((Object)type_name, (Object)"char") || Intrinsics.areEqual((Object)type_name, (Object)"nchar") || Intrinsics.areEqual((Object)type_name, (Object)"varchar") || Intrinsics.areEqual((Object)type_name, (Object)"nvarchar") || Intrinsics.areEqual((Object)type_name, (Object)"varbinary")) {
                    boolean national;
                    boolean bl = national = type_name.charAt(0) == 'n';
                    int length = max_length == -1 ? Integer.MAX_VALUE : (national ? max_length >> 1 : max_length);
                    DataType dataType = DataTypeFactory.of(null, (String)type_name, (int)length, (int)0, (LengthUnit)LengthUnit.CHAR, null, (boolean)false, (boolean)false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(null,\u2026CHAR, null, false, false)");
                    dt = dataType;
                } else if (max_length > 0) {
                    DataType dataType = DataTypeFactory.of(null, (String)type_name, (int)max_length, (int)scale, null, null, (boolean)false, (boolean)false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(null,\u2026null, null, false, false)");
                    dt = dataType;
                } else {
                    DataType dataType = DataTypeFactory.of((String)type_name);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(type_name)");
                    dt = dataType;
                }
            } else {
                DataType dataType = DataTypeFactory.of((String)type_name);
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(type_name)");
                dt = dataType;
            }
        } else {
            DataType dataType = DataType.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataType.UNKNOWN");
            dt = dataType;
        }
        return dt;
    }

    private static final CascadeRule makeCascadeRule(byte code) {
        CascadeRule cascadeRule;
        switch (code) {
            case 1: {
                cascadeRule = CascadeRule.cascade;
                break;
            }
            case 2: {
                cascadeRule = CascadeRule.set_null;
                break;
            }
            case 3: {
                cascadeRule = CascadeRule.set_default;
                break;
            }
            default: {
                cascadeRule = CascadeRule.no_action;
            }
        }
        return cascadeRule;
    }

    private static final boolean canCheckOutdated(BasicElement e) {
        return e == null || e instanceof MsSchemaObject && !(e instanceof MsTableType) && ((MsSchemaObject)e).getModifiedTimestamp() != null;
    }

    public static final /* synthetic */ boolean access$canCheckOutdated(BasicElement e) {
        return MsIntrospectorKt.canCheckOutdated(e);
    }

    public static final /* synthetic */ void access$setExtProps(MsExtendedPropertiesHolder $this$access_u24setExtProps, List props) {
        MsIntrospectorKt.setExtProps($this$access_u24setExtProps, props);
    }

    public static final /* synthetic */ void access$setCreatedAndModifiedTimestamps(MsSchemaObject $this$access_u24setCreatedAndModifiedTimestamps, Date createdTimestamp, Date modifiedTimestamp) {
        MsIntrospectorKt.setCreatedAndModifiedTimestamps($this$access_u24setCreatedAndModifiedTimestamps, createdTimestamp, modifiedTimestamp);
    }

    public static final /* synthetic */ MsCustomType access$renewType(ModNamingFamily family, int typeId, String name2) {
        return MsIntrospectorKt.renewType(family, typeId, name2);
    }

    public static final /* synthetic */ DataType access$makeDataType(String type_name, int max_length, int precision, byte scale) {
        return MsIntrospectorKt.makeDataType(type_name, max_length, precision, scale);
    }

    public static final /* synthetic */ boolean access$detectSurrogateName(String name2) {
        return MsIntrospectorKt.detectSurrogateName(name2);
    }

    public static final /* synthetic */ CascadeRule access$makeCascadeRule(byte code) {
        return MsIntrospectorKt.makeCascadeRule(code);
    }

    public static final /* synthetic */ MsKey access$findKeyByColumns(MsTable $this$access_u24findKeyByColumns, List names) {
        return MsIntrospectorKt.findKeyByColumns($this$access_u24findKeyByColumns, names);
    }

    public static final /* synthetic */ Set access$unpackEvents(byte e) {
        return MsIntrospectorKt.unpackEvents(e);
    }

    public static final /* synthetic */ String access$catalogPrefix(BasicDatabase database) {
        return MsIntrospectorKt.catalogPrefix(database);
    }

    public static final /* synthetic */ String access$asLiteral(MsIntroQueries.OneProperty $this$access_u24asLiteral) {
        return MsIntrospectorKt.asLiteral($this$access_u24asLiteral);
    }
}

