/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.introspector;

import com.intellij.database.introspection.LongIdName;
import com.intellij.database.remote.jdba.core.Layouts;
import com.intellij.database.remote.jdba.core.RowLayout;
import com.intellij.database.remote.jdba.sql.Scriptum;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import java.sql.Timestamp;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class MsIntroQueries {
    static final MsIntroQueries QUERIES = new MsIntroQueries();
    @NotNull
    private final Scriptum myScriptum = Scriptum.of(MsIntroQueries.class);
    final SqlQuery<CurrentSessionInfo> queryCurrentSessionInfo = this.myScriptum.query("QueryCurrentSessionInfo", Layouts.rowOf((RowLayout)Layouts.structOf(CurrentSessionInfo.class)));
    final SqlQuery<String> queryFingerprint = this.myScriptum.query("QueryFingerprint", Layouts.singleOf(String.class));
    final SqlQuery<List<DbInfo>> listDatabases = this.myScriptum.query("ListDatabases", Layouts.listOf((RowLayout)Layouts.structOf(DbInfo.class)));
    final SqlQuery<List<LongIdName>> listSchemas = this.myScriptum.query("ListSchemas", Layouts.listOf((RowLayout)Layouts.structOf(LongIdName.class)));
    final SqlQuery<int[]> listExistentObjects = this.myScriptum.query("ListExistentObjects", Layouts.columnOfInts((int)4096));
    final SqlQuery<long[]> listExistentIndices = this.myScriptum.query("ListExistentIndices", Layouts.columnOfLongs((int)4096));
    final SqlQuery<long[]> listExistentFulltextIndices = this.myScriptum.query("ListExistentFulltextIndices", Layouts.columnOfLongs((int)4096));
    final SqlQuery<List<OneCustomTypesCheckSum>> calculateCustomTypesCheckSums = this.myScriptum.query("CalculateCustomTypesCheckSums", Layouts.listOf((RowLayout)Layouts.structOf(OneCustomTypesCheckSum.class)));
    final SqlQuery<List<OneAliasType>> retrieveAliasTypes = this.myScriptum.query("RetrieveAliasTypes", Layouts.listOf((RowLayout)Layouts.structOf(OneAliasType.class)));
    final SqlQuery<List<OneTableType>> retrieveTableTypes = this.myScriptum.query("RetrieveTableTypes", Layouts.listOf((RowLayout)Layouts.structOf(OneTableType.class)));
    final SqlQuery<List<OneObject>> retrieveObjects = this.myScriptum.query("RetrieveObjects", Layouts.listOf((RowLayout)Layouts.structOf(OneObject.class)));
    final SqlQuery<List<OneColumn>> retrieveColumns = this.myScriptum.query("RetrieveColumns", Layouts.listOf((RowLayout)Layouts.structOf(OneColumn.class)));
    final SqlQuery<List<OneColumn>> retrieveTypeColumns = this.myScriptum.query("RetrieveTypeColumns", Layouts.listOf((RowLayout)Layouts.structOf(OneColumn.class)));
    final SqlQuery<List<OneIndex>> retrieveIndices = this.myScriptum.query("RetrieveIndices", Layouts.listOf((RowLayout)Layouts.structOf(OneIndex.class)));
    final SqlQuery<List<OneIndex>> retrieveTypeIndices = this.myScriptum.query("RetrieveTypeIndices", Layouts.listOf((RowLayout)Layouts.structOf(OneIndex.class)));
    final SqlQuery<List<OneFulltextIndex>> retrieveFulltextIndices = this.myScriptum.query("RetrieveFulltextIndices", Layouts.listOf((RowLayout)Layouts.structOf(OneFulltextIndex.class)));
    final SqlQuery<List<OneIndexColumn>> retrieveIndexColumns = this.myScriptum.query("RetrieveIndexColumns", Layouts.listOf((RowLayout)Layouts.structOf(OneIndexColumn.class)));
    final SqlQuery<List<OneIndexColumn>> retrieveTypeIndexColumns = this.myScriptum.query("RetrieveTypeIndexColumns", Layouts.listOf((RowLayout)Layouts.structOf(OneIndexColumn.class)));
    final SqlQuery<List<OneFulltextIndexColumn>> retrieveFulltextIndexColumns = this.myScriptum.query("RetrieveFulltextIndexColumns", Layouts.listOf((RowLayout)Layouts.structOf(OneFulltextIndexColumn.class)));
    final SqlQuery<List<OneKey>> retrieveKeys = this.myScriptum.query("RetrieveKeys", Layouts.listOf((RowLayout)Layouts.structOf(OneKey.class)));
    final SqlQuery<List<OneKey>> retrieveTypeKeys = this.myScriptum.query("RetrieveTypeKeys", Layouts.listOf((RowLayout)Layouts.structOf(OneKey.class)));
    final SqlQuery<List<OneCheckConstraints>> retrieveCheckConstraints = this.myScriptum.query("RetrieveCheckConstraints", Layouts.listOf((RowLayout)Layouts.structOf(OneCheckConstraints.class)));
    final SqlQuery<List<OneCheckConstraints>> retrieveTypeCheckConstraints = this.myScriptum.query("RetrieveTypeCheckConstraints", Layouts.listOf((RowLayout)Layouts.structOf(OneCheckConstraints.class)));
    final SqlQuery<List<OneForeignKey>> retrieveForeignKeys = this.myScriptum.query("RetrieveForeignKeys", Layouts.listOf((RowLayout)Layouts.structOf(OneForeignKey.class)));
    final SqlQuery<List<OneForeignKeyColumn>> retrieveForeignKeyColumns = this.myScriptum.query("RetrieveForeignKeyColumns", Layouts.listOf((RowLayout)Layouts.structOf(OneForeignKeyColumn.class)));
    final SqlQuery<List<OneArguments>> retrieveArguments = this.myScriptum.query("RetrieveArguments", Layouts.listOf((RowLayout)Layouts.structOf(OneArguments.class)));
    final SqlQuery<List<OneTrigger>> retrieveTriggers = this.myScriptum.query("RetrieveTriggers", Layouts.listOf((RowLayout)Layouts.structOf(OneTrigger.class)));
    final SqlQuery<List<OneSynonym>> retrieveSynonyms = this.myScriptum.query("RetrieveSynonyms", Layouts.listOf((RowLayout)Layouts.structOf(OneSynonym.class)));
    final SqlQuery<List<OneSequence>> retrieveSequences = this.myScriptum.query("RetrieveSequences", Layouts.listOf((RowLayout)Layouts.structOf(OneSequence.class)));
    final SqlQuery<List<OneRule>> retrieveRules = this.myScriptum.query("RetrieveRules", Layouts.listOf((RowLayout)Layouts.structOf(OneRule.class)));
    final SqlQuery<Long> calculateExtendedPropertiesChecksum = this.myScriptum.query("CalculateExtendedPropertiesChecksum", Layouts.singleOf(Long.class));
    final SqlQuery<List<OneProperty>> retrieveExtendedProperties = this.myScriptum.query("RetrieveExtendedProperties", Layouts.listOf((RowLayout)Layouts.structOf(OneProperty.class)));
    final SqlQuery<List<OneProperty>> retrieveDbExtendedProperties = this.myScriptum.query("RetrieveDbExtendedProperties", Layouts.listOf((RowLayout)Layouts.structOf(OneProperty.class)));
    final SqlQuery<List<OneSource>> retrieveSources = this.myScriptum.query("RetrieveSources", Layouts.listOf((RowLayout)Layouts.structOf(OneSource.class)));
    final SqlQuery<List<OneSource>> retrieveSourcesWithSys = this.myScriptum.query("RetrieveSourcesWithSys", Layouts.listOf((RowLayout)Layouts.structOf(OneSource.class)));
    final SqlQuery<List<OneState>> retrieveStates = this.myScriptum.query("RetrieveStates", Layouts.listOf((RowLayout)Layouts.structOf(OneState.class)));

    static final class OneState {
        long object_id;
        Timestamp modify_date;

        OneState() {
        }
    }

    static final class OneSource {
        long parent_id;
        long object_id;
        boolean is_trigger;
        String text;

        OneSource() {
        }
    }

    static final class OneProperty {
        long object_id;
        short position;
        String name;
        String value;
        String type;

        OneProperty() {
        }
    }

    static final class OneRule {
        long object_id;
        String name;
        Timestamp create_date;
        Timestamp modify_date;

        OneRule() {
        }
    }

    static final class OneSequence {
        long object_id;
        String name;
        Timestamp create_date;
        Timestamp modify_date;
        Object start_value;
        Object current_value;
        Object increment;
        Object minimum_value;
        Object maximum_value;
        boolean is_cycling;
        boolean is_cached;
        Long cache_size;
        String system_type_name;
        String type_name;
        String type_schema_name;
        int precision;

        OneSequence() {
        }
    }

    static final class OneSynonym {
        long object_id;
        String name;
        Timestamp create_date;
        Timestamp modify_date;
        String origin_db_name;
        String origin_schema_name;
        String origin_object_name;
        long origin_id;
        String base_object_name;

        OneSynonym() {
        }
    }

    static final class OneTrigger {
        long table_id;
        long trigger_id;
        String name;
        byte events;
        byte first_events;
        byte last_events;
        boolean is_instead_of_trigger;
        boolean is_not_for_replication;
        boolean is_disabled;
        boolean encrypted;
        Timestamp create_date;
        Timestamp modify_date;

        OneTrigger() {
        }
    }

    static final class OneArguments {
        int object_id;
        short position;
        String name;
        String type_name;
        int max_length;
        int precision;
        byte scale;
        boolean is_output;
        boolean is_cursor_ref;
        boolean has_default_value;

        OneArguments() {
        }
    }

    static final class OneForeignKeyColumn {
        long constraint_id;
        String domestic_column_name;
        String reference_column_name;

        OneForeignKeyColumn() {
        }
    }

    static final class OneForeignKey {
        long table_id;
        long constraint_id;
        String name;
        boolean is_system_named;
        boolean is_disabled;
        long referenced_schema_id;
        long referenced_object_id;
        String referenced_object_name;
        int key_index_id;
        byte update_referential_action;
        byte delete_referential_action;
        Timestamp create_date;
        Timestamp modify_date;

        OneForeignKey() {
        }
    }

    static final class OneCheckConstraints {
        int table_id;
        int constraint_id;
        String name;
        boolean is_system_named;
        String column_name;
        String definition;
        Timestamp create_date;
        Timestamp modify_date;

        OneCheckConstraints() {
        }
    }

    static final class OneKey {
        int table_id;
        int key_id;
        short index_position;
        String name;
        boolean is_primary;
        boolean is_system_named;
        Timestamp create_date;
        Timestamp modify_date;

        OneKey() {
        }
    }

    static final class OneFulltextIndexColumn {
        int object_id;
        String name;

        OneFulltextIndexColumn() {
        }
    }

    static final class OneIndexColumn {
        int object_id;
        short index_position;
        String name;
        boolean is_desc;
        boolean is_included_column;

        OneIndexColumn() {
        }
    }

    static final class OneFulltextIndex {
        int object_id;
        int unique_index_id;

        OneFulltextIndex() {
        }
    }

    static final class OneIndex {
        int object_id;
        short position;
        String name;
        String filter_definition;
        byte type;
        boolean is_unique;
        boolean is_disabled;

        OneIndex() {
        }
    }

    static final class OneColumn {
        int object_id;
        short column_position;
        String name;
        String type_name;
        int max_length;
        int precision;
        byte scale;
        String collation_name;
        boolean is_nullable;
        boolean is_computed;
        Long identity_seed_value;
        Long identity_increment_value;
        Long identity_last_value;
        String default_expression;
        String default_constraint_name;
        boolean default_constraint_name_is_surrogate;
        int default_constraint_object_id;
        Timestamp default_constraint_modify_date;
        boolean is_hidden;
        boolean is_sparse;
        boolean is_column_set;

        OneColumn() {
        }
    }

    static final class OneObject {
        int object_id;
        String name;
        String type;
        Timestamp create_date;
        Timestamp modify_date;
        boolean is_ms_shipped;

        OneObject() {
        }
    }

    static final class OneTableType {
        int type_id;
        int object_id;
        String name;
        Timestamp create_date;
        Timestamp modify_date;

        OneTableType() {
        }
    }

    static final class OneAliasType {
        int type_id;
        String name;
        String base_name;
        int max_length;
        int precision;
        byte scale;
        boolean is_nullable;

        OneAliasType() {
        }
    }

    static final class OneCustomTypesCheckSum {
        byte type_kind;
        long check_sum;

        OneCustomTypesCheckSum() {
        }
    }

    static final class DbInfo {
        long id;
        String name;
        String collation_name;

        DbInfo() {
        }
    }

    static final class CurrentSessionInfo {
        boolean is_azure;
        int db_id;
        String db_name;
        int schema_id;
        String schema_name;

        CurrentSessionInfo() {
        }
    }
}

