/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector.jdbc.wrappers;

import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.JBIterable;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaLoader {
    private static final Logger LOG = Logger.getInstance(SchemaLoader.class);

    public static ClosableIt<String> catalogs(DatabaseMetaDataWrapper meta) throws SQLException {
        try {
            if (meta.getDbms().isPostgres()) {
                return SchemaLoader.pgCatalogs(meta);
            }
        }
        catch (SQLException e) {
            LOG.debug((Throwable)e);
        }
        try {
            return SchemaLoader.jdbcCatalogs(meta);
        }
        catch (RuntimeException | SQLException e) {
            return SchemaLoader.currentCatalog(meta);
        }
    }

    @NotNull
    private static ClosableIt<String> currentCatalog(DatabaseMetaDataWrapper meta) throws SQLException {
        String catalog = (String)JdbcNativeUtil.computeRemote(() -> meta.getConnection().getRemoteConnection().getCatalog());
        ClosableIt<String> closableIt = ClosableIt.from(JBIterable.of((Object)catalog).iterator());
        if (closableIt == null) {
            SchemaLoader.$$$reportNull$$$0(0);
        }
        return closableIt;
    }

    private static ClosableIt<String> pgCatalogs(@NotNull DatabaseMetaDataWrapper meta) throws SQLException {
        RemoteStatement statement;
        if (meta == null) {
            SchemaLoader.$$$reportNull$$$0(1);
        }
        if ((statement = (RemoteStatement)JdbcNativeUtil.computeRemote(() -> meta.getConnection().getRemoteConnection().createStatement())) == null) {
            return ClosableIt.empty();
        }
        try (ClosableIt.AutoCloseableGuard<AutoCloseable> g = ClosableIt.AutoCloseableGuard.guarded(() -> ((RemoteStatement)statement).close());){
            ClosableIt<String> res2 = new ClosableIt.ResultSetDelegateIt<String>((RemoteResultSet)JdbcNativeUtil.computeRemote(() -> statement.executeQuery("select datname as name from pg_catalog.pg_database where not datistemplate")), g.get()){

                @Override
                protected String calcValue() throws SQLException {
                    return this.myRs.getString("name", 1);
                }
            }.withErrorSink(meta.getErrorSink());
            g.release();
            ClosableIt<String> closableIt = res2;
            return closableIt;
        }
    }

    private static ClosableIt<String> jdbcCatalogs(@NotNull DatabaseMetaDataWrapper meta) throws SQLException {
        if (meta == null) {
            SchemaLoader.$$$reportNull$$$0(2);
        }
        RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> meta.getMetaData().getCatalogs());
        return new ClosableIt.ResultSetDelegateIt<String>(rs, null){

            @Override
            protected String calcValue() throws SQLException {
                return this.myRs.getString("TABLE_CAT", 1);
            }
        }.withErrorSink(meta.getErrorSink());
    }

    public static ClosableIt<DatabaseMetaDataWrapper.Schema> schemas(@NotNull JBIterable<String> catalogs, @Nullable String current, @NotNull DatabaseMetaDataWrapper meta) {
        if (catalogs == null) {
            SchemaLoader.$$$reportNull$$$0(3);
        }
        if (meta == null) {
            SchemaLoader.$$$reportNull$$$0(4);
        }
        ClosableIt<DatabaseMetaDataWrapper.Schema> specific = null;
        if (meta.getDbms().isMicrosoft()) {
            specific = SchemaLoader.mssqlSchemas(catalogs.iterator(), meta);
        } else if (meta.getDbms().isOracle()) {
            specific = SchemaLoader.oracleSchemas(meta);
        }
        if (specific != null) {
            return ClosableIt.lazyAppendIfEmpty(specific, () -> SchemaLoader.jdbcSchemas(catalogs, current, meta));
        }
        return SchemaLoader.jdbcSchemas(catalogs, current, meta);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClosableIt<DatabaseMetaDataWrapper.Schema> oracleSchemas(@NotNull DatabaseMetaDataWrapper meta) {
        if (meta == null) {
            SchemaLoader.$$$reportNull$$$0(5);
        }
        String queryText = "select username                                                       \nfrom sys.all_users U                                                  \nwhere exists (select 1 from sys.all_objects where owner = U.username) \n   or username = user                                                 \n   or username = sys_context('userenv','current_schema')              \n";
        RemoteStatement statement = (RemoteStatement)JdbcNativeUtil.computeSafe(() -> meta.getConnection().getRemoteConnection().createStatement());
        if (statement == null) {
            return ClosableIt.empty();
        }
        try (ClosableIt.AutoCloseableGuard<AutoCloseable> g = ClosableIt.AutoCloseableGuard.guarded(() -> ((RemoteStatement)statement).close());){
            ClosableIt<DatabaseMetaDataWrapper.Schema> res2 = new ClosableIt.ResultSetDelegateIt<DatabaseMetaDataWrapper.Schema>((RemoteResultSet)JdbcNativeUtil.computeRemote(() -> statement.executeQuery(queryText)), g.get()){

                @Override
                protected DatabaseMetaDataWrapper.Schema calcValue() throws SQLException {
                    return new DatabaseMetaDataWrapper.Schema(DbUtil.intern((String)this.myRs.getString("USERNAME", 1)), null);
                }
            }.withErrorSink(meta.getErrorSink());
            g.release();
            ClosableIt<DatabaseMetaDataWrapper.Schema> closableIt = res2;
            return closableIt;
        }
        catch (SQLException e) {
            LOG.debug((Throwable)e);
            return ClosableIt.empty();
        }
    }

    private static ClosableIt<DatabaseMetaDataWrapper.Schema> mssqlSchemas(Iterator<String> catalogs, DatabaseMetaDataWrapper meta) {
        if (!catalogs.hasNext()) {
            return ClosableIt.empty();
        }
        return ClosableIt.lazyAppend(SchemaLoader.mssqlSchemasInCatalog(DbUtil.intern((String)catalogs.next()), meta), () -> SchemaLoader.mssqlSchemas(catalogs, meta));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClosableIt<DatabaseMetaDataWrapper.Schema> mssqlSchemasInCatalog(final String catalog, DatabaseMetaDataWrapper meta) {
        RemoteStatement statement = (RemoteStatement)JdbcNativeUtil.computeSafe(() -> meta.getConnection().getRemoteConnection().createStatement());
        if (statement == null) {
            return ClosableIt.empty();
        }
        try (ClosableIt.AutoCloseableGuard<AutoCloseable> g = ClosableIt.AutoCloseableGuard.guarded(() -> ((RemoteStatement)statement).close());){
            ClosableIt<DatabaseMetaDataWrapper.Schema> res2 = new ClosableIt.ResultSetDelegateIt<DatabaseMetaDataWrapper.Schema>((RemoteResultSet)JdbcNativeUtil.computeRemote(() -> statement.executeQuery("select name from [" + catalog + "].sys.schemas")), g.get()){

                @Override
                protected DatabaseMetaDataWrapper.Schema calcValue() throws SQLException {
                    return new DatabaseMetaDataWrapper.Schema(DbUtil.intern((String)this.myRs.getString("name", 1)), catalog);
                }
            }.withErrorSink(meta.getErrorSink());
            g.release();
            ClosableIt<DatabaseMetaDataWrapper.Schema> closableIt = res2;
            return closableIt;
        }
        catch (SQLException e) {
            LOG.debug((Throwable)e);
            return ClosableIt.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClosableIt<DatabaseMetaDataWrapper.Schema> jdbcSchemas(JBIterable<String> catalogs, String current, DatabaseMetaDataWrapper meta) {
        Throwable throwable;
        if (catalogs.isEmpty()) {
            catalogs = JBIterable.from(Collections.singletonList(null));
        }
        try {
            throwable = null;
            try (ClosableIt.AutoCloseableGuard<ClosableIt<DatabaseMetaDataWrapper.Schema>> it222 = ClosableIt.AutoCloseableGuard.guarded(SchemaLoader.jdbcSchemas1(catalogs.iterator(), meta));){
                if (it222.get().hasNext()) {
                    ClosableIt<DatabaseMetaDataWrapper.Schema> closableIt = it222.release();
                    return closableIt;
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (UnsupportedOperationException it222) {
        }
        catch (AbstractMethodError it222) {
            // empty catch block
        }
        throwable = null;
        try (ClosableIt.AutoCloseableGuard<ClosableIt<DatabaseMetaDataWrapper.Schema>> it = ClosableIt.AutoCloseableGuard.guarded(SchemaLoader.jdbcSchemas2(catalogs.iterator(), current, meta));){
            if (current != null) {
                JdbcNativeUtil.performSafe(() -> meta.getConnection().getRemoteConnection().setCatalog(current));
            }
            if (it.get().hasNext()) {
                ClosableIt<DatabaseMetaDataWrapper.Schema> closableIt = it.release();
                return closableIt;
            }
        }
        catch (Throwable throwable7) {
            throwable = throwable7;
            throw throwable7;
        }
        it = ClosableIt.AutoCloseableGuard.guarded(SchemaLoader.jdbcSchemas3((JBIterable<String>)catalogs, current, meta));
        throwable = null;
        try {
            if (it.get().hasNext()) {
                ClosableIt<DatabaseMetaDataWrapper.Schema> closableIt = it.release();
                return closableIt;
            }
        }
        catch (Throwable throwable9) {
            throwable = throwable9;
            throw throwable9;
        }
        finally {
            if (it != null) {
                if (throwable != null) {
                    try {
                        it.close();
                    }
                    catch (Throwable throwable10) {
                        throwable.addSuppressed(throwable10);
                    }
                } else {
                    it.close();
                }
            }
        }
        Object cats = catalogs;
        if (!catalogs.isEmpty()) return (ClosableIt)ClosableIt.from(cats.iterator()).map(catalog -> new DatabaseMetaDataWrapper.Schema("", (String)catalog));
        cats = Collections.singleton(null);
        return (ClosableIt)ClosableIt.from(cats.iterator()).map(catalog -> new DatabaseMetaDataWrapper.Schema("", (String)catalog));
    }

    private static ClosableIt<DatabaseMetaDataWrapper.Schema> jdbcSchemas3(final JBIterable<String> catalogs, final String current, DatabaseMetaDataWrapper meta) {
        try {
            RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> meta.getMetaData().getSchemas());
            return new ClosableIt.ResultSetDelegateIt<DatabaseMetaDataWrapper.Schema>(rs, null){
                private Iterator<String> myCats;
                private DatabaseMetaDataWrapper.Schema myCur;
                {
                    super(rs, hook);
                    this.myCats = null;
                    this.myCur = null;
                }

                @Override
                protected DatabaseMetaDataWrapper.Schema calcValue() throws SQLException {
                    String schema = this.myRs.getString("TABLE_SCHEM", 1);
                    String catalog = this.myRs.getString("TABLE_CATALOG", 2);
                    return new DatabaseMetaDataWrapper.Schema(DbUtil.intern((String)schema), catalog == null ? null : DbUtil.intern((String)catalog));
                }

                @Override
                protected DatabaseMetaDataWrapper.Schema nextImpl() {
                    if (this.myCats != null && this.myCats.hasNext() && this.myCur != null) {
                        return new DatabaseMetaDataWrapper.Schema(this.myCur.schema, this.myCats.next());
                    }
                    DatabaseMetaDataWrapper.Schema schema = (DatabaseMetaDataWrapper.Schema)super.nextImpl();
                    if (schema == null) {
                        return null;
                    }
                    if (schema.database == null && !catalogs.isEmpty()) {
                        this.myCur = schema;
                        this.myCats = catalogs.iterator();
                        return (DatabaseMetaDataWrapper.Schema)this.skip();
                    }
                    if (schema.database == null) {
                        schema.database = current;
                    }
                    return schema;
                }
            }.withErrorSink(meta.getErrorSink());
        }
        catch (SQLException e) {
            meta.onError(null, e);
            return ClosableIt.empty();
        }
    }

    private static ClosableIt<DatabaseMetaDataWrapper.Schema> jdbcSchemas2(Iterator<String> catalogs, String current, DatabaseMetaDataWrapper meta) {
        if (!catalogs.hasNext() || current == null) {
            return ClosableIt.empty();
        }
        return ClosableIt.lazyAppend(SchemaLoader.jdbcSchemasInCatalog2(DbUtil.intern((String)catalogs.next()), meta), () -> SchemaLoader.jdbcSchemas2(catalogs, current, meta));
    }

    private static ClosableIt<DatabaseMetaDataWrapper.Schema> jdbcSchemasInCatalog2(final String catalog, DatabaseMetaDataWrapper meta) {
        String dbName = catalog;
        if (meta.getDbms().isTransactSql()) {
            String q = meta.getQuote();
            dbName = q + dbName + q;
        }
        boolean catalogSet = false;
        if (dbName != null) {
            try {
                meta.getConnection().getRemoteConnection().setCatalog(dbName);
                catalogSet = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!catalogSet) {
            return ClosableIt.empty();
        }
        try {
            return new ClosableIt.ResultSetDelegateIt<DatabaseMetaDataWrapper.Schema>(meta.getMetaData().getSchemas(), null){

                @Override
                protected DatabaseMetaDataWrapper.Schema calcValue() throws SQLException {
                    String schema = this.myRs.getString("TABLE_SCHEM", 1);
                    String cat = this.myRs.getString("TABLE_CATALOG", 2);
                    if (cat != null && !cat.equals(catalog)) {
                        return (DatabaseMetaDataWrapper.Schema)this.skip();
                    }
                    return new DatabaseMetaDataWrapper.Schema(DbUtil.intern((String)schema), catalog);
                }
            }.withErrorSink(meta.getErrorSink());
        }
        catch (Exception ex) {
            meta.onError(null, ex);
            return ClosableIt.empty();
        }
    }

    private static ClosableIt<DatabaseMetaDataWrapper.Schema> jdbcSchemas1(Iterator<String> catalogs, DatabaseMetaDataWrapper meta) {
        if (!catalogs.hasNext()) {
            return ClosableIt.empty();
        }
        return ClosableIt.lazyAppend(SchemaLoader.jdbcSchemasInCatalog1(DbUtil.intern((String)catalogs.next()), meta), () -> SchemaLoader.jdbcSchemas1(catalogs, meta));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClosableIt<DatabaseMetaDataWrapper.Schema> jdbcSchemasInCatalog1(final String catalog, DatabaseMetaDataWrapper meta) {
        RemoteResultSet rs = SchemaLoader.getSchemas(catalog, meta);
        if (rs == null) {
            return ClosableIt.empty();
        }
        try (ClosableIt.AutoCloseableGuard<AutoCloseable> g = ClosableIt.AutoCloseableGuard.guarded(() -> ((RemoteResultSet)rs).close());){
            ClosableIt<DatabaseMetaDataWrapper.Schema> res2 = new ClosableIt.ResultSetDelegateIt<DatabaseMetaDataWrapper.Schema>(rs, null){

                @Override
                protected DatabaseMetaDataWrapper.Schema calcValue() throws SQLException {
                    return new DatabaseMetaDataWrapper.Schema(DbUtil.intern((String)this.myRs.getString("TABLE_SCHEM", 1)), catalog);
                }
            }.withErrorSink(meta.getErrorSink());
            g.release();
            ClosableIt<DatabaseMetaDataWrapper.Schema> closableIt = res2;
            return closableIt;
        }
        catch (SQLException e) {
            LOG.warn((Throwable)e);
            return ClosableIt.empty();
        }
    }

    private static RemoteResultSet getSchemas(String catalog, DatabaseMetaDataWrapper meta) {
        try {
            return (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> meta.getMetaData().getSchemas(catalog, "%"));
        }
        catch (SQLException ex) {
            try {
                String q = meta.getQuote();
                return (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> meta.getMetaData().getSchemas(q + catalog + q, "%"));
            }
            catch (SQLException ex2) {
                return null;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/SchemaLoader";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catalogs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "currentCatalog";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/SchemaLoader";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "pgCatalogs";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "jdbcCatalogs";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "schemas";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "oracleSchemas";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

