/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDatabaseDialect
extends DatabaseDialectEx {
    private final TypeHelper myTypeHelper;
    private final Casing myCasing;
    private volatile NamingService myNamingService;

    protected AbstractDatabaseDialect(TypeHelper typeHelper, Casing casing) {
        this.myTypeHelper = typeHelper;
        this.myCasing = casing;
    }

    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(0);
        }
        Casing casing = this.myCasing;
        if (casing == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(1);
        }
        return casing;
    }

    @NotNull
    protected NamingService getNamingService() {
        if (this.myNamingService == null) {
            this.myNamingService = NamingServices.getNamingService((Dbms)this.getDbms());
        }
        NamingService namingService = this.myNamingService;
        if (namingService == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(2);
        }
        return namingService;
    }

    protected SqlCodeStyleSettings getCodeStyle() {
        return SqlCodeStyles.getSqlSettings((Project)null, (Language)DbSqlUtil.getSqlDialect((Dbms)this.getDbms()));
    }

    protected boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(3);
        }
        return this.getNamingService().isPlain(identifier, true);
    }

    private boolean isQuotedIdentifier(@Nullable String identifier) {
        return !StringUtil.isEmpty((String)identifier) && this.getNamingService().isQuoted(identifier);
    }

    public boolean canUnquoteAlias(@NotNull String alias, boolean afterAS) {
        if (alias == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(4);
        }
        return StringUtil.equals((CharSequence)this.getNamingService().nameToScript(alias, false, null), (CharSequence)alias);
    }

    public String quoteIdentifier(String identifier, boolean force, boolean suppress, @NotNull Casing casing) {
        if (casing == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(5);
        }
        if (this.isQuotedIdentifier(identifier)) {
            return identifier;
        }
        if (StringUtil.isEmpty((String)identifier)) {
            return force ? this.getNamingService().enquoteName(identifier) : identifier;
        }
        force |= !this.isValidPlainIdentifier(identifier);
        if (!(force |= this.isReservedKeyword(identifier)) && !suppress && casing.quoted == Case.EXACT && casing.plain != Case.EXACT && casing.plain != Case.MIXED) {
            Case identifierCase = Case.forString((String)identifier);
            force = identifierCase == Case.MIXED || identifierCase != casing.plain;
        }
        return force ? this.getNamingService().enquoteName(identifier) : identifier;
    }

    private boolean isReservedKeyword(String name2) {
        return DbSqlUtil.getSqlDialect((Dbms)this.getDbms()).getReservedKeywords().contains(name2);
    }

    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(6);
        }
        if (view == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(7);
        }
        if (definition == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(8);
        }
        return DialectUtils.getCreateViewSQL((DdlBuilder)builder, (DasTable)view, (String)definition);
    }

    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(9);
        }
        if (view == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(10);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL((DdlBuilder)builder, (DasTable)view, null);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(11);
        }
        return ddlBuilder;
    }

    public boolean supportsSystemViewDefinition() {
        return this.supportsViewDefinition();
    }

    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(12);
        }
        if (procedure == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(13);
        }
        DdlBuilder ddlBuilder = DialectUtils.sqlDropProcedure((DdlBuilder)builder, (DasRoutine)procedure, (boolean)false);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(14);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder sqlInsertInto(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull List<String> columns, @NotNull List<Consumer<DdlBuilder>> values) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(15);
        }
        if (table == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(16);
        }
        if (columns == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(17);
        }
        if (values == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(18);
        }
        builder.keyword("INSERT").space().keyword("INTO").space().qualifiedRef((DasObject)table);
        if (!columns.isEmpty()) {
            builder.space().symbol("(");
            DialectUtils.appendStringList((DdlBuilder)builder, columns);
            builder.symbol(")");
        }
        if (values.isEmpty() && this.supportsInsertDefaultValues()) {
            builder.space().keyword("DEFAULT").space().keyword("VALUES");
        } else {
            builder.space().keyword("VALUES").space().symbol("(");
            DialectUtils.appendCommaSeparated((DdlBuilder)builder, values);
            builder.symbol(")");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(19);
        }
        return ddlBuilder;
    }

    public boolean supportsInsertDefaultValues() {
        return false;
    }

    public boolean supportsInsertDefaultIntoAutoVal() {
        return false;
    }

    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        String typeName;
        if (dataType == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(20);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                AbstractDatabaseDialect.$$$reportNull$$$0(21);
            }
            return string;
        }
        int jdbcType = dataType.jdbcType;
        int length = dataType.getLength();
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        if (jdbcType == 1111) {
            jdbcType = this.getJavaTypeForNativeType(dataType.getSpecification());
        }
        String string = (typeName = this.myTypeHelper.getTypeName(jdbcType, length, precision, scale)) != null ? typeName : JdbcUtil.getJdbcTypeName((DataType)dataType);
        if (string == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public String getTypeWithSubstitution(@NotNull String name2, int length, int precision, int scale) {
        if (name2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(23);
        }
        String string = this.myTypeHelper.getTypeWithSubstitution(name2, length, precision, scale);
        if (string == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(24);
        }
        return string;
    }

    public int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName) {
        if (nativeColumnTypeName == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(25);
        }
        return this.myTypeHelper.findJdbcType(nativeColumnTypeName);
    }

    public boolean supportsTableDefinition() {
        return false;
    }

    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element) {
        if (element == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(26);
        }
        throw new UnsupportedOperationException(DatabaseBundle.message((String)"ddl.error.table.definition", (Object[])new Object[]{this.getDisplayName()}));
    }

    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        if (table == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(27);
        }
        if (connection == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(28);
        }
        return "";
    }

    public boolean supportsTableInfo() {
        return false;
    }

    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(29);
        }
        if (connection == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(30);
        }
        Map<String, Object> map2 = Collections.emptyMap();
        if (map2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(31);
        }
        return map2;
    }

    public boolean supportsSearchPath() {
        return false;
    }

    public ObjectKind getSearchPathObjectKind() {
        return ObjectKind.SCHEMA;
    }

    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) throws SQLException {
        if (system == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(32);
        }
        if (connection == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(33);
        }
        return null;
    }

    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(34);
        }
        return null;
    }

    public boolean supportsInsertInto() {
        return true;
    }

    public String getBinaryLiteralString(byte @NotNull [] binaryData) {
        if (binaryData == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(35);
        }
        return "'" + DialectUtils.toHexString((byte[])binaryData) + "'";
    }

    @NotNull
    public String tryToLoadProcedureDefinition(@NotNull DasRoutine proc, @NotNull DatabaseConnection connection) throws Exception {
        if (proc == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(36);
        }
        if (connection == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(37);
        }
        return "";
    }

    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageBodyDefinition(@NotNull DasObject element) {
        if (element == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(38);
        }
        throw new UnsupportedOperationException("Package body definition is not supported");
    }

    public boolean supportsPackageDefinition() {
        return false;
    }

    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageDefinition(@NotNull DasObject element) {
        if (element == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(39);
        }
        throw new UnsupportedOperationException("Package definition is not supported");
    }

    public boolean supportsSequenceDefinition() {
        return false;
    }

    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSequenceDefinition(@NotNull DasObject element) {
        if (element == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(40);
        }
        throw new UnsupportedOperationException("Sequence definition is not supported");
    }

    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSynonymDefinition(@NotNull DasObject element) {
        if (element == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(41);
        }
        throw new UnsupportedOperationException("Synonym definition is not supported");
    }

    @NotNull
    public String tryToLoadSynonymDefinition(DasTable tableElement, DatabaseConnection connection) throws Exception {
        return "";
    }

    public boolean supportsSynonymDefinition() {
        return false;
    }

    public boolean supportsQualifiedAsteriskInCalls() {
        return false;
    }

    @NotNull
    public DdlBuilder sqlDefinePrototype(@NotNull DdlBuilder builder, @NotNull DasRoutine routine, boolean longMode, boolean withReturn) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(42);
        }
        if (routine == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(43);
        }
        JBIterable parameters2 = DasUtil.getParameters((DasRoutine)routine).filter(a -> a.getArgumentDirection() != ArgumentDirection.SELF);
        DasArgument returnArg = routine.getReturnArgument();
        builder.symbol("(");
        boolean first2 = true;
        for (DasArgument parameter : parameters2) {
            if (first2) {
                first2 = false;
            } else {
                builder.symbol(",").space();
            }
            this.sqlParameter(builder, parameter, longMode);
        }
        builder.symbol(")");
        if (returnArg != null && withReturn) {
            if (longMode) {
                builder.space().keyword("returns").space();
            } else {
                builder.plain(": ");
            }
            builder.type((DasTypedObject)returnArg);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(44);
        }
        return ddlBuilder;
    }

    protected void sqlParameter(@NotNull DdlBuilder builder, DasArgument parameter, boolean longMode) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(45);
        }
        DialectUtils.sqlParameter((DdlBuilder)builder, (DasArgument)parameter, (boolean)longMode, (int)0, (boolean)false);
    }

    public boolean supportsLoadDatabaseList() {
        return false;
    }

    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection) throws Exception {
        if (connection == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(46);
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(47);
        }
        return list;
    }

    public boolean hasRowId(@Nullable DasDataSource system) {
        return false;
    }

    @Nullable
    public String sqlResetSearchPath() {
        return null;
    }

    public boolean similarTo(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(48);
        }
        return dialect == this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 14: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 31: 
            case 44: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 14: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 31: 
            case 44: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 14: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 31: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/AbstractDatabaseDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 16: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeColumnTypeName";
                break;
            }
            case 26: 
            case 29: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 28: 
            case 30: 
            case 33: 
            case 37: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proc";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/AbstractDatabaseDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamingService";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropProcedure";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlInsertInto";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeWithSubstitution";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefinePrototype";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 14: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 31: 
            case 44: 
            case 47: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canUnquoteAlias";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "quoteIdentifier";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropProcedure";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sqlInsertInto";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWithSubstitution";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getJavaTypeForNativeType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "sqlTableDefinition";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadProcedureDefinition";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageBodyDefinition";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageDefinition";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceDefinition";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "sqlSynonymDefinition";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefinePrototype";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameter";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "similarTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 14: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 31: 
            case 44: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

