/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.ui.navigation.History;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.PairFunction;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import com.intellij.vcs.log.ui.filter.VcsLogFilterUiEx;
import com.intellij.vcs.log.ui.frame.MainFrame;
import com.intellij.vcs.log.ui.frame.VcsLogEditorDiffPreview;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogColumn;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogUiImpl
extends AbstractVcsLogUi
implements MainVcsLogUi {
    @NonNls
    private static final String HELP_ID = "reference.changesToolWindow.log";
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final MainFrame myMainFrame;
    @NotNull
    private final MyVcsLogUiPropertiesListener myPropertiesListener;
    @NotNull
    private final History myHistory;
    @NotNull
    private final EventDispatcher<MainVcsLogUi.VcsLogFilterListener> myFilterListenerDispatcher;

    public VcsLogUiImpl(@NotNull String id, @NotNull VcsLogData logData, @NotNull VcsLogColorManager manager, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VisiblePackRefresher refresher, @Nullable VcsLogFilterCollection initialFilters) {
        if (id == null) {
            VcsLogUiImpl.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            VcsLogUiImpl.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            VcsLogUiImpl.$$$reportNull$$$0(2);
        }
        if (uiProperties == null) {
            VcsLogUiImpl.$$$reportNull$$$0(3);
        }
        if (refresher == null) {
            VcsLogUiImpl.$$$reportNull$$$0(4);
        }
        super(id, logData, manager, refresher);
        this.myFilterListenerDispatcher = EventDispatcher.create(MainVcsLogUi.VcsLogFilterListener.class);
        this.myUiProperties = uiProperties;
        VcsLogFilterUiEx filterUi = this.createFilterUi((Consumer<VcsLogFilterCollection>)((Consumer)filters -> this.applyFiltersAndUpdateUi((VcsLogFilterCollection)filters)), initialFilters, this);
        this.myMainFrame = this.createMainFrame(logData, uiProperties, filterUi);
        for (VcsLogHighlighterFactory factory : (VcsLogHighlighterFactory[])LOG_HIGHLIGHTER_FACTORY_EP.getExtensions((AreaInstance)this.myProject)) {
            this.getTable().addHighlighter(factory.createHighlighter(logData, this));
        }
        this.myPropertiesListener = new MyVcsLogUiPropertiesListener();
        this.myUiProperties.addChangeListener(this.myPropertiesListener);
        this.myHistory = VcsLogUiUtil.installNavigationHistory(this);
        this.applyFiltersAndUpdateUi(this.myMainFrame.getFilterUi().getFilters());
    }

    @NotNull
    protected MainFrame createMainFrame(@NotNull VcsLogData logData, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogFilterUiEx filterUi) {
        boolean isDiffPreviewAsEditor;
        if (logData == null) {
            VcsLogUiImpl.$$$reportNull$$$0(5);
        }
        if (uiProperties == null) {
            VcsLogUiImpl.$$$reportNull$$$0(6);
        }
        if (filterUi == null) {
            VcsLogUiImpl.$$$reportNull$$$0(7);
        }
        MainFrame mainFrame = new MainFrame(logData, this, uiProperties, filterUi, !(isDiffPreviewAsEditor = VcsLogUiUtil.isDiffPreviewInEditor()));
        if (isDiffPreviewAsEditor) {
            new VcsLogEditorDiffPreview(this.myProject, this.myUiProperties, mainFrame);
        }
        MainFrame mainFrame2 = mainFrame;
        if (mainFrame2 == null) {
            VcsLogUiImpl.$$$reportNull$$$0(8);
        }
        return mainFrame2;
    }

    @NotNull
    protected VcsLogFilterUiEx createFilterUi(@NotNull Consumer<VcsLogFilterCollection> filterConsumer, @Nullable VcsLogFilterCollection filters, @NotNull Disposable parentDisposable) {
        if (filterConsumer == null) {
            VcsLogUiImpl.$$$reportNull$$$0(9);
        }
        if (parentDisposable == null) {
            VcsLogUiImpl.$$$reportNull$$$0(10);
        }
        return new VcsLogClassicFilterUi(this.myLogData, filterConsumer, this.myUiProperties, this.myColorManager, filters, parentDisposable);
    }

    @Override
    protected void onVisiblePackUpdated(boolean permGraphChanged) {
        this.myMainFrame.updateDataPack(this.myVisiblePack, permGraphChanged);
        this.myPropertiesListener.onShowLongEdgesChanged();
    }

    @NotNull
    public MainFrame getMainFrame() {
        MainFrame mainFrame = this.myMainFrame;
        if (mainFrame == null) {
            VcsLogUiImpl.$$$reportNull$$$0(11);
        }
        return mainFrame;
    }

    @Override
    protected <T> void handleCommitNotFound(final @NotNull T commitId, boolean commitExists, final @NotNull PairFunction<GraphTableModel, T, Integer> rowGetter) {
        if (commitId == null) {
            VcsLogUiImpl.$$$reportNull$$$0(12);
        }
        if (rowGetter == null) {
            VcsLogUiImpl.$$$reportNull$$$0(13);
        }
        if (this.getFilterUi().getFilters().isEmpty() || !commitExists) {
            super.handleCommitNotFound(commitId, commitExists, rowGetter);
            return;
        }
        ArrayList<NamedRunnable> runnables = new ArrayList<NamedRunnable>();
        runnables.add(new NamedRunnable(VcsLogBundle.message((String)"vcs.log.commit.does.not.match.view.and.reset.link", (Object[])new Object[0])){

            public void run() {
                VcsLogUiImpl.this.getFilterUi().setFilters(VcsLogFilterObject.EMPTY_COLLECTION);
                VcsLogUiImpl.this.invokeOnChange(() -> VcsLogUiImpl.this.jumpTo(commitId, rowGetter, (SettableFuture<? super Boolean>)SettableFuture.create(), false), (Condition<? super VcsLogDataPack>)((Condition)pack -> pack.getFilters().isEmpty()));
            }
        });
        final VcsProjectLog projectLog = VcsProjectLog.getInstance(this.myProject);
        if (projectLog.getDataManager() == this.myLogData) {
            runnables.add(new NamedRunnable(VcsLogBundle.message((String)"vcs.log.commit.does.not.match.view.in.tab.link", (Object[])new Object[0])){

                public void run() {
                    MainVcsLogUi ui2 = projectLog.openLogTab(VcsLogFilterObject.collection(new VcsLogFilter[0]));
                    if (ui2 != null) {
                        ui2.invokeOnChange(() -> ui2.jumpTo(commitId, rowGetter, (SettableFuture<? super Boolean>)SettableFuture.create(), false), (Condition<? super VcsLogDataPack>)((Condition)pack -> pack.getFilters().isEmpty()));
                    }
                }
            });
        }
        VcsBalloonProblemNotifier.showOverChangesView(this.myProject, VcsLogUiImpl.getCommitNotFoundMessage(commitId, true), MessageType.WARNING, runnables.toArray(new NamedRunnable[0]));
    }

    public boolean isHighlighterEnabled(@NotNull String id) {
        MainVcsLogUiProperties.VcsLogHighlighterProperty property;
        if (id == null) {
            VcsLogUiImpl.$$$reportNull$$$0(14);
        }
        return this.myUiProperties.exists(property = MainVcsLogUiProperties.VcsLogHighlighterProperty.get(id)) && this.myUiProperties.get(property) != false;
    }

    protected void applyFiltersAndUpdateUi(@NotNull VcsLogFilterCollection filters) {
        if (filters == null) {
            VcsLogUiImpl.$$$reportNull$$$0(15);
        }
        this.myRefresher.onFiltersChange(filters);
        ((MainVcsLogUi.VcsLogFilterListener)this.myFilterListenerDispatcher.getMulticaster()).onFiltersChanged();
        JComponent toolbar = this.myMainFrame.getToolbar();
        toolbar.revalidate();
        toolbar.repaint();
    }

    @Override
    public void addFilterListener(@NotNull MainVcsLogUi.VcsLogFilterListener listener2) {
        if (listener2 == null) {
            VcsLogUiImpl.$$$reportNull$$$0(16);
        }
        this.myFilterListenerDispatcher.addListener((EventListener)listener2);
    }

    @Override
    @NotNull
    public VcsLogGraphTable getTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myMainFrame.getGraphTable();
        if (vcsLogGraphTable == null) {
            VcsLogUiImpl.$$$reportNull$$$0(17);
        }
        return vcsLogGraphTable;
    }

    @Override
    @NotNull
    public JComponent getMainComponent() {
        MainFrame mainFrame = this.myMainFrame;
        if (mainFrame == null) {
            VcsLogUiImpl.$$$reportNull$$$0(18);
        }
        return mainFrame;
    }

    @Override
    @NotNull
    public VcsLogFilterUiEx getFilterUi() {
        VcsLogFilterUiEx vcsLogFilterUiEx = this.myMainFrame.getFilterUi();
        if (vcsLogFilterUiEx == null) {
            VcsLogUiImpl.$$$reportNull$$$0(19);
        }
        return vcsLogFilterUiEx;
    }

    @Override
    @NotNull
    public JComponent getToolbar() {
        JComponent jComponent = this.myMainFrame.getToolbar();
        if (jComponent == null) {
            VcsLogUiImpl.$$$reportNull$$$0(20);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public MainVcsLogUiProperties getProperties() {
        MainVcsLogUiProperties mainVcsLogUiProperties = this.myUiProperties;
        if (mainVcsLogUiProperties == null) {
            VcsLogUiImpl.$$$reportNull$$$0(21);
        }
        return mainVcsLogUiProperties;
    }

    @Override
    @Nullable
    public String getHelpId() {
        return HELP_ID;
    }

    @Override
    @Nullable
    public History getNavigationHistory() {
        return this.myHistory;
    }

    @Override
    public void dispose() {
        this.myUiProperties.removeChangeListener(this.myPropertiesListener);
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterUi";
                break;
            }
            case 8: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/VcsLogUiImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterConsumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowGetter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/VcsLogUiImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainFrame";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainFrame";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainComponent";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterUi";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createMainFrame";
                break;
            }
            case 8: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFilterUi";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitNotFound";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isHighlighterEnabled";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "applyFiltersAndUpdateUi";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addFilterListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyVcsLogUiPropertiesListener
    implements VcsLogUiProperties.PropertiesChangeListener {
        private MyVcsLogUiPropertiesListener() {
        }

        @Override
        public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
            if (property == null) {
                MyVcsLogUiPropertiesListener.$$$reportNull$$$0(0);
            }
            if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
                VcsLogUiImpl.this.myMainFrame.showDetails(VcsLogUiImpl.this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
            } else if (MainVcsLogUiProperties.SHOW_LONG_EDGES.equals(property)) {
                this.onShowLongEdgesChanged();
            } else if (CommonUiProperties.SHOW_ROOT_NAMES.equals(property)) {
                VcsLogUiImpl.this.getTable().rootColumnUpdated();
            } else if (MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW.equals(property)) {
                VcsLogUiImpl.this.getTable().setCompactReferencesView(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW));
            } else if (MainVcsLogUiProperties.SHOW_TAG_NAMES.equals(property)) {
                VcsLogUiImpl.this.getTable().setShowTagNames(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.SHOW_TAG_NAMES));
            } else if (MainVcsLogUiProperties.LABELS_LEFT_ALIGNED.equals(property)) {
                VcsLogUiImpl.this.getTable().setLabelsLeftAligned(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.LABELS_LEFT_ALIGNED));
            } else if (MainVcsLogUiProperties.BEK_SORT_TYPE.equals(property)) {
                VcsLogUiImpl.this.myRefresher.onSortTypeChange(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.BEK_SORT_TYPE));
            } else if (CommonUiProperties.COLUMN_ORDER.equals(property)) {
                VcsLogUiImpl.this.getTable().onColumnOrderSettingChanged();
            } else if (property instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty) {
                VcsLogUiImpl.this.getTable().repaint();
            } else if (property instanceof CommonUiProperties.TableColumnProperty) {
                VcsLogUiImpl.this.getTable().forceReLayout(((CommonUiProperties.TableColumnProperty)property).getColumn());
            } else if (property.equals(CommonUiProperties.PREFER_COMMIT_DATE) && VcsLogUiImpl.this.getTable().getTableColumn(VcsLogColumn.DATE) != null) {
                VcsLogUiImpl.this.getTable().repaint();
            }
        }

        private void onShowLongEdgesChanged() {
            VcsLogUiImpl.this.myVisiblePack.getVisibleGraph().getActionController().setLongEdgesHidden(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.SHOW_LONG_EDGES) == false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/ui/VcsLogUiImpl$MyVcsLogUiPropertiesListener", "onPropertyChanged"));
        }
    }
}

