/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.TreeDiffProvider;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesOnServerTracker;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteRevisionsStateCache
implements ChangesOnServerTracker {
    private static final long DISCRETE = 3600000L;
    private final Map<String, Pair<Boolean, VcsRoot>> myChanged;
    private final MultiMap<VcsRoot, String> myQueries;
    private final Map<VcsRoot, Long> myTs;
    private final Object myLock;
    private final ProjectLevelVcsManager myVcsManager;
    private final VcsConfiguration myVcsConfiguration;

    RemoteRevisionsStateCache(Project project) {
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myChanged = new HashMap<String, Pair<Boolean, VcsRoot>>();
        this.myQueries = new MultiMap();
        this.myTs = new HashMap<VcsRoot, Long>();
        this.myLock = new Object();
        this.myVcsConfiguration = VcsConfiguration.getInstance((Project)project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(Collection<String> paths) {
        Object object = this.myLock;
        synchronized (object) {
            for (String path2 : paths) {
                this.myChanged.remove(path2);
            }
        }
    }

    @Nullable
    private VirtualFile getRootForPath(String s) {
        return this.myVcsManager.getVcsRootFor(VcsUtil.getFilePath((String)s, (boolean)false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUpToDate(@NotNull Change change, @NotNull AbstractVcs vcs) {
        if (change == null) {
            RemoteRevisionsStateCache.$$$reportNull$$$0(0);
        }
        if (vcs == null) {
            RemoteRevisionsStateCache.$$$reportNull$$$0(1);
        }
        if (!RemoteRevisionsStateCache.isSupportedFor(vcs)) {
            return true;
        }
        List files = ChangesUtil.getIoFilesFromChanges(Collections.singletonList(change));
        Object object = this.myLock;
        synchronized (object) {
            for (File file : files) {
                String path2 = file.getAbsolutePath();
                Pair<Boolean, VcsRoot> data = this.myChanged.get(path2);
                if (data == null || !Boolean.TRUE.equals(data.getFirst())) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeUpdated(@NotNull String path2, @NotNull AbstractVcs vcs) {
        if (path2 == null) {
            RemoteRevisionsStateCache.$$$reportNull$$$0(2);
        }
        if (vcs == null) {
            RemoteRevisionsStateCache.$$$reportNull$$$0(3);
        }
        if (!RemoteRevisionsStateCache.isSupportedFor(vcs)) {
            return;
        }
        VirtualFile root = this.getRootForPath(path2);
        if (root == null) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myQueries.putValue((Object)new VcsRoot(vcs, root), (Object)path2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeRemoved(@NotNull String path2, @NotNull AbstractVcs vcs) {
        if (path2 == null) {
            RemoteRevisionsStateCache.$$$reportNull$$$0(4);
        }
        if (vcs == null) {
            RemoteRevisionsStateCache.$$$reportNull$$$0(5);
        }
        if (!RemoteRevisionsStateCache.isSupportedFor(vcs)) {
            return;
        }
        VirtualFile root = this.getRootForPath(path2);
        if (root == null) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            VcsRoot key = new VcsRoot(vcs, root);
            if (this.myQueries.containsKey((Object)key)) {
                this.myQueries.remove((Object)key, (Object)path2);
            }
            this.myChanged.remove(path2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void directoryMappingChanged() {
        Object object = this.myLock;
        synchronized (object) {
            this.myChanged.clear();
            this.myTs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateStep() {
        MultiMap dirty = new MultiMap();
        long oldPoint = System.currentTimeMillis() - (this.myVcsConfiguration.CHANGED_ON_SERVER_INTERVAL > 0 ? (long)this.myVcsConfiguration.CHANGED_ON_SERVER_INTERVAL * 60000L : 3600000L);
        Object object = this.myLock;
        synchronized (object) {
            for (Object root : this.myQueries.keySet()) {
                Collection object2 = this.myQueries.get(root);
                for (String s : object2) {
                    dirty.putValue(root, (Object)s);
                }
            }
            this.myQueries.clear();
            HashSet roots = new HashSet();
            for (Map.Entry entry : this.myTs.entrySet()) {
                Long ts;
                if (!dirty.get(entry.getKey()).isEmpty() || (ts = (Long)entry.getValue()) != null && oldPoint <= ts) continue;
                roots.add(entry.getKey());
            }
            for (Map.Entry entry : this.myChanged.entrySet()) {
                VcsRoot vcsRoot = (VcsRoot)((Pair)entry.getValue()).getSecond();
                if (dirty.get((Object)vcsRoot).isEmpty() && !roots.contains(vcsRoot)) continue;
                dirty.putValue((Object)vcsRoot, entry.getKey());
            }
        }
        if (dirty.isEmpty()) {
            return false;
        }
        HashMap<String, Pair> results = new HashMap<String, Pair>();
        for (VcsRoot vcsRoot : dirty.keySet()) {
            TreeDiffProvider treeDiffProvider;
            if (!vcsRoot.getVcs().isVcsBackgroundOperationsAllowed(vcsRoot.getPath()) || (treeDiffProvider = vcsRoot.getVcs().getTreeDiffProvider()) == null) continue;
            Collection paths = dirty.get((Object)vcsRoot);
            Collection remotelyChanged = treeDiffProvider.getRemotelyChanged(vcsRoot.getPath(), paths);
            for (String path2 : paths) {
                results.put(path2, new Pair((Object)remotelyChanged.contains(path2), (Object)vcsRoot));
            }
        }
        long curTime = System.currentTimeMillis();
        Object object2 = this.myLock;
        synchronized (object2) {
            this.myChanged.putAll(results);
            for (VcsRoot vcsRoot : dirty.keySet()) {
                this.myTs.put(vcsRoot, curTime);
            }
        }
        return true;
    }

    private static boolean isSupportedFor(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            RemoteRevisionsStateCache.$$$reportNull$$$0(6);
        }
        return vcs.getTreeDiffProvider() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/RemoteRevisionsStateCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isUpToDate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "changeUpdated";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "changeRemoved";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupportedFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

