/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CharsetEP
implements PatchEP {
    private static final Key<Map<String, String>> ourName = Key.create((String)"Charset");
    private final String myBaseDir;

    public CharsetEP(Project project) {
        this.myBaseDir = project.getBasePath();
    }

    @NotNull
    public String getName() {
        return "com.intellij.openapi.diff.impl.patch.CharsetEP";
    }

    public CharSequence provideContent(@NotNull String path2, CommitContext commitContext) {
        if (path2 == null) {
            CharsetEP.$$$reportNull$$$0(0);
        }
        File file = new File(this.myBaseDir, path2);
        VirtualFile vf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        if (vf == null) {
            return null;
        }
        String charsetName = vf.getCharset().name();
        return charsetName;
    }

    public void consumeContent(@NotNull String path2, @NotNull CharSequence content2, CommitContext commitContext) {
        if (path2 == null) {
            CharsetEP.$$$reportNull$$$0(1);
        }
        if (content2 == null) {
            CharsetEP.$$$reportNull$$$0(2);
        }
    }

    public void consumeContentBeforePatchApplied(@NotNull String path2, @NotNull CharSequence content2, CommitContext commitContext) {
        if (path2 == null) {
            CharsetEP.$$$reportNull$$$0(3);
        }
        if (content2 == null) {
            CharsetEP.$$$reportNull$$$0(4);
        }
        if (commitContext == null) {
            return;
        }
        HashMap<String, String> map2 = (HashMap<String, String>)commitContext.getUserData(ourName);
        if (map2 == null) {
            map2 = new HashMap<String, String>();
            commitContext.putUserData(ourName, map2);
        }
        File file = new File(this.myBaseDir, path2);
        map2.put(FilePathsHelper.convertPath((String)file.getPath()), content2.toString());
    }

    public static String getCharset(String path2, CommitContext commitContext) {
        if (commitContext == null) {
            return null;
        }
        Map userData = (Map)commitContext.getUserData(ourName);
        return userData == null ? null : (String)userData.get(FilePathsHelper.convertPath((String)path2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diff/impl/patch/CharsetEP";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "provideContent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "consumeContent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "consumeContentBeforePatchApplied";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

