/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run.test;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.BooleanFunction;
import com.intellij.util.config.AbstractProperty;
import com.intellij.ws.http.request.run.HttpClientRequestProcessHandler;
import com.intellij.ws.http.request.run.console.HttpRequestErrorFileFilter;
import com.intellij.ws.http.request.run.console.HttpRequestErrorFixFilter;
import com.intellij.ws.http.request.run.console.HttpResponseConsole;
import com.intellij.ws.http.request.run.console.HttpResponseFileFilter;
import com.intellij.ws.http.request.run.console.HttpResponseOutputAdapter;
import com.intellij.ws.http.request.run.console.HttpResponsePresentation;
import com.intellij.ws.http.request.run.test.HttpClientTestUtil;
import com.intellij.ws.rest.client.RestClientBundle;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpMultiResponseConsole
implements HttpResponseConsole {
    private static final String RESPONSE_GROUP_NAME = "Response";
    private static final BooleanFunction<FileType> ALWAYS_TRUE = type -> true;
    private final Project myProject;
    private final SMTRunnerConsoleView myConsole;
    private final HttpResponseOutputAdapter myResponsePrinter;
    private final Map<String, HttpResponsePresentation> myRequestResults;

    public HttpMultiResponseConsole(@NotNull Project project, @NotNull SMTRunnerConsoleProperties properties, @NotNull HttpClientRequestProcessHandler handler) {
        if (project == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(1);
        }
        if (handler == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(2);
        }
        this.myRequestResults = new HashMap<String, HttpResponsePresentation>();
        this.myProject = project;
        TestConsoleProperties.HIDE_PASSED_TESTS.set((AbstractProperty.AbstractPropertyContainer)properties, (Object)false);
        this.myConsole = SMTestRunnerConnectionUtil.createConsole((SMTRunnerConsoleProperties)properties);
        this.myConsole.attachToProcess((ProcessHandler)handler);
        this.myConsole.addMessageFilter((Filter)new HttpResponseFileFilter(project));
        this.myConsole.addMessageFilter((Filter)HttpRequestErrorFileFilter.getInstance(project));
        this.myConsole.addMessageFilter((Filter)new HttpRequestErrorFixFilter());
        this.myConsole.getResultsViewer().getTestsRootNode().setPresentation(RestClientBundle.message("rest.client.request.run.test.console.root", new Object[0]));
        this.myResponsePrinter = HttpResponseOutputAdapter.createTest(handler);
        this.myResponsePrinter.print("\n");
    }

    @Override
    public void onRequestStart(@NotNull String id, int size) {
        if (id == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(3);
        }
        HttpClientTestUtil.printSuiteStart(this.myResponsePrinter, id, size);
    }

    @Override
    public void onRequestEnd(@NotNull String id) {
        if (id == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(4);
        }
        HttpClientTestUtil.printSuiteEnd(this.myResponsePrinter, id);
    }

    @Override
    public void setResponse(@NotNull String id, @NotNull HttpResponsePresentation response, @NotNull FileType fileType) {
        if (id == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(5);
        }
        if (response == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(6);
        }
        if (fileType == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(7);
        }
        this.myRequestResults.put(id, response);
        this.myResponsePrinter.printStart(HttpMultiResponseConsole.toRequestTestName(id));
    }

    @Override
    public void setErrorResponse(@Nullable String id, @NotNull HttpResponsePresentation response) {
        if (response == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(8);
        }
        if (StringUtil.isNotEmpty((String)id)) {
            this.setResponse(id, response, (FileType)PlainTextFileType.INSTANCE);
        } else {
            response.print(this.myProject, this.myResponsePrinter, null, (FileType)PlainTextFileType.INSTANCE, ALWAYS_TRUE);
        }
    }

    @Override
    public void onResponseFileCreated(@NotNull String id, @Nullable String pathToFile) {
        if (id == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(9);
        }
        if (this.myRequestResults.containsKey(id)) {
            HttpResponsePresentation presentation = this.myRequestResults.remove(id);
            presentation.print(this.myProject, this.myResponsePrinter, pathToFile, (FileType)PlainTextFileType.INSTANCE, ALWAYS_TRUE);
            this.myResponsePrinter.printEnd(HttpMultiResponseConsole.toRequestTestName(id), 0L);
        }
    }

    private static String toRequestTestName(@NotNull String url) {
        if (url == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(10);
        }
        return StringUtil.notNullize((String)url) + "." + RESPONSE_GROUP_NAME;
    }

    @Override
    @NotNull
    public ConsoleView getConsole() {
        SMTRunnerConsoleView sMTRunnerConsoleView = this.myConsole;
        if (sMTRunnerConsoleView == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(11);
        }
        return sMTRunnerConsoleView;
    }

    @Override
    @Nullable
    public HttpResponseOutputAdapter getResponseHandlerPrinter() {
        return this.myResponsePrinter;
    }

    @Override
    @Nullable
    public HttpResponseOutputAdapter getResponseHandlerTestPrinter() {
        return this.myResponsePrinter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/test/HttpMultiResponseConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/test/HttpMultiResponseConsole";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onRequestStart";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onRequestEnd";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setResponse";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setErrorResponse";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "onResponseFileCreated";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "toRequestTestName";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

