/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.ws.http.request.completion.HttpVariableCompletionProvider;
import org.jetbrains.annotations.NotNull;

public class HttpVariableInMessageBodyCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        PsiElement element;
        if (parameters == null) {
            HttpVariableInMessageBodyCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            HttpVariableInMessageBodyCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            HttpVariableInMessageBodyCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((element = parameters.getOriginalPosition()) != null) {
            int variableNameOffset;
            String elementText = element.getText();
            if (HttpVariableInMessageBodyCompletionProvider.afterOpeningBraces(elementText, variableNameOffset = HttpVariableInMessageBodyCompletionProvider.getRelativeVariableNameOffset(elementText, parameters.getOffset() - element.getTextOffset()))) {
                HttpVariableCompletionProvider.getProvider(HttpVariableCompletionProvider.ProviderType.ENVIRONMENT_VARIABLE).addCompletions(parameters, result, element, variableNameOffset);
            } else if (HttpVariableInMessageBodyCompletionProvider.afterDynamicSign(elementText, variableNameOffset)) {
                HttpVariableCompletionProvider.getProvider(HttpVariableCompletionProvider.ProviderType.DYNAMIC_VARIABLE).addCompletions(parameters, result, element, variableNameOffset);
            }
        }
    }

    private static boolean afterOpeningBraces(String elementText, int variableNameOffset) {
        int offset = StringUtil.skipWhitespaceBackward((CharSequence)elementText, (int)variableNameOffset);
        return offset > 1 && elementText.charAt(offset - 1) == '{' && elementText.charAt(offset - 2) == '{';
    }

    private static boolean afterDynamicSign(@NotNull String elementText, int variableNameOffset) {
        int offset;
        if (elementText == null) {
            HttpVariableInMessageBodyCompletionProvider.$$$reportNull$$$0(3);
        }
        return (offset = StringUtil.skipWhitespaceBackward((CharSequence)elementText, (int)variableNameOffset)) > 2 && elementText.charAt(offset - 1) == '$' && HttpVariableInMessageBodyCompletionProvider.afterOpeningBraces(elementText, offset - 1);
    }

    private static int getRelativeVariableNameOffset(String elementText, int relativeCaretOffset) {
        while (relativeCaretOffset > 0 && HttpVariableInMessageBodyCompletionProvider.isVariableIdentifierPart(elementText.charAt(relativeCaretOffset - 1))) {
            --relativeCaretOffset;
        }
        return relativeCaretOffset;
    }

    private static boolean isVariableIdentifierPart(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/http/request/completion/HttpVariableInMessageBodyCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "afterDynamicSign";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

