/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtil;
import com.intellij.ws.http.request.HttpClientDataKeys;
import com.intellij.ws.http.request.HttpRequestCollectionProvider;
import com.intellij.ws.http.request.HttpRequestFileType;
import com.intellij.ws.rest.client.RestClientBundle;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestOpenCollectionAction
extends AnAction {
    public HttpRequestOpenCollectionAction() {
        super(RestClientBundle.message("action.HTTPClient.OpenCollection.text", new Object[0]));
        this.getTemplatePresentation().setDescription(RestClientBundle.messagePointer("http.request.open.requests.collection.action.description", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent event2) {
        Project project;
        if (event2 == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(0);
        }
        if ((project = event2.getProject()) == null || project.isDefault()) {
            this.showErrorBalloon(project, event2, RestClientBundle.message("http.request.open.requests.collection.action.failed.default.project", new Object[0]));
            return;
        }
        boolean success = this.showOpenFilePopup(project, event2);
        if (!success) {
            this.showErrorBalloon(project, event2, RestClientBundle.message("http.request.open.requests.collection.action.failed.no.file", new Object[0]));
        }
    }

    public boolean showOpenFilePopup(final @NotNull Project project, @NotNull AnActionEvent event2) {
        HyperlinkLabel hyperlinkLabel;
        VirtualFile root;
        if (project == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(1);
        }
        if (event2 == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(2);
        }
        if ((root = (VirtualFile)HttpRequestCollectionProvider.COLLECTION.getValue()) == null) {
            return false;
        }
        final Map files = (Map)((StreamEx)StreamEx.of((Object[])root.getChildren()).filter(file -> FileUtilRt.extensionEquals((String)file.getPath(), (String)HttpRequestFileType.INSTANCE.getDefaultExtension()))).map(file -> file.getName()).collect(Collectors.toMap(name -> HttpRequestOpenCollectionAction.getCollectionName(name), name -> name));
        if (files.isEmpty()) {
            return false;
        }
        String title = RestClientBundle.message("action.HTTPClient.OpenCollection.text", new Object[0]);
        Object[] actions = ArrayUtil.toStringArray(files.keySet());
        Arrays.sort(actions);
        ListPopup requestsCollectionPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(title, (String[])actions){

            public PopupStep<?> onChosen(String action, boolean finalChoice) {
                return this.doFinalStep(() -> {
                    PsiFile file;
                    VirtualFile selectedFile;
                    String filename = (String)files.get(action);
                    if (filename != null && (selectedFile = this.findSelectedFile(filename)) != null && (file = PsiManager.getInstance((Project)project).findFile(selectedFile)) != null) {
                        FileEditorManager.getInstance((Project)project).openFile(selectedFile, true);
                    }
                });
            }

            @Nullable
            private VirtualFile findSelectedFile(@NotNull String name) {
                VirtualFile root;
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((root = (VirtualFile)HttpRequestCollectionProvider.COLLECTION.getValue()) != null) {
                    return ((StreamEx)StreamEx.of((Object[])root.getChildren()).filter(file -> FileUtil.namesEqual((String)file.getName(), (String)name))).findAny().orElse(null);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ws/actions/HttpRequestOpenCollectionAction$1", "findSelectedFile"));
            }
        });
        if ("HttpClient.NotificationPanel".equals(event2.getPlace()) && (hyperlinkLabel = (HyperlinkLabel)event2.getDataContext().getData(HttpClientDataKeys.EXAMPLES_TOOLBAR_HYPERLINK_LABEL)) != null) {
            requestsCollectionPopup.showUnderneathOf((Component)hyperlinkLabel);
        } else {
            requestsCollectionPopup.show(HttpRequestOpenCollectionAction.findBestPopupLocation(event2));
        }
        return true;
    }

    @NotNull
    public static String getCollectionName(@NotNull String fileName) {
        if (fileName == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(3);
        }
        String name = FileUtil.getNameWithoutExtension((String)fileName);
        String presentableName = RestClientBundle.messageOrNull("http.request.collection." + name.replace("-", "."), new Object[0]);
        if (StringUtil.isNotEmpty((String)presentableName)) {
            String string = presentableName;
            if (string == null) {
                HttpRequestOpenCollectionAction.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = String.join((CharSequence)" ", StringUtil.wordsToBeginFromUpperCase((String)name).split("-"));
        if (string == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    protected void showErrorBalloon(@Nullable Project project, @NotNull AnActionEvent event2, @NotNull String message) {
        if (event2 == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(6);
        }
        if (message == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(7);
        }
        BalloonBuilder builder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.ERROR, null).setFadeoutTime(2000L);
        if (project != null) {
            builder.setDisposable((Disposable)project);
        }
        builder.createBalloon().show(HttpRequestOpenCollectionAction.findBestPopupLocation(event2), Balloon.Position.below);
    }

    @NotNull
    private static RelativePoint findBestPopupLocation(@NotNull AnActionEvent event2) {
        if (event2 == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(8);
        }
        InputEvent inputEvent = event2.getInputEvent();
        if ("ContextToolbar".equals(event2.getPlace()) && inputEvent instanceof MouseEvent) {
            return new RelativePoint((MouseEvent)inputEvent);
        }
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(event2.getDataContext());
        if (relativePoint == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(9);
        }
        return relativePoint;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/actions/HttpRequestOpenCollectionAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/actions/HttpRequestOpenCollectionAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollectionName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findBestPopupLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showOpenFilePopup";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionName";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showErrorBalloon";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findBestPopupLocation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

