/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.editor;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ThrowableRunnable;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.JupyterCustomizer;
import org.jetbrains.plugins.notebooks.jupyter.JupyterFileType;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterEditorActionsKt;
import org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterDebugCellIdManager;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterCellUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterFileEditorProvider;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterCell;
import org.jetbrains.plugins.notebooks.jupyter.variables.inline.JupyterInlineService;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000eH&J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\rH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000eH\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterFileEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "createJupyterFileEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFile;", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "initDebuggerListener", "", "editor", "notebookSourceFile", "moveCaret", "textEditor", "notebookFileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "readState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "sourceElement", "Lorg/jdom/Element;", "updateBreakpointsUI", "intellij.python.jupyter"})
public abstract class JupyterFileEditorProvider
implements FileEditorProvider,
DumbAware {
    private final VirtualFileSystem notebookFileSystem() {
        VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem("notebook");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileSystem, (String)"VirtualFileManager.getIn\u2026System(NOTEBOOK_PROTOCOL)");
        return virtualFileSystem;
    }

    @NotNull
    public abstract TextEditor createJupyterFileEditor(@NotNull Project var1, @NotNull NotebookVirtualFile var2);

    @NotNull
    public final FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        VirtualFile virtualFile2 = this.notebookFileSystem().findFileByPath(file2.getPath());
        if (virtualFile2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFile");
        }
        NotebookVirtualFile notebookSourceFile = (NotebookVirtualFile)virtualFile2;
        TextEditor editor2 = this.createJupyterFileEditor(project, notebookSourceFile);
        this.moveCaret(project, editor2);
        JupyterCustomizer jupyterCustomizer = JupyterCustomizer.Companion.getInstance();
        Editor editor3 = editor2.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"editor.editor");
        jupyterCustomizer.onEditorCreated(editor3, notebookSourceFile.getNotebook());
        file2.putUserData(JupyterCellUtilKt.getJUPYTER_EDITOR_KEY(), (Object)editor2.getEditor());
        file2.putUserData(JupyterCellUtilKt.getNOTEBOOK_VIRTUAL_FILE_KEY(), (Object)notebookSourceFile);
        this.initDebuggerListener(project, editor2, notebookSourceFile);
        return (FileEditor)editor2;
    }

    private final void moveCaret(Project project, TextEditor textEditor) {
        ApplicationManager.getApplication().invokeLater(new Runnable(project, textEditor){
            final /* synthetic */ Project $project;
            final /* synthetic */ TextEditor $textEditor;

            public final void run() {
                ReadAction.run((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<E>(this){
                    final /* synthetic */ moveCaret.1 this$0;

                    public final void run() {
                        block2: {
                            List<JupyterCell> list = JupyterCellUtilKt.getCells(this.this$0.$project, this.this$0.$textEditor);
                            if (list == null) {
                                return;
                            }
                            List<JupyterCell> cells2 = list;
                            JupyterCell jupyterCell = (JupyterCell)CollectionsKt.getOrNull(cells2, (int)0);
                            if (jupyterCell == null) break block2;
                            JupyterCell jupyterCell2 = jupyterCell;
                            boolean bl = false;
                            boolean bl2 = false;
                            JupyterCell it = jupyterCell2;
                            boolean bl3 = false;
                            Integer n = JupyterCellUtilKt.getCellSelectionOffset(it);
                            if (n == null) {
                                return;
                            }
                            int offset = n;
                            Editor editor2 = this.this$0.$textEditor.getEditor();
                            Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"textEditor.editor");
                            CaretModel caretModel = editor2.getCaretModel();
                            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"textEditor.editor.caretModel");
                            caretModel.getPrimaryCaret().moveToOffset(offset);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
            }
            {
                this.$project = project;
                this.$textEditor = textEditor;
            }
        });
    }

    private final void initDebuggerListener(Project project, TextEditor editor2, NotebookVirtualFile notebookSourceFile) {
        this.updateBreakpointsUI(project, notebookSourceFile);
        JupyterInlineService jupyterInlineService = JupyterInlineService.Companion.getInstance(project);
        Editor editor3 = editor2.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"editor.editor");
        jupyterInlineService.updateEditor(notebookSourceFile, editor3);
        Editor editor4 = editor2.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor4, (String)"editor.editor");
        editor4.getDocument().addDocumentListener(new DocumentListener(project, notebookSourceFile){
            final /* synthetic */ Project $project;
            final /* synthetic */ NotebookVirtualFile $notebookSourceFile;

            public void documentChanged(@NotNull DocumentEvent event2) {
                Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
                if (JupyterEditorActionsKt.isUnderDebugger(this.$project, this.$notebookSourceFile)) {
                    JupyterDebugCellIdManager.updatePositions$default(JupyterDebugCellIdManager.Companion.getInstance(this.$project), this.$project, this.$notebookSourceFile, null, 4, null);
                }
            }
            {
                this.$project = $captured_local_variable$0;
                this.$notebookSourceFile = $captured_local_variable$1;
            }
        });
    }

    private final void updateBreakpointsUI(Project project, NotebookVirtualFile notebookSourceFile) {
        Document parentDocument;
        XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebuggerManager, (String)"XDebuggerManager.getInstance(project)");
        XBreakpointManager xBreakpointManager = xDebuggerManager.getBreakpointManager();
        if (xBreakpointManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl");
        }
        XBreakpointManagerImpl breakpointManager = (XBreakpointManagerImpl)xBreakpointManager;
        XLineBreakpointManager lineBreakpointManager = breakpointManager.getLineBreakpointManager();
        Document document = parentDocument = FileDocumentManagerImpl.getInstance().getDocument(notebookSourceFile.getOriginFile());
        if (document != null) {
            Document document2 = document;
            boolean bl = false;
            boolean bl2 = false;
            Document $this$run = document2;
            boolean bl3 = false;
            Collection collection = lineBreakpointManager.getDocumentBreakpoints(parentDocument);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"lineBreakpointManager.ge\u2026eakpoints(parentDocument)");
            Collection originalBreakpoints = collection;
            Iterator iterator = originalBreakpoints.iterator();
            while (iterator.hasNext()) {
                XLineBreakpointImpl breakpoint;
                XLineBreakpointImpl xLineBreakpointImpl = breakpoint = (XLineBreakpointImpl)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)xLineBreakpointImpl, (String)"breakpoint");
                XLineBreakpointType xLineBreakpointType = xLineBreakpointImpl.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)xLineBreakpointType, (String)"breakpoint.type");
                if (!Intrinsics.areEqual((Object)xLineBreakpointType.getId(), (Object)"jupyter-line")) continue;
                RangeHighlighter rangeHighlighter = breakpoint.getHighlighter();
                if (rangeHighlighter != null) {
                    rangeHighlighter.dispose();
                }
                breakpoint.updateUI();
            }
        }
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return file2.getFileType() == JupyterFileType.INSTANCE;
    }

    @NotNull
    public String getEditorTypeId() {
        return "jupyter-editor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)sourceElement, (String)"sourceElement");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return (FileEditorState)new TextEditorState();
    }
}

