/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.JupyterLanguage;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterLangUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterTemplateTypes;
import org.jetbrains.plugins.notebooks.jupyter.python.JupyterPyDialect;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0006H\u0014J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/JupyterFileViewProvider;", "Lcom/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider;", "Lcom/intellij/psi/templateLanguages/TemplateLanguageFileViewProvider;", "manager", "Lcom/intellij/psi/PsiManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "eventSystemEnabled", "", "(Lcom/intellij/psi/PsiManager;Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "cloneInner", "fileCopy", "createFile", "Lcom/intellij/psi/PsiFile;", "lang", "Lcom/intellij/lang/Language;", "getBaseLanguage", "getLanguages", "", "getTemplateDataLanguage", "intellij.python.jupyter"})
public class JupyterFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    @NotNull
    private final VirtualFile file;

    @NotNull
    public Language getTemplateDataLanguage() {
        return JupyterPyDialect.INSTANCE;
    }

    @NotNull
    public Set<Language> getLanguages() {
        return SetsKt.hashSetOf((Object[])new Language[]{this.getBaseLanguage(), this.getTemplateDataLanguage(), JupyterLangUtilKt.getMarkdownLanguage()});
    }

    @NotNull
    public Language getBaseLanguage() {
        return JupyterLanguage.INSTANCE;
    }

    @NotNull
    protected JupyterFileViewProvider cloneInner(@NotNull VirtualFile fileCopy) {
        Intrinsics.checkParameterIsNotNull((Object)fileCopy, (String)"fileCopy");
        PsiManagerEx psiManagerEx = this.getManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManagerEx, (String)"manager");
        return new JupyterFileViewProvider((PsiManager)psiManagerEx, fileCopy, false);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        PsiFile psiFile;
        Intrinsics.checkParameterIsNotNull((Object)lang, (String)"lang");
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (lang == JupyterLanguage.INSTANCE) {
            psiFile = parserDefinition.createFile((FileViewProvider)this);
        } else if (lang == JupyterPyDialect.INSTANCE) {
            PsiFile psiFile2 = parserDefinition.createFile((FileViewProvider)this);
            if (psiFile2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
            }
            PsiFileImpl psiFileImpl = (PsiFileImpl)psiFile2;
            boolean bl = false;
            boolean bl2 = false;
            PsiFileImpl $this$apply = psiFileImpl;
            boolean bl3 = false;
            $this$apply.setContentElementType((IElementType)JupyterTemplateTypes.PYTHON_TEMPLATE);
            psiFile = (PsiFile)psiFileImpl;
        } else if (lang == JupyterLangUtilKt.getMarkdownLanguage()) {
            PsiFile psiFile3 = parserDefinition.createFile((FileViewProvider)this);
            if (psiFile3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
            }
            PsiFileImpl psiFileImpl = (PsiFileImpl)psiFile3;
            boolean bl = false;
            boolean bl4 = false;
            PsiFileImpl $this$apply = psiFileImpl;
            boolean bl5 = false;
            $this$apply.setContentElementType((IElementType)JupyterTemplateTypes.MARKDOWN_TEMPLATE);
            psiFile = (PsiFile)psiFileImpl;
        } else {
            psiFile = null;
        }
        return psiFile;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    public JupyterFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file2, boolean eventSystemEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        super(manager, file2, eventSystemEnabled);
        this.file = file2;
    }
}

