/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.validation.PyAnnotator;

public class ReturnAnnotator
extends PyAnnotator {
    @Override
    public void visitPyReturnStatement(PyReturnStatement node) {
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class, (boolean)false, (Class[])new Class[]{PyClass.class});
        if (function == null) {
            this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyBundle.message("ANN.return.outside.of.function", new Object[0])).create();
        }
        if (function != null && node.getExpression() != null && function.isGenerator() && function.isAsync() && function.isAsyncAllowed()) {
            this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyBundle.message("ANN.non.empty.return.inside.asynchronous.generator", new Object[0])).create();
        }
    }

    @Override
    public void visitPyYieldExpression(PyYieldExpression node) {
        PyFunction function;
        ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)node);
        if (!(owner instanceof PyFunction) && !(owner instanceof PyLambdaExpression)) {
            this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyBundle.message("ANN.yield.outside.of.function", new Object[0])).create();
        }
        if (node.isDelegating() && owner instanceof PyFunction && (function = (PyFunction)owner).isAsync() && function.isAsyncAllowed()) {
            this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyBundle.message("ANN.python.does.not.support.yield.from.inside.async.functions", new Object[0])).create();
        }
    }
}

