/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.templateLanguages;

import com.intellij.facet.ui.ValidationResult;
import com.intellij.lang.Language;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.templateLanguages.TemplatesService;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTemplatesUtil {
    private PyTemplatesUtil() {
    }

    @Nullable
    public static ValidationResult checkInstalled(@Nullable Sdk sdk, @Nullable String language, @NotNull String prefix) {
        if (prefix == null) {
            PyTemplatesUtil.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            return ValidationResult.OK;
        }
        String templateBinding = null;
        if (language != null) {
            String postfix = StringUtil.toLowerCase((String)language);
            if (language.equals("Jinja2") && !"pyramid_".equals(prefix)) {
                postfix = "jinja";
            }
            templateBinding = prefix + postfix;
        }
        List<PyPackage> packages = PyPackageUtil.refreshAndGetPackagesModally(sdk);
        for (String name : new String[]{templateBinding, language}) {
            if (name == null || !TemplatesService.ALL_TEMPLATE_BINDINGS.contains(name) || PyPsiPackageUtil.findPackage(packages, name) != null) continue;
            return new ValidationResult(PyBundle.message("python.package.installation.notification.message", name));
        }
        return null;
    }

    @Nullable
    public static Language getTemplateDataLanguage(@Nullable PsiElement psiElement, @Nullable Class<? extends TemplateLanguageFileViewProvider> expectedProvider) {
        if (psiElement == null) {
            return null;
        }
        FileViewProvider provider = psiElement.getContainingFile().getViewProvider();
        if (provider instanceof TemplateLanguageFileViewProvider && (expectedProvider == null || expectedProvider.isInstance(provider))) {
            return ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage();
        }
        return psiElement.getLanguage();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/python/templateLanguages/PyTemplatesUtil", "checkInstalled"));
    }
}

