/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.templateLanguages;

import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.jetbrains.python.templateLanguages.PythonTemplateLanguage;
import com.jetbrains.python.templateLanguages.TemplatesService;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTemplatesAutoConfiguration
implements DirectoryProjectConfigurator {
    private static final String TEMPLATES = "templates";

    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean newProject) {
        Module[] modules;
        Module module;
        if (project == null) {
            PyTemplatesAutoConfiguration.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            PyTemplatesAutoConfiguration.$$$reportNull$$$0(1);
        }
        if (moduleRef == null) {
            PyTemplatesAutoConfiguration.$$$reportNull$$$0(2);
        }
        if ((module = (Module)moduleRef.get()) == null && (modules = ModuleManager.getInstance((Project)project).getModules()).length == 1) {
            module = modules[0];
        }
        if (module == null) {
            return;
        }
        PyTemplatesAutoConfiguration.configureTemplateFolders(module);
        TemplatesService templatesService = TemplatesService.getInstance(module);
        Language selectedTemplateLanguage = templatesService.getSelectedTemplateLanguage();
        if (selectedTemplateLanguage != null) {
            return;
        }
        PythonTemplateLanguage language = PyTemplatesAutoConfiguration.detectTemplateLanguage(templatesService);
        if (language != null) {
            templatesService.setTemplateLanguage(language.getTemplateLanguageName());
        }
    }

    @Nullable
    private static PythonTemplateLanguage detectTemplateLanguage(@NotNull TemplatesService templatesService) {
        if (templatesService == null) {
            PyTemplatesAutoConfiguration.$$$reportNull$$$0(3);
        }
        for (VirtualFile folder : templatesService.getTemplateFolders()) {
            PythonTemplateLanguage language = PyTemplatesAutoConfiguration.findTemplateInFolder(templatesService.getKnownTemplateLanguages(), folder);
            if (language == null) continue;
            return language;
        }
        return null;
    }

    private static void configureTemplateFolders(@NotNull Module module) {
        TemplatesService templatesService;
        if (module == null) {
            PyTemplatesAutoConfiguration.$$$reportNull$$$0(4);
        }
        if (!(templatesService = TemplatesService.getInstance(module)).getTemplateFolders().isEmpty()) {
            return;
        }
        HashSet<VirtualFile> templateFolders = new HashSet<VirtualFile>();
        block0: for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            for (VirtualFile possibleTemplatesFolder : VfsUtil.collectChildrenRecursively((VirtualFile)contentRoot)) {
                if (!possibleTemplatesFolder.isDirectory() || !possibleTemplatesFolder.getName().endsWith(TEMPLATES)) continue;
                templateFolders.add(possibleTemplatesFolder);
                continue block0;
            }
        }
        templatesService.setTemplateFolders(templateFolders.toArray(VirtualFile.EMPTY_ARRAY));
    }

    @Nullable
    private static PythonTemplateLanguage findTemplateInFolder(@NotNull Iterable<PythonTemplateLanguage> languages, @NotNull VirtualFile folder) {
        if (languages == null) {
            PyTemplatesAutoConfiguration.$$$reportNull$$$0(5);
        }
        if (folder == null) {
            PyTemplatesAutoConfiguration.$$$reportNull$$$0(6);
        }
        for (VirtualFile file2 : folder.getChildren()) {
            String fileContent;
            if (file2.isDirectory() || !file2.getName().endsWith(".html")) continue;
            try {
                fileContent = file2.getCharset().decode(ByteBuffer.wrap(file2.contentsToByteArray())).toString();
            }
            catch (IOException ignored) {
                continue;
            }
            for (PythonTemplateLanguage templateLanguage : languages) {
                if (!templateLanguage.isFileLeadsToLanguageSelection(fileContent)) continue;
                return templateLanguage;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templatesService";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languages";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/templateLanguages/PyTemplatesAutoConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "detectTemplateLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "configureTemplateFolders";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findTemplateInFolder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

