/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.pipenv;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.pipenv.PipEnvPipFileWatcherComponent;
import com.jetbrains.python.sdk.pipenv.PipenvKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/jetbrains/python/sdk/pipenv/PipEnvPipFileWatcherComponent;", "Lcom/intellij/openapi/components/ProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectOpened", "", "intellij.python.community.impl"})
public final class PipEnvPipFileWatcherComponent
implements ProjectComponent {
    @NotNull
    private final Project project;

    public void projectOpened() {
        EditorFactoryListener editorFactoryListener2 = new EditorFactoryListener(this){
            private final Key<DocumentListener> changeListenerKey;
            private final Key<Boolean> notificationActive;
            final /* synthetic */ PipEnvPipFileWatcherComponent this$0;

            public void editorCreated(@NotNull EditorFactoryEvent event2) {
                Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
                Editor editor2 = event2.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"event.editor");
                if (!this.isPipFileEditor(editor2)) {
                    return;
                }
                DocumentListener listener2 = new DocumentListener(this){
                    final /* synthetic */ projectOpened.editorFactoryListener.1 this$0;

                    public void documentChanged(@NotNull DocumentEvent event2) {
                        Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
                        Document document = event2.getDocument();
                        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"event.document");
                        Document document2 = document;
                        VirtualFile virtualFile2 = PipenvKt.access$getVirtualFile$p(document2);
                        if (virtualFile2 == null || (virtualFile2 = PipenvKt.access$getModule(virtualFile2, this.this$0.this$0.getProject())) == null) {
                            return;
                        }
                        VirtualFile module = virtualFile2;
                        if (FileDocumentManager.getInstance().isDocumentUnsaved(document2)) {
                            projectOpened.editorFactoryListener.1.access$notifyPipFileChanged(this.this$0, (Module)module);
                        }
                    }
                    {
                        this.this$0 = $outer;
                    }
                };
                Editor editor3 = event2.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"event.editor");
                Document document = editor3.getDocument();
                boolean bl = false;
                boolean bl2 = false;
                Document $this$with = document;
                boolean bl3 = false;
                $this$with.addDocumentListener(listener2);
                $this$with.putUserData(this.changeListenerKey, (Object)listener2);
            }

            public void editorReleased(@NotNull EditorFactoryEvent event2) {
                Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
                DocumentListener documentListener2 = (DocumentListener)event2.getEditor().getUserData(this.changeListenerKey);
                if (documentListener2 == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)documentListener2, (String)"event.editor.getUserData\u2026ngeListenerKey) ?: return");
                DocumentListener listener2 = documentListener2;
                Editor editor2 = event2.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"event.editor");
                editor2.getDocument().removeDocumentListener(listener2);
            }

            private final void notifyPipFileChanged(Module module) {
                if (Intrinsics.areEqual((Object)((Boolean)module.getUserData(this.notificationActive)), (Object)true)) {
                    return;
                }
                String what = PipenvKt.access$getPipFileLock$p(module) == null ? "not found" : "out of date";
                String title = "Pipfile.lock is " + what;
                String content2 = "Run <a href='#lock'>pipenv lock</a> or <a href='#update'>pipenv update</a>";
                Notification notification2 = NotificationGroup.createNotification$default((NotificationGroup)PipenvKt.access$getLOCK_NOTIFICATION_GROUP$p(), (String)title, (String)content2, null, (NotificationListener)new NotificationListener(this, module){
                    final /* synthetic */ projectOpened.editorFactoryListener.1 this$0;
                    final /* synthetic */ Module $module;

                    public final void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event2) {
                        Intrinsics.checkParameterIsNotNull((Object)notification2, (String)"notification");
                        Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
                        notification2.expire();
                        this.$module.putUserData(projectOpened.editorFactoryListener.1.access$getNotificationActive$p(this.this$0), null);
                        FileDocumentManager.getInstance().saveAllDocuments();
                        String string = event2.getDescription();
                        if (string != null) {
                            switch (string) {
                                case "#lock": {
                                    projectOpened.editorFactoryListener.1.access$runPipEnvInBackground(this.this$0, this.$module, CollectionsKt.listOf((Object)"lock"), "Locking Pipfile");
                                    break;
                                }
                                case "#update": {
                                    projectOpened.editorFactoryListener.1.access$runPipEnvInBackground(this.this$0, this.$module, CollectionsKt.listOf((Object[])new String[]{"update", "--dev"}), "Updating Pipenv environment");
                                    break;
                                }
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$module = module;
                    }
                }, (int)4, null);
                module.putUserData(this.notificationActive, (Object)true);
                notification2.whenExpired(new Runnable(this, module){
                    final /* synthetic */ projectOpened.editorFactoryListener.1 this$0;
                    final /* synthetic */ Module $module;

                    public final void run() {
                        this.$module.putUserData(projectOpened.editorFactoryListener.1.access$getNotificationActive$p(this.this$0), null);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$module = module;
                    }
                });
                notification2.notify(this.this$0.getProject());
            }

            private final void runPipEnvInBackground(Module module, List<String> args2, String description) {
                Task.Backgroundable task2 = new Task.Backgroundable(module, description, args2, module.getProject(), StringUtil.toTitleCase((String)description), true){
                    final /* synthetic */ Module $module;
                    final /* synthetic */ String $description;
                    final /* synthetic */ List $args;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Loose catch block
                     * WARNING - void declaration
                     */
                    public void run(@NotNull ProgressIndicator indicator) {
                        Module module;
                        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                        Sdk sdk = PySdkExtKt.getPythonSdk(this.$module);
                        if (sdk == null) {
                            return;
                        }
                        Sdk sdk2 = sdk;
                        indicator.setText(this.$description + "...");
                        try {
                            String[] stringArray;
                            void $this$toTypedArray$iv;
                            Collection collection = this.$args;
                            Sdk sdk3 = sdk2;
                            boolean $i$f$toTypedArray = false;
                            void thisCollection$iv = $this$toTypedArray$iv;
                            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                            if (stringArray2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                            }
                            String[] stringArray3 = stringArray = stringArray2;
                            PipenvKt.runPipEnv(sdk3, Arrays.copyOf(stringArray3, stringArray3.length));
                        }
                        catch (RunCanceledByUserException $this$toTypedArray$iv) {
                            Module module2;
                            VirtualFile virtualFile2 = PythonSdkUtil.getSitePackagesDirectory(sdk2);
                            if (virtualFile2 != null) {
                                virtualFile2.refresh(true, true);
                            }
                            if ((module2 = PySdkExtKt.getAssociatedModule(sdk2)) != null && (module2 = BasePySdkExtKt.getBaseDir(module2)) != null) {
                                module2.refresh(true, false);
                            }
                        }
                        catch (ExecutionException e) {
                            Module module3;
                            block17: {
                                Application app$iv;
                                ModalityState modalityState$iv = null;
                                boolean $i$f$runInEdt = false;
                                Application application = app$iv = ApplicationManager.getApplication();
                                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
                                if (application.isDispatchThread()) {
                                    boolean bl = false;
                                    Messages.showErrorDialog((Project)this.getProject(), (String)e.toString(), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
                                    break block17;
                                }
                                boolean $i$f$invokeLater = false;
                                ApplicationManager.getApplication().invokeLater(new Runnable(this, e){
                                    final /* synthetic */ projectOpened.editorFactoryListener.runPipEnvInBackground.task.1 this$0;
                                    final /* synthetic */ ExecutionException $e$inlined;
                                    {
                                        this.this$0 = var1_1;
                                        this.$e$inlined = executionException;
                                    }

                                    public final void run() {
                                        boolean bl = false;
                                        Messages.showErrorDialog((Project)this.this$0.getProject(), (String)this.$e$inlined.toString(), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
                                    }
                                }, ModalityState.defaultModalityState());
                                {
                                    catch (Throwable throwable) {
                                        Module module4;
                                        VirtualFile virtualFile3 = PythonSdkUtil.getSitePackagesDirectory(sdk2);
                                        if (virtualFile3 != null) {
                                            virtualFile3.refresh(true, true);
                                        }
                                        if ((module4 = PySdkExtKt.getAssociatedModule(sdk2)) != null && (module4 = BasePySdkExtKt.getBaseDir(module4)) != null) {
                                            module4.refresh(true, false);
                                        }
                                        throw throwable;
                                    }
                                }
                            }
                            VirtualFile virtualFile4 = PythonSdkUtil.getSitePackagesDirectory(sdk2);
                            if (virtualFile4 != null) {
                                virtualFile4.refresh(true, true);
                            }
                            if ((module3 = PySdkExtKt.getAssociatedModule(sdk2)) != null && (module3 = BasePySdkExtKt.getBaseDir(module3)) != null) {
                                module3.refresh(true, false);
                            }
                        }
                        VirtualFile virtualFile5 = PythonSdkUtil.getSitePackagesDirectory(sdk2);
                        if (virtualFile5 != null) {
                            virtualFile5.refresh(true, true);
                        }
                        if ((module = PySdkExtKt.getAssociatedModule(sdk2)) != null && (module = BasePySdkExtKt.getBaseDir(module)) != null) {
                            module.refresh(true, false);
                        }
                    }
                    {
                        this.$module = $captured_local_variable$0;
                        this.$description = $captured_local_variable$1;
                        this.$args = $captured_local_variable$2;
                        super($super_call_param$3, $super_call_param$4, $super_call_param$5);
                    }
                };
                ProgressManager.getInstance().run((Task)task2);
            }

            private final boolean isPipFileEditor(Editor editor2) {
                if (Intrinsics.areEqual((Object)editor2.getProject(), (Object)this.this$0.getProject()) ^ true) {
                    return false;
                }
                Document document = editor2.getDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
                VirtualFile virtualFile2 = PipenvKt.access$getVirtualFile$p(document);
                if (virtualFile2 == null) {
                    return false;
                }
                VirtualFile file2 = virtualFile2;
                if (Intrinsics.areEqual((Object)file2.getName(), (Object)"Pipfile") ^ true) {
                    return false;
                }
                Module module = PipenvKt.access$getModule(file2, this.this$0.getProject());
                if (module == null) {
                    return false;
                }
                Module module2 = module;
                if (Intrinsics.areEqual((Object)PipenvKt.getPipFile(module2), (Object)file2) ^ true) {
                    return false;
                }
                Sdk sdk = PySdkExtKt.getPythonSdk(module2);
                return sdk != null && PipenvKt.isPipEnv(sdk);
            }
            {
                this.this$0 = $outer;
                Key key = Key.create((String)"Pipfile.change.listener");
                Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<DocumentListe\u2026Pipfile.change.listener\")");
                this.changeListenerKey = key;
                Key key2 = Key.create((String)"Pipfile.notification.active");
                Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create<Boolean>(\"Pipfile.notification.active\")");
                this.notificationActive = key2;
            }

            public static final /* synthetic */ void access$notifyPipFileChanged(projectOpened.editorFactoryListener.1 $this, Module module) {
                $this.notifyPipFileChanged(module);
            }

            public static final /* synthetic */ Key access$getNotificationActive$p(projectOpened.editorFactoryListener.1 $this) {
                return $this.notificationActive;
            }

            public static final /* synthetic */ void access$runPipEnvInBackground(projectOpened.editorFactoryListener.1 $this, Module module, List args2, String description) {
                $this.runPipEnvInBackground(module, args2, description);
            }
        };
        EditorFactory.getInstance().addEditorFactoryListener(editorFactoryListener2, (Disposable)this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public PipEnvPipFileWatcherComponent(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }
}

