/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.scientific.figures.display;

import com.google.gson.JsonObject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.python.scientific.DisplayMessageHandler;
import com.jetbrains.python.scientific.figures.DisplayMessageKt;
import com.jetbrains.python.scientific.figures.Figure;
import com.jetbrains.python.scientific.figures.MatplotlibDisplayObject;
import com.jetbrains.python.scientific.figures.base.FigureUtil;
import com.jetbrains.python.scientific.figures.image.ImageFigure;
import java.awt.image.BufferedImage;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;

public class MatplotlibMessageHandler
implements DisplayMessageHandler {
    private static final Logger LOG = Logger.getInstance(MatplotlibMessageHandler.class);

    @NotNull
    private static BufferedImage createImage(@NotNull MatplotlibDisplayObject displayObject) {
        BufferedImage bufferedImage;
        if (displayObject == null) {
            MatplotlibMessageHandler.$$$reportNull$$$0(0);
        }
        try {
            int width = displayObject.getImageWidth();
            String imageBase64 = displayObject.getImageBase64();
            byte[] bytes = Base64.getDecoder().decode(imageBase64);
            bufferedImage = FigureUtil.fromRawBytes(width, bytes);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Couldn't decode image", e);
        }
        if (bufferedImage == null) {
            MatplotlibMessageHandler.$$$reportNull$$$0(1);
        }
        return bufferedImage;
    }

    @Override
    public String getApplicableMessageType() {
        return "pycharm-plot-image";
    }

    @Override
    public Figure createFigure(@NotNull JsonObject dataObject, @NotNull Project project) {
        if (dataObject == null) {
            MatplotlibMessageHandler.$$$reportNull$$$0(2);
        }
        if (project == null) {
            MatplotlibMessageHandler.$$$reportNull$$$0(3);
        }
        MatplotlibDisplayObject displayObject = DisplayMessageKt.getDisplayObjectFromMap(dataObject);
        BufferedImage image = MatplotlibMessageHandler.createImage(displayObject);
        LOG.info("Plot is received: width=" + image.getWidth());
        int index = displayObject.getPlotIndex();
        ImageFigure figure = ImageFigure.createDefault(image, project);
        if (index >= 0) {
            figure.setSearchKey(index);
        }
        return figure;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/scientific/figures/display/MatplotlibMessageHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataObject";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/scientific/figures/display/MatplotlibMessageHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createImage";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFigure";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

