/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.google.common.collect.Lists;
import com.intellij.DynamicBundle;
import com.intellij.execution.ui.CommonProgramParametersPanel;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBComboBoxLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.jetbrains.PySymbolFieldWithBrowseButton;
import com.jetbrains.PySymbolFieldWithBrowseButtonKt;
import com.jetbrains.extensions.ContextAnchor;
import com.jetbrains.extensions.ModuleBasedContextAnchor;
import com.jetbrains.extensions.ProjectSdkContextAnchor;
import com.jetbrains.extensions.python.FileChooserDescriptorExtKt;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.run.AbstractPyCommonOptionsForm;
import com.jetbrains.python.run.AbstractPythonRunConfigurationParams;
import com.jetbrains.python.run.PyBrowseActionListener;
import com.jetbrains.python.run.PyCommonOptionsFormFactory;
import com.jetbrains.python.run.PythonRunConfiguration;
import com.jetbrains.python.run.PythonRunConfigurationParams;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PythonRunConfigurationForm
implements PythonRunConfigurationParams,
PanelWithAnchor {
    private JPanel myRootPanel;
    private TextFieldWithBrowseButton myScriptTextField;
    private RawCommandLineEditor myScriptParametersTextField;
    private JPanel myCommonOptionsPlaceholder;
    private JBLabel myScriptParametersLabel;
    private final AbstractPyCommonOptionsForm myCommonOptionsForm;
    private JComponent anchor;
    private final Project myProject;
    private JBCheckBox myShowCommandLineCheckbox;
    private JBCheckBox myEmulateTerminalCheckbox;
    private final PySymbolFieldWithBrowseButton myModuleField;
    private JBComboBoxLabel myTargetComboBox;
    private JPanel myModuleFieldPanel;
    private TextFieldWithBrowseButton myInputFileTextFieldWithBrowseButton;
    private JPanel myExecutionOptionsPlaceholder;
    private JPanel myExecutionOptionsPanel;
    private JBCheckBox myRedirectInputCheckBox;
    private boolean myModuleMode;

    public PythonRunConfigurationForm(PythonRunConfiguration configuration) {
        this.$$$setupUI$$$();
        this.myCommonOptionsForm = PyCommonOptionsFormFactory.getInstance().createForm(configuration.getCommonOptionsFormData());
        this.myCommonOptionsForm.addInterpreterModeListener(isRemoteInterpreter -> this.emulateTerminalEnabled(isRemoteInterpreter == false));
        this.myCommonOptionsPlaceholder.add((Component)this.myCommonOptionsForm.getMainPanel(), "Center");
        this.myProject = configuration.getProject();
        FileChooserDescriptor chooserDescriptor = FileChooserDescriptorExtKt.withPythonFiles(FileChooserDescriptorFactory.createSingleFileDescriptor().withTitle(PyBundle.message("python.run.select.script", new Object[0])), true);
        PyBrowseActionListener listener2 = new PyBrowseActionListener(configuration, chooserDescriptor){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.onFileChosen(chosenFile);
                PythonRunConfigurationForm.this.myCommonOptionsForm.setWorkingDirectory(chosenFile.getParent().getPath());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/jetbrains/python/run/PythonRunConfigurationForm$1", "onFileChosen"));
            }
        };
        this.myScriptTextField.addBrowseFolderListener((TextBrowseFolderListener)listener2);
        if (SystemInfo.isWindows) {
            this.emulateTerminalEnabled(false);
        }
        this.myEmulateTerminalCheckbox.setSelected(false);
        this.setAnchor(this.myRedirectInputCheckBox.getAnchor());
        Module module = configuration.getModule();
        Sdk sdk = configuration.getSdk();
        ContextAnchor contentAnchor = module != null ? new ModuleBasedContextAnchor(module) : new ProjectSdkContextAnchor(this.myProject, sdk);
        this.myModuleField = new PySymbolFieldWithBrowseButton(contentAnchor, (Function1<? super PsiElement, Boolean>)((Function1)element -> element instanceof PsiFileSystemItem && PySymbolFieldWithBrowseButtonKt.isPythonModule(element)), (Function0<? extends VirtualFile>)((Function0)() -> {
            String workingDirectory = this.myCommonOptionsForm.getWorkingDirectory();
            if (StringUtil.isEmpty((String)workingDirectory)) {
                return null;
            }
            return LocalFileSystem.getInstance().findFileByPath(workingDirectory);
        }));
        this.myModuleFieldPanel.add((Component)((Object)this.myModuleField), "Center");
        this.myInputFileTextFieldWithBrowseButton.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFileDescriptor(), this.myProject));
        HideableDecorator executionOptionsDecorator = new HideableDecorator(this.myExecutionOptionsPlaceholder, PyBundle.message("runcfg.labels.execution", new Object[0]), false);
        this.myExecutionOptionsPanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
        executionOptionsDecorator.setOn(true);
        executionOptionsDecorator.setContentComponent((JComponent)this.myExecutionOptionsPanel);
        this.myRedirectInputCheckBox.addItemListener(e -> this.myInputFileTextFieldWithBrowseButton.setEnabled(this.myRedirectInputCheckBox.isSelected()));
        ButtonGroup group2 = new ButtonGroup(){

            @Override
            public void setSelected(ButtonModel model, boolean isSelected) {
                if (!isSelected && Objects.equals(this.getSelection(), model)) {
                    this.clearSelection();
                    return;
                }
                super.setSelected(model, isSelected);
            }
        };
        group2.add((AbstractButton)this.myEmulateTerminalCheckbox);
        group2.add((AbstractButton)this.myRedirectInputCheckBox);
        group2.add((AbstractButton)this.myShowCommandLineCheckbox);
        CommonProgramParametersPanel.addMacroSupport((ExtendableTextField)this.myScriptParametersTextField.getEditorField());
    }

    private void updateRunModuleMode() {
        boolean mode = (PythonRunConfigurationForm.getModuleNameText() + ":").equals(this.myTargetComboBox.getText());
        this.checkTargetComboConsistency(mode);
        this.setModuleModeInternal(mode);
    }

    private void checkTargetComboConsistency(boolean mode) {
        String item = this.myTargetComboBox.getText();
        assert (item != null);
        if (mode && !StringUtil.toLowerCase((String)item).contains("module")) {
            throw new IllegalArgumentException("This option should refer to a module");
        }
    }

    private void emulateTerminalEnabled(boolean flag) {
        this.myEmulateTerminalCheckbox.setVisible(flag);
    }

    public JComponent getPanel() {
        return this.myRootPanel;
    }

    @Override
    public AbstractPythonRunConfigurationParams getBaseParams() {
        return this.myCommonOptionsForm;
    }

    @Override
    public String getScriptName() {
        if (this.isModuleMode()) {
            return this.myModuleField.getText().trim();
        }
        return FileUtil.toSystemIndependentName((String)this.myScriptTextField.getText().trim());
    }

    @Override
    public void setScriptName(String scriptName) {
        if (this.isModuleMode()) {
            this.myModuleField.setText(StringUtil.notNullize((String)scriptName));
        } else {
            this.myScriptTextField.setText(scriptName == null ? "" : FileUtil.toSystemDependentName((String)scriptName));
        }
    }

    @Override
    public String getScriptParameters() {
        return this.myScriptParametersTextField.getText().trim();
    }

    @Override
    public void setScriptParameters(String scriptParameters) {
        this.myScriptParametersTextField.setText(scriptParameters);
    }

    @Override
    public boolean showCommandLineAfterwards() {
        return this.myShowCommandLineCheckbox.isSelected();
    }

    @Override
    public void setShowCommandLineAfterwards(boolean showCommandLineAfterwards) {
        this.myShowCommandLineCheckbox.setSelected(showCommandLineAfterwards);
    }

    @Override
    public boolean emulateTerminal() {
        return this.myEmulateTerminalCheckbox.isSelected();
    }

    @Override
    public void setEmulateTerminal(boolean emulateTerminal) {
        this.myEmulateTerminalCheckbox.setSelected(emulateTerminal);
    }

    @Override
    public boolean isModuleMode() {
        return this.myModuleMode;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public boolean isMultiprocessMode() {
        return PyDebuggerOptionsProvider.getInstance(this.myProject).isAttachToSubprocess();
    }

    public void setMultiprocessMode(boolean multiprocess) {
    }

    @Nls
    public static String getScriptPathText() {
        return PyBundle.message("runcfg.labels.script.path", new Object[0]);
    }

    @Nls
    public static String getModuleNameText() {
        return PyBundle.message("runcfg.labels.module.name", new Object[0]);
    }

    @Override
    @NotNull
    public String getInputFile() {
        String string = this.myInputFileTextFieldWithBrowseButton.getText();
        if (string == null) {
            PythonRunConfigurationForm.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void setInputFile(@NotNull String inputFile) {
        if (inputFile == null) {
            PythonRunConfigurationForm.$$$reportNull$$$0(1);
        }
        this.myInputFileTextFieldWithBrowseButton.setText(inputFile);
    }

    @Override
    public boolean isRedirectInput() {
        return this.myRedirectInputCheckBox.isSelected();
    }

    @Override
    public void setRedirectInput(boolean isRedirectInput) {
        this.myRedirectInputCheckBox.setSelected(isRedirectInput);
        this.myInputFileTextFieldWithBrowseButton.setEnabled(isRedirectInput);
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myScriptParametersLabel.setAnchor(anchor);
        this.myCommonOptionsForm.setAnchor(anchor);
        this.myRedirectInputCheckBox.setAnchor(anchor);
    }

    @Override
    public void setModuleMode(boolean moduleMode) {
        this.setTargetComboBoxValue(moduleMode ? PythonRunConfigurationForm.getModuleNameText() : PythonRunConfigurationForm.getScriptPathText());
        this.updateRunModuleMode();
        this.checkTargetComboConsistency(moduleMode);
    }

    private void setModuleModeInternal(boolean moduleMode) {
        this.myModuleMode = moduleMode;
        this.myScriptTextField.setVisible(!moduleMode);
        this.myModuleFieldPanel.setVisible(moduleMode);
    }

    private void createUIComponents() {
        this.myTargetComboBox = new MyComboBox();
    }

    private void setTargetComboBoxValue(String text2) {
        this.myTargetComboBox.setText(text2 + ":");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JPanel jPanel;
        JPanel jPanel2;
        RawCommandLineEditor rawCommandLineEditor;
        JPanel jPanel3;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel4;
        JBLabel jBLabel;
        JPanel jPanel5;
        this.createUIComponents();
        this.myRootPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myScriptParametersLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PyBundle", PythonRunConfigurationForm.class).getString("runcfg.labels.script_parameters"));
        jPanel5.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(7, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCommonOptionsPlaceholder = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel4, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel6, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBComboBoxLabel jBComboBoxLabel = this.myTargetComboBox;
        jPanel5.add((Component)jBComboBoxLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 2, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myScriptTextField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel7.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 1, null, null, null));
        this.myModuleFieldPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myScriptParametersTextField = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption(ResourceBundle.getBundle("messages/PyBundle").getString("runcfg.captions.script_parameters_dialog"));
        rawCommandLineEditor.setText("");
        jPanel5.add((Component)rawCommandLineEditor, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myExecutionOptionsPlaceholder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel2, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myExecutionOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, "Center");
        this.myEmulateTerminalCheckbox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/PyBundle", PythonRunConfigurationForm.class).getString("form.python.run.configuration.emulate.terminal.in.output.console"));
        jPanel.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myShowCommandLineCheckbox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/PyBundle", PythonRunConfigurationForm.class).getString("form.python.run.configuration.run.with.python.console"));
        jPanel.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myInputFileTextFieldWithBrowseButton = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setEditable(true);
        textFieldWithBrowseButton.setEnabled(false);
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myRedirectInputCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setEnabled(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PyBundle", PythonRunConfigurationForm.class).getString("form.python.run.configuration.redirect.input.from"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jBCheckBox.setAnchor((JComponent)jBCheckBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/run/PythonRunConfigurationForm";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/run/PythonRunConfigurationForm";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setInputFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyComboBox
    extends JBComboBoxLabel
    implements UserActivityProviderComponent {
        private final List<ChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

        MyComboBox() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>("Choose target to run", (List)Lists.newArrayList((Object[])new String[]{PythonRunConfigurationForm.getScriptPathText(), PythonRunConfigurationForm.getModuleNameText()})){

                        public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                            PythonRunConfigurationForm.this.setTargetComboBoxValue(selectedValue);
                            PythonRunConfigurationForm.this.updateRunModuleMode();
                            return FINAL_CHOICE;
                        }
                    }).showUnderneathOf((Component)((Object)MyComboBox.this));
                }
            });
        }

        public void addChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                MyComboBox.$$$reportNull$$$0(0);
            }
            this.myListeners.add(changeListener);
        }

        public void removeChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                MyComboBox.$$$reportNull$$$0(1);
            }
            this.myListeners.remove(changeListener);
        }

        void fireChangeEvent() {
            for (ChangeListener l : this.myListeners) {
                l.stateChanged(new ChangeEvent((Object)this));
            }
        }

        public void setText(String text2) {
            super.setText(text2);
            this.fireChangeEvent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "changeListener";
            objectArray2[1] = "com/jetbrains/python/run/PythonRunConfigurationForm$MyComboBox";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChangeListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeChangeListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

