/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.google.common.collect.Lists;
import com.intellij.DynamicBundle;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.util.PathMappingsComponent;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.run.AbstractPyCommonOptionsForm;
import com.jetbrains.python.run.PyCommonOptionsFormData;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nullable;

public class PyPluginCommonOptionsForm
implements AbstractPyCommonOptionsForm {
    private final Project myProject;
    private TextFieldWithBrowseButton myWorkingDirectoryTextField;
    private EnvironmentVariablesComponent myEnvsComponent;
    private RawCommandLineEditor myInterpreterOptionsTextField;
    private ComboBox myInterpreterComboBox;
    private JRadioButton myUseModuleSdkRadioButton;
    private ModulesComboBox myModuleComboBox;
    private JPanel myMainPanel;
    private JRadioButton myUseSpecifiedSdkRadioButton;
    private JBLabel myPythonInterpreterJBLabel;
    private JBLabel myInterpreterOptionsJBLabel;
    private JBLabel myWorkingDirectoryJBLabel;
    private JPanel myHideablePanel;
    private PathMappingsComponent myPathMappingsComponent;
    private JBCheckBox myAddContentRootsCheckbox;
    private JBCheckBox myAddSourceRootsCheckbox;
    private JComponent labelAnchor;
    private final List<Consumer<Boolean>> myRemoteInterpreterModeListeners;

    public PyPluginCommonOptionsForm(PyCommonOptionsFormData data) {
        this.$$$setupUI$$$();
        this.myRemoteInterpreterModeListeners = Lists.newArrayList();
        this.myProject = data.getProject();
        List<Module> validModules = data.getValidModules();
        Collections.sort(validModules, new ModulesAlphaComparator());
        Module selection = validModules.size() > 0 ? validModules.get(0) : null;
        this.myModuleComboBox.setModules(validModules);
        this.myModuleComboBox.setSelectedModule(selection);
        this.myInterpreterComboBox.setMinimumAndPreferredWidth(100);
        this.myInterpreterComboBox.setRenderer((ListCellRenderer)((Object)new PySdkListCellRenderer(null, "<" + PyBundle.message("python.sdk.rendering.project.default", new Object[0]) + ">")));
        this.myWorkingDirectoryTextField.addBrowseFolderListener(PyBundle.message("configurable.select.working.directory", new Object[0]), "", data.getProject(), FileChooserDescriptorFactory.createSingleFolderDescriptor());
        ActionListener listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PyPluginCommonOptionsForm.this.updateControls();
            }
        };
        this.myUseSpecifiedSdkRadioButton.addActionListener(listener2);
        this.myUseModuleSdkRadioButton.addActionListener(listener2);
        this.myInterpreterComboBox.addActionListener(listener2);
        this.myModuleComboBox.addActionListener(listener2);
        this.setAnchor((JComponent)this.myEnvsComponent.getLabel());
        HideableDecorator decorator = new HideableDecorator(this.myHideablePanel, PyBundle.message("python.sdk.common.options.environment", new Object[0]), false){

            protected void on() {
                super.on();
                this.storeState();
            }

            protected void off() {
                super.off();
                this.storeState();
            }

            private void storeState() {
                PropertiesComponent.getInstance().setValue("ExpandEnvironmentPanel", String.valueOf(this.isExpanded()), "true");
            }
        };
        decorator.setOn(PropertiesComponent.getInstance().getBoolean("ExpandEnvironmentPanel", true));
        decorator.setContentComponent((JComponent)this.myMainPanel);
        this.myPathMappingsComponent.setAnchor((JComponent)this.myEnvsComponent.getLabel());
        this.updateControls();
        this.addInterpreterComboBoxActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Consumer f : PyPluginCommonOptionsForm.this.myRemoteInterpreterModeListeners) {
                    f.accept(PythonSdkUtil.isRemote(PyPluginCommonOptionsForm.this.getSelectedSdk()));
                }
            }
        });
    }

    private void updateControls() {
        this.myModuleComboBox.setEnabled(this.myUseModuleSdkRadioButton.isSelected());
        this.myInterpreterComboBox.setEnabled(this.myUseSpecifiedSdkRadioButton.isSelected());
        this.myPathMappingsComponent.setVisible(PythonSdkUtil.isRemote(this.getSelectedSdk()));
    }

    @Override
    public JPanel getMainPanel() {
        return this.myHideablePanel;
    }

    @Override
    public void subscribe() {
    }

    @Override
    public void addInterpreterComboBoxActionListener(ActionListener listener2) {
        this.myInterpreterComboBox.addActionListener(listener2);
    }

    @Override
    public void removeInterpreterComboBoxActionListener(ActionListener listener2) {
        this.myInterpreterComboBox.removeActionListener(listener2);
    }

    @Override
    public void addInterpreterModeListener(Consumer<Boolean> listener2) {
        this.myRemoteInterpreterModeListeners.add(listener2);
    }

    @Override
    public String getInterpreterOptions() {
        return this.myInterpreterOptionsTextField.getText().trim();
    }

    @Override
    public void setInterpreterOptions(String interpreterOptions) {
        this.myInterpreterOptionsTextField.setText(interpreterOptions);
    }

    @Override
    public String getWorkingDirectory() {
        return FileUtil.toSystemIndependentName((String)this.myWorkingDirectoryTextField.getText().trim());
    }

    @Override
    public void setWorkingDirectory(String workingDirectory) {
        this.myWorkingDirectoryTextField.setText(workingDirectory == null ? "" : FileUtil.toSystemDependentName((String)workingDirectory));
    }

    @Override
    @Nullable
    public String getSdkHome() {
        Sdk selectedSdk = (Sdk)this.myInterpreterComboBox.getSelectedItem();
        return selectedSdk == null ? null : selectedSdk.getHomePath();
    }

    @Override
    public void setSdkHome(String sdkHome) {
        ArrayList<Sdk> sdkList = new ArrayList<Sdk>();
        sdkList.add(null);
        List<Sdk> allSdks = PythonSdkUtil.getAllSdks();
        Collections.sort(allSdks, new PreferredSdkComparator());
        Sdk selection = null;
        for (Sdk sdk : allSdks) {
            String homePath = sdk.getHomePath();
            if (homePath != null && sdkHome != null && FileUtil.pathsEqual((String)homePath, (String)sdkHome)) {
                selection = sdk;
            }
            sdkList.add(sdk);
        }
        this.myInterpreterComboBox.setModel((ComboBoxModel)new CollectionComboBoxModel(sdkList, selection));
    }

    @Override
    public Module getModule() {
        return this.myModuleComboBox.getSelectedModule();
    }

    @Override
    public String getModuleName() {
        Module module = this.getModule();
        return module != null ? module.getName() : null;
    }

    @Override
    public void setModule(Module module) {
        this.myModuleComboBox.setSelectedModule(module);
    }

    @Override
    public boolean isUseModuleSdk() {
        return this.myUseModuleSdkRadioButton.isSelected();
    }

    @Override
    public void setUseModuleSdk(boolean useModuleSdk) {
        if (useModuleSdk) {
            this.myUseModuleSdkRadioButton.setSelected(true);
        } else {
            this.myUseSpecifiedSdkRadioButton.setSelected(true);
        }
        this.updateControls();
    }

    @Override
    public boolean isPassParentEnvs() {
        return this.myEnvsComponent.isPassParentEnvs();
    }

    @Override
    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myEnvsComponent.setPassParentEnvs(passParentEnvs);
    }

    @Override
    public Map<String, String> getEnvs() {
        return this.myEnvsComponent.getEnvs();
    }

    @Override
    public void setEnvs(Map<String, String> envs) {
        this.myEnvsComponent.setEnvs(envs);
    }

    @Override
    public PathMappingSettings getMappingSettings() {
        return this.myPathMappingsComponent.getMappingSettings();
    }

    @Override
    public void setMappingSettings(@Nullable PathMappingSettings mappingSettings) {
        this.myPathMappingsComponent.setMappingSettings(mappingSettings);
    }

    private Sdk getSelectedSdk() {
        if (this.isUseModuleSdk()) {
            Module module = this.getModule();
            return module == null ? null : ModuleRootManager.getInstance((Module)module).getSdk();
        }
        Sdk sdk = (Sdk)this.myInterpreterComboBox.getSelectedItem();
        if (sdk == null) {
            return ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        }
        return sdk;
    }

    public JComponent getAnchor() {
        return this.labelAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.labelAnchor = anchor;
        this.myPythonInterpreterJBLabel.setAnchor(anchor);
        this.myInterpreterOptionsJBLabel.setAnchor(anchor);
        this.myWorkingDirectoryJBLabel.setAnchor(anchor);
        this.myEnvsComponent.setAnchor(anchor);
    }

    @Override
    public boolean shouldAddContentRoots() {
        return this.myAddContentRootsCheckbox.isSelected();
    }

    @Override
    public boolean shouldAddSourceRoots() {
        return this.myAddSourceRootsCheckbox.isSelected();
    }

    @Override
    public void setAddContentRoots(boolean flag) {
        this.myAddContentRootsCheckbox.setSelected(flag);
    }

    @Override
    public void setAddSourceRoots(boolean flag) {
        this.myAddSourceRootsCheckbox.setSelected(flag);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        PathMappingsComponent pathMappingsComponent;
        ComboBox comboBox;
        JRadioButton jRadioButton;
        ModulesComboBox modulesComboBox;
        JRadioButton jRadioButton2;
        JBLabel jBLabel;
        RawCommandLineEditor rawCommandLineEditor;
        JBLabel jBLabel2;
        EnvironmentVariablesComponent environmentVariablesComponent;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel3;
        JPanel jPanel;
        JPanel jPanel2;
        this.myHideablePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, "Center");
        this.myWorkingDirectoryJBLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/PyBundle", PyPluginCommonOptionsForm.class).getString("runcfg.labels.working_directory"));
        jPanel.add((Component)jBLabel3, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWorkingDirectoryTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(5, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myEnvsComponent = environmentVariablesComponent = new EnvironmentVariablesComponent();
        environmentVariablesComponent.setLabelLocation("West");
        environmentVariablesComponent.setText(DynamicBundle.getBundle((String)"messages/PyBundle", PyPluginCommonOptionsForm.class).getString("runcfg.labels.environment_variables"));
        jPanel.add((Component)environmentVariablesComponent, new GridConstraints(0, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        this.myInterpreterOptionsJBLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/PyBundle", PyPluginCommonOptionsForm.class).getString("runcfg.labels.interpreter_options"));
        jPanel.add((Component)jBLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInterpreterOptionsTextField = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption(ResourceBundle.getBundle("messages/PyBundle").getString("runcfg.captions.interpreter_options_dialog"));
        rawCommandLineEditor.setText("");
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(4, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPythonInterpreterJBLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PyBundle", PyPluginCommonOptionsForm.class).getString("runcfg.labels.python.interpreter"));
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUseModuleSdkRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/PyBundle", PyPluginCommonOptionsForm.class).getString("runcfg.labels.use.sdk.of.module"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModuleComboBox = modulesComboBox = new ModulesComboBox();
        jPanel.add((Component)modulesComboBox, new GridConstraints(1, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myUseSpecifiedSdkRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/PyBundle", PyPluginCommonOptionsForm.class).getString("runcfg.labels.interpreter"));
        jPanel.add((Component)jRadioButton, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInterpreterComboBox = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(2, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 0, new Dimension(-1, 15), new Dimension(-1, 15), new Dimension(-1, 15)));
        this.myPathMappingsComponent = pathMappingsComponent = new PathMappingsComponent();
        pathMappingsComponent.setLabelLocation("West");
        pathMappingsComponent.setText(DynamicBundle.getBundle((String)"messages/PyBundle", PyPluginCommonOptionsForm.class).getString("runcfg.labels.path.mappings"));
        jPanel.add((Component)pathMappingsComponent, new GridConstraints(6, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        this.myAddContentRootsCheckbox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/PyBundle", PyPluginCommonOptionsForm.class).getString("runcfg.labels.add.content.roots.to.pythonpath"));
        jPanel.add((Component)jBCheckBox2, new GridConstraints(7, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myAddSourceRootsCheckbox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PyBundle", PyPluginCommonOptionsForm.class).getString("runcfg.labels.add.source.roots.to.pythonpath"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(8, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myHideablePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

