/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.profiler.ProfileSessionKt;
import com.jetbrains.python.profiler.ProfilerCommunication;
import java.net.ServerSocket;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/python/profiler/ProfileSession;", "", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "serverSocket", "Ljava/net/ServerSocket;", "name", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Lcom/intellij/execution/ExecutionResult;Ljava/net/ServerSocket;Ljava/lang/String;)V", "contentDescriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "getContentDescriptor", "()Lcom/intellij/execution/ui/RunContentDescriptor;", "profilerCommunication", "Lcom/jetbrains/python/profiler/ProfilerCommunication;", "getProfilerCommunication", "()Lcom/jetbrains/python/profiler/ProfilerCommunication;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getServerSocket", "()Ljava/net/ServerSocket;", "intellij.python.profiler"})
public final class ProfileSession {
    @NotNull
    private final ProfilerCommunication profilerCommunication;
    @NotNull
    private final RunContentDescriptor contentDescriptor;
    @NotNull
    private final Project project;
    @NotNull
    private final ServerSocket serverSocket;

    @NotNull
    public final ProfilerCommunication getProfilerCommunication() {
        return this.profilerCommunication;
    }

    @NotNull
    public final RunContentDescriptor getContentDescriptor() {
        return this.contentDescriptor;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public ProfileSession(@NotNull Project project, @NotNull Sdk sdk, @NotNull ExecutionResult executionResult, @NotNull ServerSocket serverSocket, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)sdk, (String)"sdk");
        Intrinsics.checkParameterIsNotNull((Object)executionResult, (String)"executionResult");
        Intrinsics.checkParameterIsNotNull((Object)serverSocket, (String)"serverSocket");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.project = project;
        this.serverSocket = serverSocket;
        this.profilerCommunication = new ProfilerCommunication(this.project, sdk, this.serverSocket, executionResult.getProcessHandler());
        ExecutionConsole executionConsole = executionResult.getExecutionConsole();
        if (executionConsole == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.execution.ui.ConsoleView");
        }
        ConsoleView consoleView = (ConsoleView)executionConsole;
        ProcessHandler processHandler2 = executionResult.getProcessHandler();
        Intrinsics.checkExpressionValueIsNotNull((Object)processHandler2, (String)"executionResult.processHandler");
        this.contentDescriptor = ProfileSessionKt.access$buildProfileRunContentDescriptor(this.project, consoleView, processHandler2, this.profilerCommunication, name);
    }
}

