/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BinaryOSProcessHandler;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessListener;
import com.jetbrains.python.profiler.BinaryProcessOutput;
import com.jetbrains.python.profiler.ProfilerLogKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/python/profiler/BinaryProcessHandler;", "Lcom/intellij/execution/process/BinaryOSProcessHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "(Lcom/intellij/execution/configurations/GeneralCommandLine;)V", "binaryOutput", "Lcom/jetbrains/python/profiler/BinaryProcessOutput;", "runProcess", "intellij.python.profiler"})
public final class BinaryProcessHandler
extends BinaryOSProcessHandler {
    private final BinaryProcessOutput binaryOutput;

    @NotNull
    public final BinaryProcessOutput runProcess() {
        this.startNotify();
        if (this.waitFor()) {
            this.binaryOutput.setExitCode(this.getProcess().exitValue());
            byte[] byArray = this.getOutput();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"output");
            this.binaryOutput.setBinaryOutput(byArray);
        } else {
            ProfilerLogKt.getLOG().info("runProcess: exit value unavailable");
        }
        return this.binaryOutput;
    }

    public BinaryProcessHandler(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        super(commandLine);
        this.binaryOutput = new BinaryProcessOutput();
        this.addProcessListener((ProcessListener)new CapturingProcessAdapter(this.binaryOutput.getProcessOutput()));
    }
}

