/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.inspections.PyDunderSlotsInspection$Visitor$visitPyClass$;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inspections/PyDunderSlotsInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.python.community.impl"})
public final class PyDunderSlotsInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new Visitor(holder, session);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u0014\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/inspections/PyDunderSlotsInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "checkAttributeExpression", "", "target", "Lcom/jetbrains/python/psi/PyTargetExpression;", "findSlotsValue", "Lcom/jetbrains/python/psi/PyExpression;", "pyClass", "Lcom/jetbrains/python/psi/PyClass;", "processSlot", "slot", "Lcom/jetbrains/python/psi/PyStringLiteralExpression;", "visitPyClass", "node", "visitPyTargetExpression", "intellij.python.community.impl"})
    private static final class Visitor
    extends PyInspectionVisitor {
        @Override
        public void visitPyClass(@Nullable PyClass node) {
            block2: {
                PyExpression pyExpression;
                PyExpression slots;
                block3: {
                    super.visitPyClass(node);
                    if (node == null) break block2;
                    LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)node);
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)languageLevel), (String)"LanguageLevel.forElement(node)");
                    if (languageLevel.isPython2()) break block2;
                    slots = this.findSlotsValue(node);
                    pyExpression = slots;
                    if (!(pyExpression instanceof PySequenceExpression)) break block3;
                    Object[] objectArray = ((PySequenceExpression)slots).getElements();
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"slots\n            .elements");
                    Sequence $this$filterIsInstance$iv = ArraysKt.asSequence((Object[])objectArray);
                    boolean $i$f$filterIsInstance = false;
                    Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Visitor$visitPyClass$$inlined$filterIsInstance$1.INSTANCE);
                    if (sequence == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                    }
                    Sequence $this$forEach$iv = sequence;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PyStringLiteralExpression it = (PyStringLiteralExpression)element$iv;
                        boolean bl = false;
                        this.processSlot(node, it);
                    }
                    break block2;
                }
                if (!(pyExpression instanceof PyStringLiteralExpression)) break block2;
                this.processSlot(node, (PyStringLiteralExpression)slots);
            }
        }

        @Override
        public void visitPyTargetExpression(@Nullable PyTargetExpression node) {
            super.visitPyTargetExpression(node);
            if (node != null) {
                this.checkAttributeExpression(node);
            }
        }

        private final PyExpression findSlotsValue(PyClass pyClass) {
            PyTargetExpression target;
            PyTargetExpression pyTargetExpression = target = pyClass.findClassAttribute("__slots__", false, this.myTypeEvalContext);
            PyExpression value2 = pyTargetExpression != null ? pyTargetExpression.findAssignedValue() : null;
            return PyPsiUtils.flattenParens(value2);
        }

        private final void processSlot(PyClass pyClass, PyStringLiteralExpression slot) {
            String string = slot.getStringValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"slot.stringValue");
            String name = string;
            PyTargetExpression classAttribute = pyClass.findClassAttribute(name, false, this.myTypeEvalContext);
            if (classAttribute != null && classAttribute.hasAssignedValue()) {
                this.registerProblem(slot, '\'' + name + "' in __slots__ conflicts with class variable");
            }
        }

        private final void checkAttributeExpression(PyTargetExpression target) {
            String targetName = target.getName();
            PyExpression qualifier = target.getQualifier();
            if (targetName == null || qualifier == null) {
                return;
            }
            PyType qualifierType = this.myTypeEvalContext.getType(qualifier);
            if (qualifierType instanceof PyClassType && !((PyClassType)qualifierType).isAttributeWritable(targetName, this.myTypeEvalContext)) {
                this.registerProblem(target, '\'' + ((PyClassType)qualifierType).getName() + "' object attribute '" + targetName + "' is read-only");
            }
        }

        public Visitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
            Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
            super(holder, session);
        }
    }
}

