/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.jetbrains.python.defaultProjectAwareService.PyDefaultProjectAwareModuleConfiguratorImpl;
import com.jetbrains.python.defaultProjectAwareService.PyDefaultProjectAwareService;
import com.jetbrains.python.defaultProjectAwareService.PyDefaultProjectAwareServiceClasses;
import com.jetbrains.python.defaultProjectAwareService.PyDefaultProjectAwareServiceModuleConfigurator;
import com.jetbrains.python.documentation.PyDocumentationSettingsDetector;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyDocumentationSettings
extends PyDefaultProjectAwareService<ServiceState, PyDocumentationSettings, AppService, ModuleService> {
    private static final PyDefaultProjectAwareServiceClasses<ServiceState, PyDocumentationSettings, AppService, ModuleService> SERVICE_CLASSES = new PyDefaultProjectAwareServiceClasses(AppService.class, ModuleService.class);
    static final DocStringFormat DEFAULT_DOC_STRING_FORMAT = DocStringFormat.REST;
    private static final PyDocumentationSettingsDetector DETECTOR = new PyDocumentationSettingsDetector();

    protected PyDocumentationSettings() {
        super(new ServiceState());
    }

    public static PyDocumentationSettings getInstance(@Nullable Module module) {
        return SERVICE_CLASSES.getService(module);
    }

    @NotNull
    public static PyDefaultProjectAwareServiceModuleConfigurator getConfigurator() {
        return new PyDefaultProjectAwareModuleConfiguratorImpl<ServiceState, PyDocumentationSettings, AppService, ModuleService>(SERVICE_CLASSES, DETECTOR);
    }

    public final boolean isNumpyFormat(PsiFile file2) {
        return this.isFormat(file2, DocStringFormat.NUMPY);
    }

    public final boolean isPlain(PsiFile file2) {
        return this.isFormat(file2, DocStringFormat.PLAIN);
    }

    private boolean isFormat(@Nullable PsiFile file2, @NotNull DocStringFormat format) {
        if (format == null) {
            PyDocumentationSettings.$$$reportNull$$$0(0);
        }
        return file2 instanceof PyFile ? this.getFormatForFile(file2) == format : ((ServiceState)this.getState()).getFormat() == format;
    }

    @NotNull
    public final DocStringFormat getFormatForFile(@NotNull PsiFile file2) {
        DocStringFormat fileFormat;
        if (file2 == null) {
            PyDocumentationSettings.$$$reportNull$$$0(1);
        }
        DocStringFormat docStringFormat = (fileFormat = PyDocumentationSettings.getFormatFromDocformatAttribute(file2)) != null && fileFormat != DocStringFormat.PLAIN ? fileFormat : ((ServiceState)this.getState()).myDocStringFormat;
        if (docStringFormat == null) {
            PyDocumentationSettings.$$$reportNull$$$0(2);
        }
        return docStringFormat;
    }

    @Nullable
    public static DocStringFormat getFormatFromDocformatAttribute(@NotNull PsiFile file2) {
        DocStringFormat fileFormat;
        List words;
        String docformat;
        PyTargetExpression expr;
        if (file2 == null) {
            PyDocumentationSettings.$$$reportNull$$$0(3);
        }
        if (file2 instanceof PyFile && (expr = ((PyFile)file2).findTopLevelAttribute("__docformat__")) != null && (docformat = PyPsiUtils.strValue(expr.findAssignedValue())) != null && (words = StringUtil.split((String)docformat, (String)" ")).size() > 0 && (fileFormat = DocStringFormat.fromName((String)words.get(0))) != null) {
            return fileFormat;
        }
        return null;
    }

    @NotNull
    public final DocStringFormat getFormat() {
        DocStringFormat docStringFormat = ((ServiceState)this.getState()).getFormat();
        if (docStringFormat == null) {
            PyDocumentationSettings.$$$reportNull$$$0(4);
        }
        return docStringFormat;
    }

    public final void setFormat(@NotNull DocStringFormat format) {
        if (format == null) {
            PyDocumentationSettings.$$$reportNull$$$0(5);
        }
        ((ServiceState)this.getState()).myDocStringFormat = format;
    }

    public final boolean isAnalyzeDoctest() {
        return ((ServiceState)this.getState()).myAnalyzeDoctest;
    }

    public final void setAnalyzeDoctest(boolean analyze) {
        ((ServiceState)this.getState()).myAnalyzeDoctest = analyze;
    }

    public final boolean isRenderExternalDocumentation() {
        return ((ServiceState)this.getState()).myRenderExternalDocumentation;
    }

    public final void setRenderExternalDocumentation(boolean renderExternalDocumentation) {
        ((ServiceState)this.getState()).myRenderExternalDocumentation = renderExternalDocumentation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/PyDocumentationSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/PyDocumentationSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatForFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFormat";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFormatForFile";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFormatFromDocformatAttribute";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setFormat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @State(name="PyDocumentationSettings")
    public static final class ModuleService
    extends PyDocumentationSettings {
    }

    @State(name="AppPyDocumentationSettings", storages={@Storage(value="PyDocumentationSettings.xml")})
    public static final class AppService
    extends PyDocumentationSettings {
    }

    public static final class ServiceState {
        @NotNull
        private DocStringFormat myDocStringFormat;
        @OptionTag(value="analyzeDoctest")
        public boolean myAnalyzeDoctest;
        @OptionTag(value="renderExternalDocumentation")
        public boolean myRenderExternalDocumentation;

        ServiceState(@NotNull DocStringFormat docStringFormat) {
            if (docStringFormat == null) {
                ServiceState.$$$reportNull$$$0(0);
            }
            this.myAnalyzeDoctest = true;
            this.myDocStringFormat = docStringFormat;
        }

        ServiceState() {
            this(DEFAULT_DOC_STRING_FORMAT);
        }

        @NotNull
        public DocStringFormat getFormat() {
            DocStringFormat docStringFormat = this.myDocStringFormat;
            if (docStringFormat == null) {
                ServiceState.$$$reportNull$$$0(1);
            }
            return docStringFormat;
        }

        public void setFormat(@NotNull DocStringFormat format) {
            if (format == null) {
                ServiceState.$$$reportNull$$$0(2);
            }
            this.myDocStringFormat = format;
        }

        @OptionTag(value="myDocStringFormat")
        @NotNull
        public String getFormatName() {
            String string = this.myDocStringFormat.getName();
            if (string == null) {
                ServiceState.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void setFormatName(@NotNull String name) {
            if (name == null) {
                ServiceState.$$$reportNull$$$0(4);
            }
            this.myDocStringFormat = DocStringFormat.fromNameOrPlain(name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docStringFormat";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/PyDocumentationSettings$ServiceState";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/PyDocumentationSettings$ServiceState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFormat";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFormatName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setFormat";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setFormatName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

