/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.concurrency.model;

import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.debugger.concurrency.model.ConcurrencyGraphPresentationModel;
import org.jetbrains.annotations.NotNull;

public class ConcurrencyGraphVisualSettings {
    private int myMcsPerCell;
    private int myHorizontalValue;
    private int myHorizontalExtent;
    private int myHorizontalMax;
    private int myVerticalValue;
    private int myVerticalExtent;
    private int myVerticalMax;
    @NotNull
    private final ConcurrencyGraphPresentationModel myPresentationModel;
    private static final int DIVIDER_WIDTH = 3;

    public ConcurrencyGraphVisualSettings(@NotNull ConcurrencyGraphPresentationModel presentationModel) {
        if (presentationModel == null) {
            ConcurrencyGraphVisualSettings.$$$reportNull$$$0(0);
        }
        this.myMcsPerCell = 10000;
        this.myPresentationModel = presentationModel;
    }

    private void updateView(int prevMcsPerCell) {
        this.myPresentationModel.updateTimerPeriod();
        int cursorWindowPadding = this.myPresentationModel.getGraphModel().getTimeCursor() - this.myHorizontalValue;
        this.myPresentationModel.getGraphModel().setTimeCursor(this.myPresentationModel.getGraphModel().getTimeCursor() * prevMcsPerCell / this.myMcsPerCell);
        this.myPresentationModel.updateGraphModel();
        int newValue = Math.max(0, this.myPresentationModel.getGraphModel().getTimeCursor() - cursorWindowPadding);
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myPresentationModel.getToolWindowPanel().getTableScrollPane() != null) {
                this.myPresentationModel.getToolWindowPanel().getTableScrollPane().getHorizontalScrollBar().setValue(newValue);
            }
        });
    }

    public void zoomIn() {
        int prevMcsPerCell = this.myMcsPerCell;
        this.myMcsPerCell = Math.max(100, (int)(Math.round((double)this.myMcsPerCell * 0.9) - Math.round((double)this.myMcsPerCell * 0.9) % 100L));
        if (this.myMcsPerCell != prevMcsPerCell) {
            this.updateView(prevMcsPerCell);
        }
    }

    public void zoomOut() {
        int prevMcsPerCell = this.myMcsPerCell;
        this.myMcsPerCell = Math.min(1000000, Math.max((int)(Math.round((double)this.myMcsPerCell * 1.1) - Math.round((double)this.myMcsPerCell * 1.1) % 100L), this.myMcsPerCell + 100));
        if (this.myMcsPerCell != prevMcsPerCell) {
            this.updateView(prevMcsPerCell);
        }
    }

    public void scrollToTheEnd() {
        if (this.myPresentationModel.getToolWindowPanel().getTableScrollPane() != null) {
            UIUtil.invokeLaterIfNeeded(() -> this.myPresentationModel.getToolWindowPanel().getTableScrollPane().getHorizontalScrollBar().setValue(this.myHorizontalMax - this.myHorizontalExtent));
        }
    }

    public int getMcsPerCell() {
        return this.myMcsPerCell;
    }

    public int getCellsPerRulerUnit() {
        return 10;
    }

    public int getDividerWidth() {
        return 3;
    }

    public int getVerticalValue() {
        return this.myVerticalValue;
    }

    public int getVerticalExtent() {
        return this.myVerticalExtent;
    }

    public int getVerticalMax() {
        return this.myVerticalMax;
    }

    public int getHorizontalValue() {
        return this.myHorizontalValue;
    }

    public int getHorizontalExtent() {
        return this.myHorizontalExtent;
    }

    public int getHorizontalMax() {
        return this.myHorizontalMax;
    }

    public void updateHorizontalScrollbar(int scrollbarValue, int scrollbarExtent, int scrollMax) {
        this.myHorizontalValue = scrollbarValue;
        this.myHorizontalExtent = scrollbarExtent;
        this.myHorizontalMax = scrollMax;
        this.myPresentationModel.updateGraphModel();
    }

    public void updateVerticalScrollbar(int scrollbarValue, int scrollbarExtent, int scrollMax) {
        this.myVerticalValue = scrollbarValue;
        this.myVerticalExtent = scrollbarExtent;
        this.myVerticalMax = scrollMax;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationModel", "com/jetbrains/python/debugger/concurrency/model/ConcurrencyGraphVisualSettings", "<init>"));
    }
}

