/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyBaseConvertCollectionLiteralIntention
extends PyBaseIntentionAction {
    private final Class<? extends PySequenceExpression> myTargetCollectionClass;
    private final String myTargetCollectionName;
    private final String myRightBrace;
    private final String myLeftBrace;

    public PyBaseConvertCollectionLiteralIntention(@NotNull Class<? extends PySequenceExpression> targetCollectionClass, @NotNull String targetCollectionName, @NotNull String leftBrace, @NotNull String rightBrace) {
        if (targetCollectionClass == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(0);
        }
        if (targetCollectionName == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(1);
        }
        if (leftBrace == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(2);
        }
        if (rightBrace == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(3);
        }
        this.myTargetCollectionClass = targetCollectionClass;
        this.myTargetCollectionName = targetCollectionName;
        this.myLeftBrace = leftBrace;
        this.myRightBrace = rightBrace;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.convert.collection.literal.family", this.myTargetCollectionName);
        if (string == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file2) {
        if (project == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(5);
        }
        if (!(file2 instanceof PyFile)) {
            return false;
        }
        PySequenceExpression literal = PyBaseConvertCollectionLiteralIntention.findCollectionLiteralUnderCaret(editor2, file2);
        if (this.myTargetCollectionClass.isInstance(literal)) {
            return false;
        }
        if (literal instanceof PyTupleExpression) {
            this.setText(PyBundle.message("INTN.convert.collection.literal.text", "tuple", this.myTargetCollectionName));
        } else if (literal instanceof PyListLiteralExpression) {
            this.setText(PyBundle.message("INTN.convert.collection.literal.text", "list", this.myTargetCollectionName));
        } else if (literal instanceof PySetLiteralExpression) {
            this.setText(PyBundle.message("INTN.convert.collection.literal.text", "set", this.myTargetCollectionName));
        } else {
            return false;
        }
        return this.isAvailableForCollection(literal);
    }

    protected boolean isAvailableForCollection(@NotNull PySequenceExpression literal) {
        if (literal == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(6);
        }
        return true;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(7);
        }
        PySequenceExpression literal = PyBaseConvertCollectionLiteralIntention.findCollectionLiteralUnderCaret(editor2, file2);
        assert (literal != null);
        PsiElement replacedElement = PyBaseConvertCollectionLiteralIntention.wrapCollection(literal);
        PsiElement copy = this.prepareOriginalElementCopy(replacedElement.copy());
        TextRange contentRange = PyBaseConvertCollectionLiteralIntention.getRangeOfContentWithoutBraces(copy);
        String contentToWrap = contentRange.substring(copy.getText());
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        PyExpression newLiteral = elementGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)file2), this.myLeftBrace + contentToWrap + this.myRightBrace);
        replacedElement.replace((PsiElement)newLiteral);
    }

    @NotNull
    protected PsiElement prepareOriginalElementCopy(@NotNull PsiElement copy) {
        PsiElement next2;
        PyExpression[] elements;
        PySequenceExpression sequence;
        if (copy == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(8);
        }
        if ((sequence = PyBaseConvertCollectionLiteralIntention.unwrapCollection(copy)) instanceof PyTupleExpression && (elements = sequence.getElements()).length == 1 && (next2 = PyPsiUtils.getNextNonCommentSibling((PsiElement)elements[0], true)) != null && next2.getNode().getElementType() == PyTokenTypes.COMMA) {
            next2.delete();
        }
        PsiElement psiElement = copy;
        if (psiElement == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(9);
        }
        return psiElement;
    }

    @NotNull
    protected static PySequenceExpression unwrapCollection(@NotNull PsiElement literal) {
        PyParenthesizedExpression parenthesizedExpression;
        if (literal == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(10);
        }
        if ((parenthesizedExpression = PyUtil.as(literal, PyParenthesizedExpression.class)) != null) {
            PyExpression containedExpression = parenthesizedExpression.getContainedExpression();
            assert (containedExpression != null);
            PyTupleExpression pyTupleExpression = (PyTupleExpression)containedExpression;
            if (pyTupleExpression == null) {
                PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(11);
            }
            return pyTupleExpression;
        }
        PySequenceExpression pySequenceExpression = (PySequenceExpression)literal;
        if (pySequenceExpression == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(12);
        }
        return pySequenceExpression;
    }

    @NotNull
    protected static PsiElement wrapCollection(@NotNull PySequenceExpression literal) {
        if (literal == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(13);
        }
        if (literal instanceof PyTupleExpression && literal.getParent() instanceof PyParenthesizedExpression) {
            PsiElement psiElement = literal.getParent();
            if (psiElement == null) {
                PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(14);
            }
            return psiElement;
        }
        PySequenceExpression pySequenceExpression = literal;
        if (pySequenceExpression == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(15);
        }
        return pySequenceExpression;
    }

    @NotNull
    private static TextRange getRangeOfContentWithoutBraces(@NotNull PsiElement literal) {
        if (literal == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(16);
        }
        if (literal instanceof PyTupleExpression) {
            TextRange textRange = TextRange.create((int)0, (int)literal.getTextLength());
            if (textRange == null) {
                PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(17);
            }
            return textRange;
        }
        String replacedText = literal.getText();
        PsiElement firstChild = literal.getFirstChild();
        int contentStartOffset = PyTokenTypes.OPEN_BRACES.contains(firstChild.getNode().getElementType()) ? firstChild.getTextLength() : 0;
        PsiElement lastChild = literal.getLastChild();
        int contentEndOffset = PyTokenTypes.CLOSE_BRACES.contains(lastChild.getNode().getElementType()) ? replacedText.length() - lastChild.getTextLength() : replacedText.length();
        TextRange textRange = TextRange.create((int)contentStartOffset, (int)contentEndOffset);
        if (textRange == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(18);
        }
        return textRange;
    }

    @Nullable
    private static PySequenceExpression findCollectionLiteralUnderCaret(@NotNull Editor editor2, @NotNull PsiFile psiFile) {
        int caretOffset;
        PsiElement curElem;
        PySequenceExpression seqExpr;
        if (editor2 == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(19);
        }
        if (psiFile == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(20);
        }
        if ((seqExpr = (PySequenceExpression)PsiTreeUtil.getParentOfType((PsiElement)(curElem = psiFile.findElementAt(caretOffset = editor2.getCaretModel().getOffset())), PySequenceExpression.class)) != null) {
            return seqExpr;
        }
        PyParenthesizedExpression paren = (PyParenthesizedExpression)PsiTreeUtil.findFirstParent((PsiElement)curElem, element -> {
            PyParenthesizedExpression parenthesizedExpr = PyUtil.as(element, PyParenthesizedExpression.class);
            return parenthesizedExpr != null && parenthesizedExpr.getContainedExpression() instanceof PyTupleExpression;
        });
        return paren != null ? (PyTupleExpression)paren.getContainedExpression() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetCollectionClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetCollectionName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftBrace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightBrace";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyBaseConvertCollectionLiteralIntention";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyBaseConvertCollectionLiteralIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareOriginalElementCopy";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapCollection";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapCollection";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeOfContentWithoutBraces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForCollection";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareOriginalElementCopy";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unwrapCollection";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "wrapCollection";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRangeOfContentWithoutBraces";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findCollectionLiteralUnderCaret";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

