/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pyramid.run;

import com.intellij.DynamicBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.pyramid.run.PyramidRunConfiguration;
import com.jetbrains.python.run.AbstractPyCommonOptionsForm;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PyCommonOptionsFormFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyramidRunConfigurationEditor
extends SettingsEditor<PyramidRunConfiguration>
implements PanelWithAnchor {
    private static final String DEFAULT_HOST = "0.0.0.0";
    private static final String DEFAULT_PORT = "6543";
    private JPanel myPanel;
    private JTextField myAdditionalOptionsTextField;
    private JPanel myCommonOptionsFormPlaceholder;
    private JBLabel myAdditionalOptionsLabel;
    private TextFieldWithBrowseButton myTargetTextField;
    private JBLabel myTargetLabel;
    private JBCheckBox myRunBrowserCheckBox;
    private JTextField myBrowserUrlField;
    private final AbstractPyCommonOptionsForm myCommonOptionsForm;
    private JComponent myAnchor;

    public PyramidRunConfigurationEditor(PyramidRunConfiguration configuration) {
        this.$$$setupUI$$$();
        this.myCommonOptionsForm = PyCommonOptionsFormFactory.getInstance().createForm(configuration.getCommonOptionsFormData());
        this.myCommonOptionsFormPlaceholder.add((Component)this.myCommonOptionsForm.getMainPanel(), "Center");
        String title = "Select Configuration File:";
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor();
        fileChooserDescriptor.setTitle("Select Configuration File:");
        this.myTargetTextField.addBrowseFolderListener("Select Configuration File:", null, configuration.getProject(), fileChooserDescriptor);
        this.myTargetLabel.setLabelFor((Component)this.myTargetTextField);
        this.myRunBrowserCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isSelected = PyramidRunConfigurationEditor.this.myRunBrowserCheckBox.isSelected();
                PyramidRunConfigurationEditor.this.myBrowserUrlField.setEnabled(isSelected);
            }
        });
    }

    protected void resetEditorFrom(@NotNull PyramidRunConfiguration s) {
        if (s == null) {
            PyramidRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        AbstractPythonRunConfiguration.copyParams(s, this.myCommonOptionsForm);
        this.myAdditionalOptionsTextField.setText(s.getAdditionalOptions());
        this.setBrowserUrl(s.getBrowserUrl());
        this.myTargetTextField.setText(s.getConfigFile());
    }

    protected void applyEditorTo(@NotNull PyramidRunConfiguration s) throws ConfigurationException {
        if (s == null) {
            PyramidRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        AbstractPythonRunConfiguration.copyParams(this.myCommonOptionsForm, s);
        s.setAdditionalOptions(this.myAdditionalOptionsTextField.getText());
        s.setBrowserUrl(this.getBrowserUrl());
        s.setConfFile(this.myTargetTextField.getText());
    }

    @Nullable
    public String getBrowserUrl() {
        return this.myRunBrowserCheckBox.isSelected() ? this.myBrowserUrlField.getText() : null;
    }

    public void setBrowserUrl(String url) {
        if (StringUtil.isEmpty((String)url)) {
            this.myRunBrowserCheckBox.setSelected(false);
            this.myBrowserUrlField.setEnabled(false);
            this.myBrowserUrlField.setText(PyramidRunConfigurationEditor.getDefaultBrowserUrl());
        } else {
            this.myRunBrowserCheckBox.setSelected(true);
            this.myBrowserUrlField.setEnabled(true);
            this.myBrowserUrlField.setText(url);
        }
    }

    private static String getDefaultBrowserUrl() {
        return "http://0.0.0.0:6543";
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            PyramidRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.myAnchor = anchor;
        this.myCommonOptionsForm.setAnchor(anchor);
        this.myAdditionalOptionsLabel.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JBCheckBox jBCheckBox;
        JBLabel jBLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        JTextField jTextField2;
        JBLabel jBLabel2;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAdditionalOptionsLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/PythonProBundle", PyramidRunConfigurationEditor.class).getString("python.pyramid.additional.options"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAdditionalOptionsTextField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCommonOptionsFormPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myTargetTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setToolTipText(ResourceBundle.getBundle("messages/PythonProBundle").getString("python.pyramid.tests.path"));
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 1, null, new Dimension(341, 25), null));
        this.myTargetLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PythonProBundle", PyramidRunConfigurationEditor.class).getString("python.pyramid.config.file"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRunBrowserCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PythonProBundle", PyramidRunConfigurationEditor.class).getString("python.pyramid.run.browser"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBrowserUrlField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jBLabel2.setLabelFor(jTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/pyramid/run/PyramidRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/pyramid/run/PyramidRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

