/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.validation;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.mako.psi.impl.MakoCodeBlock;
import com.jetbrains.mako.validation.MakoAnnotator;
import com.jetbrains.python.PythonProBundle;

public class MakoCodeBlockAnnotator
extends MakoAnnotator {
    @Override
    public void visitMakoCodeBlock(MakoCodeBlock node) {
        int firstIndex;
        super.visitMakoCodeBlock(node);
        String text2 = node.getText();
        int start = firstIndex = text2.indexOf("*");
        while (firstIndex != -1) {
            if (StringUtil.endsWith((CharSequence)text2.substring(0, start).trim(), (CharSequence)"import")) {
                this.registerProblem(node.getTextOffset() + start);
            }
            firstIndex = StringUtil.indexOf((CharSequence)text2.subSequence(start + 1, text2.length()), (char)'*');
            start += firstIndex + 1;
        }
    }

    private void registerProblem(int firstIndex) {
        int end = firstIndex + 1;
        this.getHolder().newAnnotation(HighlightSeverity.ERROR, PythonProBundle.message("mako.import.star.not.supported")).range(new TextRange(firstIndex, end)).create();
    }
}

