/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.ref;

import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlFile;
import com.jetbrains.mako.psi.impl.MakoFile;
import com.jetbrains.python.templateLanguages.TemplatesService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MakoFileReferenceSet
extends FileReferenceSet {
    public MakoFileReferenceSet(String str, @NotNull PsiElement element) {
        if (element == null) {
            MakoFileReferenceSet.$$$reportNull$$$0(0);
        }
        super(str, element, 1, null, SystemInfo.isFileSystemCaseSensitive);
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        ArrayList contexts = Lists.newArrayList();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module != null) {
            List<VirtualFile> templatesFolders = TemplatesService.getInstance(module).getTemplateFolders();
            for (VirtualFile folder : templatesFolders) {
                contexts.add(PsiManager.getInstance((Project)module.getProject()).findDirectory(folder));
            }
            PsiDirectory directory2 = this.getElement().getContainingFile().getOriginalFile().getContainingDirectory();
            if (directory2 != null) {
                contexts.add(directory2);
            }
        }
        ArrayList arrayList = contexts;
        if (arrayList == null) {
            MakoFileReferenceSet.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public FileReference createFileReference(TextRange range, int index, String text2) {
        return new FileReference((FileReferenceSet)this, range.shiftRight(5), index, text2);
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return psiFileSystemItem -> {
            if (!(psiFileSystemItem instanceof PsiDirectory || psiFileSystemItem instanceof MakoFile || psiFileSystemItem instanceof XmlFile)) {
                return false;
            }
            return psiFileSystemItem != this.getElement().getContainingFile().getOriginalFile();
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/mako/ref/MakoFileReferenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/mako/ref/MakoFileReferenceSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

