/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.lexer;

import com.intellij.psi.tree.IElementType;
import com.jetbrains.mako.MakoTokenTypes;
import com.jetbrains.mako.lexer.MakoFlexLexer;
import com.jetbrains.mako.lexer._MakoFlexLexer;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PythonIndentingProcessor;

public class MakoIndentingLexer
extends PythonIndentingProcessor {
    int myInitialIndent = 0;
    boolean insertEndOfStatement = false;

    public MakoIndentingLexer() {
        super(new _MakoFlexLexer(null), MakoFlexLexer.TOKENS_TO_MERGE);
    }

    @Override
    public void advance() {
        if (super.getBaseTokenType() == MakoTokenTypes.PYTHON_CODE) {
            this.insertEndOfStatement = true;
        }
        if (super.getBaseTokenType() == MakoTokenTypes.MAKO_TAG_START) {
            super.advanceBase();
            if (this.getTokenType() == PyTokenTypes.LINE_BREAK) {
                int start = this.getTokenStart();
                super.advanceBase();
                this.myLastNewLineIndent = this.myInitialIndent = this.getNextLineIndent();
                this.myIndentStack.push(this.myLastNewLineIndent);
                this.pushToken(PyTokenTypes.LINE_BREAK, start, this.getTokenStart());
            }
            return;
        }
        super.advance();
    }

    @Override
    protected void processSpecialTokens() {
        super.processSpecialTokens();
        int start = this.getBaseTokenStart();
        if (super.getBaseTokenType() == MakoTokenTypes.MAKO_TAG_END && this.insertEndOfStatement && this.myLineHasSignificantTokens) {
            this.pushToken(PyTokenTypes.STATEMENT_BREAK, start, start);
            this.insertEndOfStatement = false;
        }
    }

    @Override
    protected int getNextLineIndent() {
        int indent = super.getNextLineIndent();
        if (this.getBaseTokenType() == MakoTokenTypes.MAKO_TAG_END) {
            indent = this.myInitialIndent;
        }
        return indent;
    }

    @Override
    protected IElementType getCommentTokenType() {
        return MakoTokenTypes.COMMENT;
    }

    @Override
    protected void checkStartState(int startOffset, int initialState) {
    }
}

