/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.flask.project;

import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.flask.project.FlaskProjectConfigurator;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.newProject.PyFrameworkProjectGenerator;
import com.jetbrains.python.newProject.PyNewProjectSettings;
import com.jetbrains.python.newProject.PythonProjectGenerator;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.remote.PyProjectSynchronizer;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.templateLanguages.PyTemplatesUtil;
import com.jetbrains.python.templateLanguages.TemplateLanguagePanel;
import com.jetbrains.python.templateLanguages.TemplateSettingsHolder;
import com.jetbrains.python.templateLanguages.TemplatesService;
import icons.PythonUltimateIcons;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlaskProjectGenerator
extends PythonProjectGenerator<TemplateSettingsHolder>
implements PyFrameworkProjectGenerator {
    private final boolean myForceInstallFlask;
    private TemplateLanguagePanel myTemplatesPanel;

    public FlaskProjectGenerator() {
        this(false);
    }

    public FlaskProjectGenerator(boolean forceInstallFlask) {
        super(true);
        this.myForceInstallFlask = forceInstallFlask;
    }

    @NotNull
    @Nls
    public String getName() {
        String string = PythonProBundle.message("flask.name");
        if (string == null) {
            FlaskProjectGenerator.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFrameworkTitle() {
        return "Flask";
    }

    @Override
    public boolean isFrameworkInstalled(@NotNull Sdk sdk) {
        List<PyPackage> packages;
        if (sdk == null) {
            FlaskProjectGenerator.$$$reportNull$$$0(1);
        }
        return PyPsiPackageUtil.findPackage(packages = PyPackageUtil.refreshAndGetPackagesModally(sdk), "flask") != null;
    }

    @Override
    public boolean supportsPython3() {
        return true;
    }

    @Nullable
    public Icon getLogo() {
        return PythonUltimateIcons.Flask.Flask_logo;
    }

    @Override
    @Nullable
    public JComponent getSettingsPanel(File baseDir) throws ProcessCanceledException {
        this.myTemplatesPanel = new TemplateLanguagePanel((Collection<String>)ContainerUtil.immutableList((Object[])new String[]{"None", "Mako", "Jinja2"}));
        this.myTemplatesPanel.registerValidators(new FacetValidatorsManager(){

            public void registerValidator(FacetEditorValidator validator, JComponent ... componentsToWatch) {
                throw new UnsupportedOperationException();
            }

            public void validate() {
                FlaskProjectGenerator.this.fireStateChanged();
            }
        });
        this.myTemplatesPanel.setTemplateLanguage("Jinja2");
        return this.myTemplatesPanel;
    }

    @Override
    public ValidationResult warningValidation(@Nullable Sdk sdk) {
        if (this.myTemplatesPanel == null) {
            return ValidationResult.OK;
        }
        ValidationResult result = PyTemplatesUtil.checkInstalled(sdk, this.myTemplatesPanel.getTemplateLanguage(), "flask-");
        return result == null ? super.warningValidation(sdk) : result;
    }

    @Override
    public PyNewProjectSettings getProjectSettings() {
        TemplateSettingsHolder settingsHolder = new TemplateSettingsHolder();
        this.myTemplatesPanel.saveSettings(settingsHolder);
        return settingsHolder;
    }

    @Override
    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull TemplateSettingsHolder settings, @NotNull Module module, @Nullable PyProjectSynchronizer synchronizer) {
        if (project == null) {
            FlaskProjectGenerator.$$$reportNull$$$0(2);
        }
        if (baseDir == null) {
            FlaskProjectGenerator.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            FlaskProjectGenerator.$$$reportNull$$$0(4);
        }
        if (module == null) {
            FlaskProjectGenerator.$$$reportNull$$$0(5);
        }
        this.configureProjectInternal(project, baseDir, settings, module);
    }

    @Override
    protected void configureProjectNoSettings(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Module module) {
        if (project == null) {
            FlaskProjectGenerator.$$$reportNull$$$0(6);
        }
        if (baseDir == null) {
            FlaskProjectGenerator.$$$reportNull$$$0(7);
        }
        if (module == null) {
            FlaskProjectGenerator.$$$reportNull$$$0(8);
        }
        this.configureProjectInternal(project, baseDir, null, module);
    }

    private void configureProjectInternal(@NotNull Project project, @NotNull VirtualFile baseDir, @Nullable TemplateSettingsHolder settings, @NotNull Module module) {
        if (project == null) {
            FlaskProjectGenerator.$$$reportNull$$$0(9);
        }
        if (baseDir == null) {
            FlaskProjectGenerator.$$$reportNull$$$0(10);
        }
        if (module == null) {
            FlaskProjectGenerator.$$$reportNull$$$0(11);
        }
        Sdk targetSdk = settings == null ? PythonSdkUtil.findPythonSdk(module) : settings.getSdk();
        boolean installFramework = settings != null && settings.installFramework() || this.myForceInstallFlask;
        FlaskProjectGenerator.installFrameworkIfNeeded(project, "Flask", "flask", targetSdk, installFramework, () -> {
            if (settings != null && targetSdk != null) {
                TemplatesService.getInstance(module).installTemplateEngine(settings, targetSdk, project, "flask-");
                PythonSdkUpdater.update(targetSdk, null, project, null);
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> FlaskProjectGenerator.createFlaskMain(module, baseDir, settings));
            }
        });
    }

    public static void createFlaskMain(Module module, VirtualFile baseDir, @Nullable TemplateSettingsHolder settings) {
        Project project = module.getProject();
        PsiDirectory projectDir = PsiManager.getInstance((Project)project).findDirectory(baseDir);
        WriteCommandAction.writeCommandAction((Project)project).run(() -> {
            PsiFile appFile;
            FileTemplate template = FileTemplateManager.getInstance((Project)project).getInternalTemplate("Flask Main");
            try {
                appFile = (PsiFile)FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)"app.py", null, (PsiDirectory)projectDir);
            }
            catch (Exception e) {
                Messages.showErrorDialog((Project)project, (String)PythonProBundle.message("flask.create.project.error", e.getMessage()), (String)PythonProBundle.message("flask.create.project"));
                return;
            }
            projectDir.createSubdirectory("static");
            Sdk sdk = settings != null ? settings.getSdk() : null;
            FlaskProjectConfigurator.createFlaskRunConfiguration(module, appFile.getVirtualFile(), sdk);
            if (settings != null) {
                TemplatesService templatesService = TemplatesService.getInstance(module);
                templatesService.generateTemplates(settings, baseDir);
            }
            appFile.navigate(true);
        });
    }

    @NotNull
    public ValidationResult validate(@NotNull String baseDirPath) {
        if (baseDirPath == null) {
            FlaskProjectGenerator.$$$reportNull$$$0(12);
        }
        ValidationResult validationResult = ValidationResult.OK;
        if (validationResult == null) {
            FlaskProjectGenerator.$$$reportNull$$$0(13);
        }
        return validationResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/flask/project/FlaskProjectGenerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/flask/project/FlaskProjectGenerator";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isFrameworkInstalled";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "configureProject";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureProjectNoSettings";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "configureProjectInternal";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

