/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.util;

import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoFileUtil {
    private DjangoFileUtil() {
    }

    public static Set<String> readFileLines(Class<?> baseClass, String relativeName) throws IOException {
        Package aPackage = baseClass.getPackage();
        String fileName = "/" + aPackage.getName().replace(".", "/") + "/" + relativeName;
        InputStream in = baseClass.getResourceAsStream(fileName);
        return DjangoFileUtil.readFileLines(in);
    }

    public static Set<String> readFileLines(String fileName) throws IOException {
        try (FileInputStream in = new FileInputStream(fileName);){
            Set<String> set = DjangoFileUtil.readFileLines(in);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> readFileLines(InputStream in) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String line2;
            HashSet<String> result = new HashSet<String>();
            while ((line2 = reader.readLine()) != null) {
                result.add(line2);
            }
            HashSet<String> hashSet = result;
            return hashSet;
        }
    }

    public static void add(@NotNull String path, @NotNull String content2) throws IOException {
        File file2;
        if (path == null) {
            DjangoFileUtil.$$$reportNull$$$0(0);
        }
        if (content2 == null) {
            DjangoFileUtil.$$$reportNull$$$0(1);
        }
        if ((file2 = DjangoFileUtil.getFile(path)) == null) {
            return;
        }
        DjangoFileUtil.writeContent(file2, FileUtil.loadFile((File)file2) + "\n" + content2);
    }

    @Nullable
    private static File getFile(@NotNull String path) {
        File file2;
        if (path == null) {
            DjangoFileUtil.$$$reportNull$$$0(2);
        }
        if (!(file2 = new File(path)).exists()) {
            return null;
        }
        return file2;
    }

    public static void replace(String path, String start, String end, String replacement, boolean skipStart) throws IOException {
        File file2 = DjangoFileUtil.getFile(path);
        String content2 = FileUtil.loadFile((File)file2);
        int pos = content2.indexOf(start);
        if (pos != -1) {
            int endPos;
            if (skipStart) {
                pos += start.length();
            }
            if ((endPos = content2.indexOf(end, pos)) != -1) {
                content2 = content2.substring(0, pos) + replacement + content2.substring(endPos);
                DjangoFileUtil.writeContent(file2, content2);
            }
        }
    }

    private static void writeContent(File file2, String content2) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file2));){
            writer.write(content2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/django/util/DjangoFileUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

