/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.ref;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.model.DjangoModel;
import com.jetbrains.django.model.applications.DjangoApplicationModel;
import com.jetbrains.django.model.applications.DjangoUnnamedApplicationModel;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.model.modelApi.DjangoModelClass;
import com.jetbrains.django.model.relationalKeys.DjangoKeyCallInfo;
import com.jetbrains.django.ref.DjangoItemFilter;
import com.jetbrains.django.ref.DjangoItemReference;
import com.jetbrains.django.ref.DjangoItemReferenceSet;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyFileImpl;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoRelationsReferenceProvider
extends PsiReferenceProvider {
    private static final PsiElementPattern.Capture<PsiElement> LOG_CLASS_PATTERN = DjangoPsiUtil.valueInsideDictPattern("class", "LOGGING");

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Module module;
        if (element == null) {
            DjangoRelationsReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DjangoRelationsReferenceProvider.$$$reportNull$$$0(1);
        }
        if (!DjangoFacet.isPresent(module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element))) {
            if (PsiReference.EMPTY_ARRAY == null) {
                DjangoRelationsReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PyCallExpression callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class);
        if (callExpression == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                DjangoRelationsReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        DjangoKeyCallInfo callInfo = DjangoKeyCallInfo.getSimpleKeyCallInfo(callExpression, TypeEvalContext.codeAnalysis(element.getProject(), null));
        if (callInfo == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                DjangoRelationsReferenceProvider.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (element.equals(callInfo.getDestClassExpression()) || element.equals(callInfo.getThroughClassExpression())) {
            PsiReference[] psiReferenceArray = new DjangoModelReferenceSet(element, DjangoItemFilter.CLASSES).getAllReferences();
            if (psiReferenceArray == null) {
                DjangoRelationsReferenceProvider.$$$reportNull$$$0(5);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            DjangoRelationsReferenceProvider.$$$reportNull$$$0(6);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/ref/DjangoRelationsReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/ref/DjangoRelationsReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DjangoModelReferenceSet
    extends DjangoItemReferenceSet {
        private DjangoModelReferenceSet(PsiElement element, DjangoItemFilter filter) {
            super(element, filter);
        }

        @Override
        @NotNull
        public Collection<PsiFileSystemItem> getDefaultContexts() {
            ArrayList contexts = Lists.newArrayList(super.getDefaultContexts());
            PyFileImpl file2 = (PyFileImpl)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PyFileImpl.class);
            if (file2 != null) {
                contexts.add(file2);
            }
            ArrayList arrayList = contexts;
            if (arrayList == null) {
                DjangoModelReferenceSet.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        @Override
        protected DjangoItemReference createDjangoReference(TextRange range, int index, String subreferenceText, boolean isLast) {
            return new DjangoModelItemReference(range, index, subreferenceText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/django/ref/DjangoRelationsReferenceProvider$DjangoModelReferenceSet", "getDefaultContexts"));
        }

        private final class DjangoModelItemReference
        extends DjangoItemReference {
            DjangoModelItemReference(TextRange range, int index, String subreferenceText) {
                super(DjangoModelReferenceSet.this, range, index, subreferenceText);
            }

            @Override
            protected boolean isAllowed(PsiElement child) {
                if (child instanceof PyClass) {
                    return DjangoModel.isDjangoModelDescendant((PyClass)child, null);
                }
                return super.isAllowed(child);
            }

            @Override
            public PsiElement bindToElement(@NotNull PsiElement element) {
                PsiNamedElement namedElement;
                if (element == null) {
                    DjangoModelItemReference.$$$reportNull$$$0(0);
                }
                if ((namedElement = PyUtil.as(element, PsiNamedElement.class)) != null) {
                    String appName;
                    QualifiedName modelName = QualifiedName.fromDottedString((String)this.myReferenceSet.getText());
                    if (namedElement instanceof PyClass && (appName = this.getApplicationNameFromModel(modelName, (PyClass)namedElement)) != null) {
                        return this.rename(appName, namedElement.getName());
                    }
                    return super.bindToElement(element);
                }
                throw new IncorrectOperationException("Element does not have a name");
            }

            @Nullable
            private String getApplicationNameFromModel(@NotNull QualifiedName qName, @NotNull PyClass model) {
                if (qName == null) {
                    DjangoModelItemReference.$$$reportNull$$$0(1);
                }
                if (model == null) {
                    DjangoModelItemReference.$$$reportNull$$$0(2);
                }
                if (qName.getComponentCount() != 2) {
                    return null;
                }
                DjangoModelApi api = DjangoModelApi.create(model).getSuccessOrNull();
                if (api == null) {
                    return null;
                }
                String appName = qName.getFirstComponent();
                List<DjangoApplicationModel> applications = api.getApplications();
                if (applications.stream().map(o -> o.getLabel()).noneMatch(s -> s.equals(appName))) {
                    return null;
                }
                TypeEvalContext context = TypeEvalContext.userInitiated(model.getProject(), model.getContainingFile());
                for (DjangoApplicationModel application : applications) {
                    if (!application.getModelClasses(context).stream().anyMatch(o -> model.equals(o.getPyClass()))) continue;
                    return application.getLabel();
                }
                return null;
            }

            @Override
            @NotNull
            protected Collection<PsiFileSystemItem> getContexts() {
                Collection<PsiFileSystemItem> contexts = super.getContexts();
                if (this.getContextReference() != null) {
                    ArrayList<PsiFileSystemItem> results = new ArrayList<PsiFileSystemItem>();
                    for (PsiFileSystemItem context : contexts) {
                        PyFile modelFile;
                        if (!(context instanceof PsiDirectory) || (modelFile = new DjangoUnnamedApplicationModel((PsiDirectory)context).getModel()) == null) continue;
                        results.add((PsiFileSystemItem)modelFile);
                    }
                    ArrayList<PsiFileSystemItem> arrayList = results;
                    if (arrayList == null) {
                        DjangoModelItemReference.$$$reportNull$$$0(3);
                    }
                    return arrayList;
                }
                Collection<PsiFileSystemItem> collection = contexts;
                if (collection == null) {
                    DjangoModelItemReference.$$$reportNull$$$0(4);
                }
                return collection;
            }

            @Override
            protected ResolveResult[] innerResolve(boolean caseSensitive) {
                QualifiedName appQName;
                Module module;
                if ("self".equals(this.getText())) {
                    PyClass clazz = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PyClass.class);
                    if (clazz != null) {
                        return new ResolveResult[]{DjangoModelItemReference.createResolveResult((PsiElement)clazz)};
                    }
                    return ResolveResult.EMPTY_ARRAY;
                }
                if (this.isFirst() && !this.isLast() && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement())) != null && (appQName = DjangoUtil.appLabelToQName(module, this.getText())) != null) {
                    List<PsiElement> results = PyResolveImportUtil.resolveQualifiedName(appQName, PyResolveImportUtil.fromModule(module));
                    ResolveResult[] resolveResults = new ResolveResult[results.size()];
                    for (int i = 0; i < results.size(); ++i) {
                        resolveResults[i] = new PsiElementResolveResult(results.get(i));
                    }
                    return resolveResults;
                }
                ResolveResult[] results = super.innerResolve(caseSensitive);
                if (results.length > 0) {
                    return results;
                }
                return (ResolveResult[])PyClassNameIndex.find(this.getText(), this.getElement().getProject(), true).stream().map(PsiElementResolveResult::new).toArray(PsiElementResolveResult[]::new);
            }

            @Override
            public Object @NotNull [] getVariants() {
                Object[] res = super.getVariants();
                if (this.isFirst()) {
                    ArrayList list = Lists.newArrayList((Object[])res);
                    list.add(LookupElementBuilder.create((String)"self"));
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
                    if (module != null) {
                        for (String s : DjangoUtil.getInstalledAppLabels(module)) {
                            list.add(LookupElementBuilder.create((String)s));
                        }
                        DjangoModelApi api = DjangoModelApi.create(module).getSuccessOrNull();
                        if (api != null) {
                            list.addAll(api.getModelClasses(TypeEvalContext.userInitiated(this.getElement().getProject(), null)).stream().map(DjangoModelClass::getPyClass).map(LookupElementBuilder::create).collect(Collectors.toList()));
                        }
                    }
                    res = list.toArray();
                }
                if (res == null) {
                    DjangoModelItemReference.$$$reportNull$$$0(5);
                }
                return res;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "qName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "model";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/django/ref/DjangoRelationsReferenceProvider$DjangoModelReferenceSet$DjangoModelItemReference";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/django/ref/DjangoRelationsReferenceProvider$DjangoModelReferenceSet$DjangoModelItemReference";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getContexts";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariants";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "bindToElement";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getApplicationNameFromModel";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

