/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model.fieldsAsArguments;

import com.google.common.collect.Collections2;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.model.fieldsAsArguments.FieldsAsArgumentsUtils;
import com.jetbrains.django.model.fieldsAsArguments.fieldReferencesObtainer.DjangoFieldReferencesObtainer;
import com.jetbrains.django.model.fieldsAsArguments.fieldReferencesObtainer.FieldReferencesDirections;
import com.jetbrains.django.model.relationalKeys.DjangoRelationType;
import com.jetbrains.python.PyStringLiteralReference;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DjangoFieldNamesReference
extends PyStringLiteralReference {
    private static final String SELECT_RELATED = "select_related";
    private static final String PREFETCH_RELATED = "prefetch_related";
    private static final String[] VALUES_DISTINCT_AND_ORDER_BY = new String[]{"values", "values_list", "distinct", "order_by"};
    private static final String[] ONLY_AND_DEFER = new String[]{"only", "defer"};
    private static final String[] ALL_FUNCTIONS = ArrayUtil.mergeArrays((String[])ArrayUtil.mergeArrays((String[])VALUES_DISTINCT_AND_ORDER_BY, (String[])ONLY_AND_DEFER), (String[])new String[]{"select_related", "prefetch_related"});

    DjangoFieldNamesReference(@NotNull PyStringLiteralExpression stringLiteralExpression) {
        if (stringLiteralExpression == null) {
            DjangoFieldNamesReference.$$$reportNull$$$0(0);
        }
        super(stringLiteralExpression);
    }

    @Override
    public boolean isSoft() {
        return true;
    }

    @Nullable
    private static PyReferenceExpression getMethodReference(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        PyCallExpression callExpression;
        if (element == null) {
            DjangoFieldNamesReference.$$$reportNull$$$0(1);
        }
        if (context == null) {
            DjangoFieldNamesReference.$$$reportNull$$$0(2);
        }
        if ((callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class)) == null) {
            return null;
        }
        return FieldsAsArgumentsUtils.getCalleeIfNameMatches(Arrays.asList(ALL_FUNCTIONS), null, callExpression, context);
    }

    @Nullable
    public PsiElement resolve() {
        Map<String, Pair<PyType, WeakReference<PsiElement>>> fields = this.getFields();
        if (fields == null) {
            return null;
        }
        Pair<PyType, WeakReference<PsiElement>> pair = fields.get(this.myStringLiteral.getStringValue().trim());
        if (pair == null) {
            return null;
        }
        return (PsiElement)((WeakReference)pair.second).get();
    }

    @Nullable
    private Map<String, Pair<PyType, WeakReference<PsiElement>>> getFields() {
        FieldReferencesDirections director;
        TypeEvalContext context = TypeEvalContext.codeCompletion(this.myElement.getProject(), this.myElement.getContainingFile());
        PyReferenceExpression reference = DjangoFieldNamesReference.getMethodReference(this.myElement, context);
        if (reference == null) {
            return null;
        }
        String functionName = reference.getName();
        if (functionName == null) {
            return null;
        }
        if (functionName.equals(SELECT_RELATED)) {
            director = new FieldReferencesDirections(false, FieldReferencesDirections.ALL_EXCEPT_MANY_TO_MANY).followDirectRelations(FieldReferencesDirections.ALL_EXCEPT_MANY_TO_MANY).followReverseRelations(DjangoRelationType.ONE_TO_ONE);
        } else if (functionName.equals(PREFETCH_RELATED)) {
            director = new FieldReferencesDirections(false, FieldReferencesDirections.ALL_RELATIONS).followDirectRelations(FieldReferencesDirections.ALL_RELATIONS).followReverseRelations(FieldReferencesDirections.ALL_RELATIONS);
        } else if (ArrayUtil.contains((String)functionName, (String[])VALUES_DISTINCT_AND_ORDER_BY)) {
            director = new FieldReferencesDirections(true, FieldReferencesDirections.ALL_RELATIONS).followDirectRelations(FieldReferencesDirections.ALL_RELATIONS).followReverseRelations(FieldReferencesDirections.ALL_RELATIONS).withRemovingSetsFromReverse();
        } else if (ArrayUtil.contains((String)functionName, (String[])ONLY_AND_DEFER)) {
            director = new FieldReferencesDirections(true, FieldReferencesDirections.ALL_RELATIONS).followDirectRelations(FieldReferencesDirections.ALL_RELATIONS);
        } else {
            throw new IllegalArgumentException(String.format("Unknown function %s", functionName));
        }
        return DjangoFieldReferencesObtainer.getFieldReferencesForMethod(reference, context, director);
    }

    public Object @NotNull [] getVariants() {
        Map<String, Pair<PyType, WeakReference<PsiElement>>> fields = this.getFields();
        if (fields == null) {
            if (EMPTY_ARRAY == null) {
                DjangoFieldNamesReference.$$$reportNull$$$0(3);
            }
            return EMPTY_ARRAY;
        }
        Collection result = Collections2.transform(fields.keySet(), input -> LookupElementBuilder.create((String)input).withIcon(AllIcons.Nodes.Field));
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)result);
        if (objectArray == null) {
            DjangoFieldNamesReference.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    static boolean isAllowed(@NotNull PsiElement element) {
        if (element == null) {
            DjangoFieldNamesReference.$$$reportNull$$$0(5);
        }
        if (!(element instanceof PyElement)) {
            return false;
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            return false;
        }
        if (!DjangoFacet.isInProject(element)) {
            return false;
        }
        return DjangoFieldNamesReference.getMethodReference(element, TypeEvalContext.codeAnalysis(element.getProject(), file2)) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiteralExpression";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/fieldsAsArguments/DjangoFieldNamesReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/fieldsAsArguments/DjangoFieldNamesReference";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMethodReference";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAllowed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

