/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.highlighting;

import com.google.common.collect.Maps;
import com.intellij.codeInsight.highlighting.XmlAwareBraceMatcher;
import com.intellij.lang.BracePair;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.django.lang.template.parsing.DjangoTemplateTokenTypes;
import com.jetbrains.django.model.TagLibrary;
import com.jetbrains.django.util.DjangoPsiUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTemplateBraceMatcher
implements PairedBraceMatcher,
DjangoTemplateTokenTypes,
XmlAwareBraceMatcher {
    private static final BracePair[] PAIRS = new BracePair[]{new BracePair(DJANGO_TAG_START, DJANGO_TAG_END, true)};
    private static final Map<IElementType, IElementType> PAIRING_TOKENS = Maps.newHashMap();

    public BracePair @NotNull [] getPairs() {
        if (PAIRS == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(0);
        }
        return PAIRS;
    }

    public boolean isStrictTagMatching(FileType fileType, int braceGroupId) {
        return false;
    }

    public boolean areTagsCaseSensitive(FileType fileType, int braceGroupId) {
        return true;
    }

    public String getTagName(CharSequence fileText, HighlighterIterator iterator) {
        String name = DjangoTemplateBraceMatcher.getFullName(fileText, iterator);
        if (name != null && TagLibrary.startsWithEndPrefix(name)) {
            return TagLibrary.withoutEnd(name);
        }
        return name;
    }

    @Nullable
    private static String getFullName(CharSequence fileText, HighlighterIterator iterator) {
        IElementType tokenType = iterator.getTokenType();
        String name = null;
        if (tokenType == DJANGO_TAG_START) {
            iterator.advance();
            IElementType tokenType1 = iterator.atEnd() ? null : iterator.getTokenType();
            boolean wasWhiteSpace = false;
            if (DjangoTemplateBraceMatcher.isWhitespace(tokenType1)) {
                wasWhiteSpace = true;
                iterator.advance();
                IElementType iElementType = tokenType1 = iterator.atEnd() ? null : iterator.getTokenType();
            }
            if (tokenType1 == DJANGO_TAG_NAME) {
                name = fileText.subSequence(iterator.getStart(), iterator.getEnd()).toString();
            }
            if (wasWhiteSpace) {
                iterator.retreat();
            }
            iterator.retreat();
        } else if (tokenType == DJANGO_TAG_END) {
            int balance = 0;
            int count = 0;
            IElementType tokenType1 = iterator.getTokenType();
            while (balance >= 0) {
                iterator.retreat();
                ++count;
                if (iterator.atEnd()) break;
                tokenType1 = iterator.getTokenType();
                if (tokenType1 == DJANGO_TAG_END) {
                    ++balance;
                    continue;
                }
                if (tokenType1 != DJANGO_TAG_NAME) continue;
                --balance;
            }
            if (tokenType1 == DJANGO_TAG_NAME) {
                name = fileText.subSequence(iterator.getStart(), iterator.getEnd()).toString();
            }
            while (count-- > 0) {
                iterator.advance();
            }
        }
        return name;
    }

    private static boolean isWhitespace(IElementType tokenType) {
        return DjangoPsiUtil.isWhitespace(tokenType);
    }

    public int getBraceTokenGroupId(IElementType tokenType) {
        if (tokenType == DjangoTemplateTokenTypes.DJANGO_TAG_START || tokenType == DjangoTemplateTokenTypes.DJANGO_TAG_END) {
            return 1;
        }
        return 0;
    }

    public boolean isLBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        IElementType tokenType = iterator.getTokenType();
        if (tokenType == DjangoTemplateTokenTypes.DJANGO_TAG_START) {
            String tagName = DjangoTemplateBraceMatcher.getFullName(fileText, iterator);
            return !TagLibrary.startsWithEndPrefix(tagName);
        }
        return false;
    }

    public boolean isRBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        IElementType tokenType = iterator.getTokenType();
        if (tokenType == DjangoTemplateTokenTypes.DJANGO_TAG_END && DjangoTemplateBraceMatcher.findEndTagStart(iterator)) {
            String tagName = DjangoTemplateBraceMatcher.getFullName(fileText, iterator);
            return TagLibrary.startsWithEndPrefix(tagName);
        }
        return false;
    }

    public boolean isPairBraces(IElementType tokenType1, IElementType tokenType2) {
        return tokenType2.equals(PAIRING_TOKENS.get(tokenType1));
    }

    public boolean isStructuralBrace(HighlighterIterator iterator, CharSequence text2, FileType fileType) {
        return true;
    }

    public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
        if (type == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(1);
        }
        return PAIRING_TOKENS.get(type);
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        if (lbraceType == null) {
            DjangoTemplateBraceMatcher.$$$reportNull$$$0(2);
        }
        return true;
    }

    public int getCodeConstructStart(PsiFile file2, int openingBraceOffset) {
        return openingBraceOffset;
    }

    private static boolean findEndTagStart(HighlighterIterator iterator) {
        IElementType tokenType = iterator.getTokenType();
        int balance = 0;
        int count = 0;
        while (balance >= 0) {
            iterator.retreat();
            ++count;
            if (iterator.atEnd()) break;
            tokenType = iterator.getTokenType();
            if (tokenType == DJANGO_TAG_END) {
                ++balance;
                continue;
            }
            if (tokenType != DJANGO_TAG_START) continue;
            --balance;
        }
        while (count-- > 0) {
            iterator.advance();
        }
        return tokenType == DJANGO_TAG_START;
    }

    static {
        PAIRING_TOKENS.put(DjangoTemplateTokenTypes.DJANGO_TAG_START, DjangoTemplateTokenTypes.DJANGO_TAG_END);
        PAIRING_TOKENS.put(DjangoTemplateTokenTypes.DJANGO_TAG_END, DjangoTemplateTokenTypes.DJANGO_TAG_START);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/lang/template/highlighting/DjangoTemplateBraceMatcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lbraceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPairs";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/lang/template/highlighting/DjangoTemplateBraceMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOppositeBraceTokenType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPairedBracesAllowedBeforeType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

