/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template;

import com.google.common.collect.ImmutableSet;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.django.lang.template.psi.DjangoTemplateElementTypes;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DjangoTemplateFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    private final Set<Language> myLanguages;
    private final Language myBaseLanguage;
    private final Language myTemplateDataLanguage;

    public DjangoTemplateFileViewProvider(PsiManager manager, VirtualFile virtualFile2, boolean physical, Language baseLanguage) {
        super(manager, virtualFile2, physical);
        this.myBaseLanguage = baseLanguage;
        this.myTemplateDataLanguage = DjangoTemplateFileViewProvider.calcTemplateDataLanguage(manager.getProject(), virtualFile2);
        this.myLanguages = ImmutableSet.of((Object)this.getBaseLanguage(), (Object)this.getTemplateDataLanguage());
    }

    @NotNull
    public Language getBaseLanguage() {
        Language language = this.myBaseLanguage;
        if (language == null) {
            DjangoTemplateFileViewProvider.$$$reportNull$$$0(0);
        }
        return language;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = this.myTemplateDataLanguage;
        if (language == null) {
            DjangoTemplateFileViewProvider.$$$reportNull$$$0(1);
        }
        return language;
    }

    @NotNull
    private static Language calcTemplateDataLanguage(Project project, VirtualFile file2) {
        FileType type;
        VirtualFile originalFile;
        if (file2 instanceof LightVirtualFile && (originalFile = ((LightVirtualFile)file2).getOriginalFile()) != null) {
            file2 = originalFile;
        }
        if ((type = file2.getFileType()) instanceof LanguageFileType) {
            Language language = ((LanguageFileType)type).getLanguage();
            if (language instanceof TemplateLanguage) {
                HTMLLanguage hTMLLanguage = HTMLLanguage.INSTANCE;
                if (hTMLLanguage == null) {
                    DjangoTemplateFileViewProvider.$$$reportNull$$$0(2);
                }
                return hTMLLanguage;
            }
            for (LanguageSubstitutor substitutor : LanguageSubstitutors.getInstance().forKey((Object)language)) {
                Language l = substitutor.getLanguage(file2, project);
                if (l instanceof TemplateLanguage || l == null) continue;
                Language language2 = l;
                if (language2 == null) {
                    DjangoTemplateFileViewProvider.$$$reportNull$$$0(3);
                }
                return language2;
            }
            Language language3 = language;
            if (language3 == null) {
                DjangoTemplateFileViewProvider.$$$reportNull$$$0(4);
            }
            return language3;
        }
        HTMLLanguage hTMLLanguage = HTMLLanguage.INSTANCE;
        if (hTMLLanguage == null) {
            DjangoTemplateFileViewProvider.$$$reportNull$$$0(5);
        }
        return hTMLLanguage;
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            DjangoTemplateFileViewProvider.$$$reportNull$$$0(6);
        }
        return new DjangoTemplateFileViewProvider((PsiManager)this.getManager(), virtualFile2, false, this.myBaseLanguage);
    }

    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = this.myLanguages;
        if (set == null) {
            DjangoTemplateFileViewProvider.$$$reportNull$$$0(7);
        }
        return set;
    }

    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            DjangoTemplateFileViewProvider.$$$reportNull$$$0(8);
        }
        ParserDefinition def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (lang == this.getTemplateDataLanguage()) {
            PsiFileImpl file2 = (PsiFileImpl)def.createFile((FileViewProvider)this);
            file2.setContentElementType((IElementType)DjangoTemplateElementTypes.TEMPLATE_DATA);
            return file2;
        }
        if (lang == this.myBaseLanguage) {
            return def.createFile((FileViewProvider)this);
        }
        return null;
    }

    public IElementType getContentElementType(@NotNull Language language) {
        if (language == null) {
            DjangoTemplateFileViewProvider.$$$reportNull$$$0(9);
        }
        return language == this.getTemplateDataLanguage() ? DjangoTemplateElementTypes.TEMPLATE_DATA : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/lang/template/DjangoTemplateFileViewProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTemplateDataLanguage";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/lang/template/DjangoTemplateFileViewProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getContentElementType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

