/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.codeInsight.djangoForms;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.django.codeInsight.djangoForms.DjangoModelFactoryBasedBinding;
import com.jetbrains.django.codeInsight.djangoForms.DjangoModelFormBinding;
import com.jetbrains.django.codeInsight.djangoForms.DjangoModelFormClassBasedBinding;
import com.jetbrains.django.model.modelApi.DjangoField;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.model.modelApi.DjangoModelClass;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyCallExpressionNavigator;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DjangoFormWrapper {
    private static final DjangoModelFormBinding[] FORM_BINDINGS = new DjangoModelFormBinding[]{new DjangoModelFactoryBasedBinding(), new DjangoModelFormClassBasedBinding()};
    static final String FIELDS_FIELD = "fields";
    static final String ERRORS_FIELD = "errors";
    static final String CLEANED_DATA_FIELD = "cleaned_data";
    static final String MODEL_FIELD = "model";
    static final Key<PyCallExpression> DJANGO_MODEL_CLASS_CALL_SITE = new Key("DJANGO_MODEL_CLASS_CALL_SITE");
    private static final String EXCLUDE_FIELD = "exclude";
    static final String LOCALIZED_FIELDS = "localized_fields";
    static final String[] META_FIELDS_DICT_FIELD_KEY = new String[]{"widgets", "labels", "help_texts", "error_messages", "field_classes"};
    static final String[] FIELD_BASED_META_FIELDS = new String[]{"fields", "exclude", "localized_fields"};
    static final String[] FIELD_BASED_FORM_FIELDS = new String[]{"fields", "cleaned_data", "errors"};
    static final String FORM_ADD_ERROR_METHOD = "add_error";
    @NotNull
    private final PyClassType myFormType;
    private static final String UPLOAD_FILE = "django.core.files.uploadedfile.UploadedFile";
    private static final Map<String, String> FIELD_INSTANCE_TYPES = new ImmutableMap.Builder().put((Object)"BooleanField", (Object)"bool").put((Object)"CharField", (Object)"unicode").put((Object)"ChoiceField", (Object)"unicode").put((Object)"DateField", (Object)"datetime.date").put((Object)"DateTimeField", (Object)"datetime.datetime").put((Object)"DecimalField", (Object)"decimal.Decimal").put((Object)"DurationField", (Object)"datetime.timedelta").put((Object)"EmailField", (Object)"unicode").put((Object)"FileField", (Object)"django.core.files.uploadedfile.UploadedFile").put((Object)"FilePathField", (Object)"unicode").put((Object)"FloatField", (Object)"float").put((Object)"ImageField", (Object)"django.core.files.uploadedfile.UploadedFile").put((Object)"IntegerField", (Object)"int").put((Object)"GenericIPAddressField", (Object)"unicode").put((Object)"MultipleChoiceField", (Object)"list of unicode").put((Object)"NullBooleanField", (Object)"bool").put((Object)"RegexField", (Object)"unicode").put((Object)"SlugField", (Object)"unicode").put((Object)"TimeField", (Object)"datetime.time").put((Object)"URLField", (Object)"unicode").put((Object)"UUIDField", (Object)"uuid.UUID").build();

    private DjangoFormWrapper(@NotNull PyClassType form) {
        if (form == null) {
            DjangoFormWrapper.$$$reportNull$$$0(0);
        }
        this.myFormType = form;
    }

    @Nullable
    static DjangoFormWrapper getInstanceIfForm(@NotNull PyTypedElement possibleForm, @NotNull TypeEvalContext context) {
        PyType type;
        if (possibleForm == null) {
            DjangoFormWrapper.$$$reportNull$$$0(1);
        }
        if (context == null) {
            DjangoFormWrapper.$$$reportNull$$$0(2);
        }
        if ((type = context.getType(possibleForm)) instanceof PyClassType) {
            return DjangoFormWrapper.getInstanceIfForm((PyClassType)type, context);
        }
        return null;
    }

    @Nullable
    static DjangoFormWrapper getFormWrapper(@NotNull TypeEvalContext evalContext, @NotNull PyTypedElement possibleForm) {
        PyCallExpression callExpression;
        if (evalContext == null) {
            DjangoFormWrapper.$$$reportNull$$$0(3);
        }
        if (possibleForm == null) {
            DjangoFormWrapper.$$$reportNull$$$0(4);
        }
        PyClassType classType = PyUtil.as(evalContext.getType((callExpression = PyCallExpressionNavigator.getPyCallExpressionByCallee((PsiElement)possibleForm)) != null ? callExpression : possibleForm), PyClassType.class);
        return classType != null ? DjangoFormWrapper.getInstanceIfForm(classType, evalContext) : null;
    }

    @Nullable
    static DjangoFormWrapper getInstanceIfForm(@NotNull PyClassType possibleFormOrModelFromSet, @NotNull TypeEvalContext context) {
        if (possibleFormOrModelFromSet == null) {
            DjangoFormWrapper.$$$reportNull$$$0(5);
        }
        if (context == null) {
            DjangoFormWrapper.$$$reportNull$$$0(6);
        }
        PyClass aClass = possibleFormOrModelFromSet.getPyClass();
        String name = possibleFormOrModelFromSet.getName();
        if (name == null || !name.contains("Form")) {
            return null;
        }
        if (NameResolverTools.isSubclass(aClass, DjangoFQNamesProvider.FORM_CLASS, context)) {
            return new DjangoFormWrapper(possibleFormOrModelFromSet);
        }
        if (NameResolverTools.isSubclass(aClass, DjangoFQNamesProvider.BASE_FORMSET_CLASS, context)) {
            if (!(possibleFormOrModelFromSet instanceof PyCollectionType)) {
                return null;
            }
            PyType formType = ((PyCollectionType)possibleFormOrModelFromSet).getIteratedItemType();
            if (!(formType instanceof PyClassType)) {
                return null;
            }
            return DjangoFormWrapper.getInstanceIfForm((PyClassType)formType, context);
        }
        return null;
    }

    boolean isModelForm(@NotNull TypeEvalContext context) {
        if (context == null) {
            DjangoFormWrapper.$$$reportNull$$$0(7);
        }
        return NameResolverTools.isSubclass(this.myFormType.getPyClass(), DjangoFQNamesProvider.MODEL_FORM_CLASS, context);
    }

    @NotNull
    Collection<DjangoField> getAllFields(@NotNull TypeEvalContext context) {
        if (context == null) {
            DjangoFormWrapper.$$$reportNull$$$0(8);
        }
        HashMap result = new HashMap();
        if (this.isModelForm(context)) {
            this.getFieldsFromModel(context).forEach(o -> result.put(o.getName(), o));
        }
        DjangoModelApi.getFieldsWithTypes(context, this.myFormType.getPyClass(), o -> DjangoFormWrapper.getTypeForFormField(o, context), DjangoFQNamesProvider.FORM_FIELD).forEach(o -> result.put(o.getName(), o));
        Collection<DjangoField> collection = result.values();
        if (collection == null) {
            DjangoFormWrapper.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NotNull
    private Iterable<DjangoField> getFieldsFromModel(@NotNull TypeEvalContext context) {
        DjangoModelFormBinding.DjangoModelFormFields fields;
        if (context == null) {
            DjangoFormWrapper.$$$reportNull$$$0(10);
        }
        if ((fields = this.getFields()) == null) {
            List<DjangoField> list = Collections.emptyList();
            if (list == null) {
                DjangoFormWrapper.$$$reportNull$$$0(11);
            }
            return list;
        }
        PyClass model = fields.getFieldAsClass(MODEL_FIELD, context);
        if (model == null) {
            List<DjangoField> list = Collections.emptyList();
            if (list == null) {
                DjangoFormWrapper.$$$reportNull$$$0(12);
            }
            return list;
        }
        DjangoModelClass modelWrapper = DjangoModelClass.createIfModel(model, context);
        if (modelWrapper == null) {
            List<DjangoField> list = Collections.emptyList();
            if (list == null) {
                DjangoFormWrapper.$$$reportNull$$$0(13);
            }
            return list;
        }
        List list = ContainerUtil.filter(modelWrapper.getFields(context), o -> !"AutoField".equals(o.getRealFieldClass().getName()));
        if (list == null) {
            DjangoFormWrapper.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    private DjangoModelFormBinding.DjangoModelFormFields getFields() {
        return DjangoFormWrapper.getFromBinding(o -> o.getFields(this.myFormType));
    }

    @NotNull
    Collection<DjangoField> getAllowedFields(@NotNull TypeEvalContext context) {
        if (context == null) {
            DjangoFormWrapper.$$$reportNull$$$0(15);
        }
        Collection<DjangoField> allFields = this.getAllFields(context);
        if (!this.isModelForm(context)) {
            Collection<DjangoField> collection = allFields;
            if (collection == null) {
                DjangoFormWrapper.$$$reportNull$$$0(16);
            }
            return collection;
        }
        return this.filterAccordingToMeta(allFields, context);
    }

    @NotNull
    private Collection<DjangoField> filterAccordingToMeta(@NotNull Collection<DjangoField> fields, @NotNull TypeEvalContext context) {
        DjangoModelFormBinding.DjangoModelFormFields binding;
        if (fields == null) {
            DjangoFormWrapper.$$$reportNull$$$0(17);
        }
        if (context == null) {
            DjangoFormWrapper.$$$reportNull$$$0(18);
        }
        if ((binding = this.getFields()) == null) {
            List<DjangoField> list = Collections.emptyList();
            if (list == null) {
                DjangoFormWrapper.$$$reportNull$$$0(19);
            }
            return list;
        }
        String possibleAllFields = binding.getFieldAsString(FIELDS_FIELD, context);
        if ("__all__".equals(possibleAllFields)) {
            Collection<DjangoField> collection = fields;
            if (collection == null) {
                DjangoFormWrapper.$$$reportNull$$$0(20);
            }
            return collection;
        }
        List<String> allowedFields = binding.getFieldAsList(FIELDS_FIELD, context);
        if (allowedFields != null) {
            List list = ContainerUtil.filter(fields, o -> allowedFields.contains(o.getName()));
            if (list == null) {
                DjangoFormWrapper.$$$reportNull$$$0(21);
            }
            return list;
        }
        List<String> excludedFields = binding.getFieldAsList(EXCLUDE_FIELD, context);
        if (excludedFields != null) {
            List list = ContainerUtil.filter(fields, o -> !excludedFields.contains(o.getName()));
            if (list == null) {
                DjangoFormWrapper.$$$reportNull$$$0(22);
            }
            return list;
        }
        List<DjangoField> list = Collections.emptyList();
        if (list == null) {
            DjangoFormWrapper.$$$reportNull$$$0(23);
        }
        return list;
    }

    @Nullable
    private static PyType getTypeForFormField(@NotNull PyTargetExpression field, @NotNull TypeEvalContext context) {
        PyExpression assignedValue;
        if (field == null) {
            DjangoFormWrapper.$$$reportNull$$$0(24);
        }
        if (context == null) {
            DjangoFormWrapper.$$$reportNull$$$0(25);
        }
        if ((assignedValue = field.findAssignedValue()) == null) {
            return null;
        }
        PyClassType fieldClassType = PyUtil.as(context.getType(assignedValue), PyClassType.class);
        if (fieldClassType == null) {
            return null;
        }
        String className = fieldClassType.getPyClass().getName();
        if (className == null) {
            return null;
        }
        String fieldTypeName = FIELD_INSTANCE_TYPES.get(className);
        if (fieldTypeName == null && assignedValue instanceof PyCallExpression) {
            fieldTypeName = DjangoFormWrapper.getTypeFromCoerce(context, (PyCallExpression)assignedValue, className);
        }
        if (fieldTypeName == null) {
            return null;
        }
        return PyTypeParser.parse(field, fieldTypeName, context).getType();
    }

    @Nullable
    private static String getTypeFromCoerce(@NotNull TypeEvalContext context, @NotNull PyCallExpression fieldInitCallExpression, @NotNull String className) {
        if (context == null) {
            DjangoFormWrapper.$$$reportNull$$$0(26);
        }
        if (fieldInitCallExpression == null) {
            DjangoFormWrapper.$$$reportNull$$$0(27);
        }
        if (className == null) {
            DjangoFormWrapper.$$$reportNull$$$0(28);
        }
        PyReferenceExpression coerce = fieldInitCallExpression.getArgument(0, "coerce", PyReferenceExpression.class);
        String typeName = "any";
        if (coerce != null) {
            PyType pyType = context.getType(coerce);
            String string = typeName = pyType != null ? pyType.getName() : "any";
        }
        if ("TypedChoiceField".equals(className)) {
            return typeName;
        }
        if ("TypedMultipleChoiceField".equals(className)) {
            return String.format("list of %s", typeName);
        }
        return null;
    }

    @Nullable
    static <R> R getFromBinding(@NotNull Function<? super DjangoModelFormBinding, ? extends R> funcToCall) {
        if (funcToCall == null) {
            DjangoFormWrapper.$$$reportNull$$$0(29);
        }
        return StreamEx.of((Object[])FORM_BINDINGS).map(funcToCall).nonNull().findFirst().orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "form";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleForm";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 18: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evalContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleFormOrModelFromSet";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/codeInsight/djangoForms/DjangoFormWrapper";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = FIELDS_FIELD;
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldInitCallExpression";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funcToCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/codeInsight/djangoForms/DjangoFormWrapper";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsFromModel";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllowedFields";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAccordingToMeta";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceIfForm";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFormWrapper";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isModelForm";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllFields";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsFromModel";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAllowedFields";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "filterAccordingToMeta";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForFormField";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromCoerce";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFromBinding";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

