/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.annotator;

import com.intellij.codeInsight.daemon.DefaultGutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.jetbrains.django.model.DjangoTemplateManager;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.codeInsight.PyElementListCellRenderer;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    private static String getReferenceViewName(PsiElement usage) {
        PyFunction func;
        PsiFile file2 = usage.getContainingFile();
        String name = file2.getName();
        if (file2.getParent() != null) {
            name = file2.getParent().getName() + File.separator + name;
        }
        if ((func = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)usage, PyFunction.class)) != null) {
            name = func.getName() + " in " + name;
        }
        return name;
    }

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        RelatedItemLineMarkerInfo<PsiFile> lineMarker;
        if (element == null) {
            ViewLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            ViewLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiFile && (lineMarker = ViewLineMarkerProvider.getViewLineMarker((PsiFile)element)) != null && !result.contains(lineMarker)) {
            result.add(lineMarker);
        }
    }

    @Nullable
    private static RelatedItemLineMarkerInfo<PsiFile> getViewLineMarker(PsiFile file2) {
        TypeEvalContext context = TypeEvalContext.codeAnalysis(file2.getProject(), file2);
        Set<NavigatablePsiElement> references2 = DjangoTemplateManager.getTemplateReferences(file2, null, context);
        if (!references2.isEmpty()) {
            return new DjangoRelatedItemLineMarkerInfo(file2, file2.getTextRange(), PythonFileType.INSTANCE.getIcon(), 11, new ViewTooltipProvider(references2), (GutterIconNavigationHandler)new DefaultGutterIconNavigationHandler<PsiFile>(references2, "Select View"){

                protected PyElementListCellRenderer createListCellRenderer() {
                    return new PyElementListCellRenderer(){

                        @Override
                        public String getElementText(PsiElement element) {
                            String name = ViewLineMarkerProvider.getReferenceViewName(element);
                            return name != null ? name : super.getElementText(element);
                        }
                    };
                }
            }, GutterIconRenderer.Alignment.RIGHT, GotoRelatedItem.createItems(references2));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/django/annotator/ViewLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DjangoRelatedItemLineMarkerInfo
    extends RelatedItemLineMarkerInfo<PsiFile> {
        private final PsiFile myFile;
        private final TextRange myRange;

        private DjangoRelatedItemLineMarkerInfo(@NotNull PsiFile element, @NotNull TextRange range, Icon icon, int updatePass, @Nullable Function<? super PsiFile, String> tooltipProvider, @Nullable GutterIconNavigationHandler<PsiFile> navHandler, @NotNull GutterIconRenderer.Alignment alignment, @NotNull Collection<? extends GotoRelatedItem> targets) {
            if (element == null) {
                DjangoRelatedItemLineMarkerInfo.$$$reportNull$$$0(0);
            }
            if (range == null) {
                DjangoRelatedItemLineMarkerInfo.$$$reportNull$$$0(1);
            }
            if (alignment == null) {
                DjangoRelatedItemLineMarkerInfo.$$$reportNull$$$0(2);
            }
            if (targets == null) {
                DjangoRelatedItemLineMarkerInfo.$$$reportNull$$$0(3);
            }
            super((PsiElement)element, range, icon, updatePass, tooltipProvider, navHandler, alignment, targets);
            this.myFile = element;
            this.myRange = range;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            DjangoRelatedItemLineMarkerInfo that = (DjangoRelatedItemLineMarkerInfo)((Object)o);
            assert (this.myFile != null);
            assert (that.myFile != null);
            if (this.myFile.getVirtualFile() != null && that.myFile.getVirtualFile() != null && !this.myFile.getVirtualFile().equals(that.myFile.getVirtualFile())) {
                return false;
            }
            return this.myRange.equals((Object)that.myRange);
        }

        public int hashCode() {
            int result = this.myFile.hashCode();
            result = 31 * result + this.myRange.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "alignment";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targets";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/django/annotator/ViewLineMarkerProvider$DjangoRelatedItemLineMarkerInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ViewTooltipProvider
    implements Function<PsiFile, String> {
        private final Set<NavigatablePsiElement> myUsages;

        ViewTooltipProvider(Set<NavigatablePsiElement> usages) {
            this.myUsages = usages;
        }

        public String fun(PsiFile psiFile) {
            if (this.myUsages.size() == 1) {
                return "Referenced from " + ViewLineMarkerProvider.getReferenceViewName((PsiElement)this.myUsages.iterator().next());
            }
            StringBuilder result = new StringBuilder("<html>Referenced from:");
            for (PsiElement psiElement : this.myUsages) {
                result.append("<br>&nbsp;&nbsp;").append(ViewLineMarkerProvider.getReferenceViewName(psiElement));
            }
            return result.toString();
        }
    }
}

