/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.appengine.inspection.AppEngineInspection;
import com.jetbrains.appengine.lang.gql.psi.GqlQuery;
import com.jetbrains.appengine.ui.AppEngineBundle;
import com.jetbrains.appengine.util.AppEnginePythonUtil;
import com.jetbrains.appengine.util.AppEngineUtil;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class QueryBoundParametersInspection
extends AppEngineInspection {
    @Override
    @NotNull
    public String getShortName() {
        return "Query_bound_parameters";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            QueryBoundParametersInspection.$$$reportNull$$$0(0);
        }
        return new QueryParametersVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/appengine/inspection/QueryBoundParametersInspection", "buildVisitor"));
    }

    private static class QueryParametersVisitor
    extends PsiElementVisitor {
        private final ProblemsHolder myHolder;

        private QueryParametersVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                QueryParametersVisitor.$$$reportNull$$$0(0);
            }
            if (element instanceof GqlQuery) {
                PyArgumentList argList;
                GqlQuery query = (GqlQuery)element;
                PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)query.getProject()).getInjectionHost((PsiElement)query);
                if (!(host instanceof PyStringLiteralExpression) || !AppEngineUtil.isGql((PyStringLiteralExpression)host)) {
                    return;
                }
                PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)host, PyCallExpression.class);
                if (call != null && (argList = call.getArgumentList()) != null) {
                    this.analyzeGqlQueryArguments(query, argList.getArguments());
                }
            }
        }

        private void analyzeGqlQueryArguments(GqlQuery query, PyExpression[] args2) {
            int maxNum;
            if (args2.length == 0) {
                return;
            }
            Set<String> names = query.getParameterNames();
            HashSet<Integer> numbers = new HashSet<Integer>();
            HashSet<String> ids = new HashSet<String>();
            if (!names.isEmpty()) {
                for (String name : names) {
                    try {
                        int num = Integer.parseInt(name);
                        numbers.add(num);
                    }
                    catch (NumberFormatException e) {
                        ids.add(name);
                    }
                }
            }
            if (!numbers.isEmpty() && ids.isEmpty() && args2.length < (maxNum = ((Integer)Collections.max(numbers)).intValue()) + 1) {
                this.myHolder.registerProblem((PsiElement)query, AppEngineBundle.message("query-param-error.incorrect-number", maxNum), new LocalQuickFix[0]);
            }
            if (numbers.isEmpty() && !ids.isEmpty()) {
                this.checkNamedParameters(query, args2, ids);
            }
            if (!numbers.isEmpty() && !ids.isEmpty()) {
                this.myHolder.registerProblem((PsiElement)query, AppEngineBundle.message("python.app.engine.error.mixing.parameters", new Object[0]), new LocalQuickFix[0]);
            }
        }

        private void checkNamedParameters(GqlQuery query, PyExpression[] args2, Set<String> ids) {
            Set<String> keys;
            if (args2.length < 2) {
                this.myHolder.registerProblem((PsiElement)query, AppEngineBundle.message("query-param-error.dict-expected", new Object[0]), new LocalQuickFix[0]);
                return;
            }
            if (args2.length == 2 && args2[1] instanceof PyDictLiteralExpression) {
                keys = AppEnginePythonUtil.getKeyNames((PyDictLiteralExpression)args2[1]);
                this.reportMissingKeys(query, ids, keys);
            }
            keys = AppEnginePythonUtil.getArgumentNames(args2, 1);
            this.reportMissingKeys(query, ids, keys);
        }

        private void reportMissingKeys(GqlQuery query, Set<String> params, Set<String> boundParams) {
            HashSet<String> diff = new HashSet<String>(params);
            diff.removeAll(boundParams);
            if (!diff.isEmpty()) {
                String namesStr = StringUtil.join(diff, (String)", ");
                this.myHolder.registerProblem((PsiElement)query, AppEngineBundle.message("query-param-error.named-not-passed", namesStr), new LocalQuickFix[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/appengine/inspection/QueryBoundParametersInspection$QueryParametersVisitor", "visitElement"));
        }
    }
}

