/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.SqliteExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.dialects.SqliteIntermediateFacade;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqliteJdbcHelper
extends JdbcHelperImpl {
    public SqliteJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("SQLITE", version, connection);
    }

    public SqliteJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return SqliteJdbcHelper.extractVersion(version);
    }

    @Override
    public int fixJdbcType(@Nullable String typeName, @Nullable String clazz, int type) {
        if ("datetime".equalsIgnoreCase(typeName)) {
            return 93;
        }
        if ("bool".equalsIgnoreCase(typeName) || "boolean".equalsIgnoreCase(typeName)) {
            return 16;
        }
        return super.fixJdbcType(typeName, clazz, type);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            SqliteJdbcHelper.$$$reportNull$$$0(0);
        }
        e.length = -1;
        e.scale = 0;
    }

    @Override
    @Nullable
    protected JdbcHelperImpl.TemporalGetter getTemporalGetter(int type) {
        return type == 93 || type == 91 ? SqliteTemporalGetter.INSTANCE : super.getTemporalGetter(type);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull JdbcConnectionProvider ds) {
        if (ds == null) {
            SqliteJdbcHelper.$$$reportNull$$$0(1);
        }
        return new SqliteIntermediateFacade(ds, 1, false, SqliteExceptionRecognizer.INSTANCE);
    }

    @Override
    public JdbcHelper.LikeSupport getLikeSupport() {
        return JdbcHelper.LikeSupport.SELECTS_ONLY;
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) throws Exception {
        if (!JdbcNativeUtil.detectString(product, "sqlite")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return SqliteJdbcHelper.create(delegate, productVer);
    }

    @NotNull
    protected static SqliteJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) throws Exception {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        return new SqliteJdbcHelper(SqliteJdbcHelper.extractVersion(productVer), delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/SqliteJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createFacade";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SqliteTemporalGetter
    implements JdbcHelperImpl.TemporalGetter {
        static final JdbcHelperImpl.TemporalGetter INSTANCE = new SqliteTemporalGetter();

        private SqliteTemporalGetter() {
        }

        @Override
        public Object get(@NotNull ResultSet set, @NotNull RemoteResultSet.DataRetrievingOptions options, int idx) throws SQLException {
            if (set == null) {
                SqliteTemporalGetter.$$$reportNull$$$0(0);
            }
            if (options == null) {
                SqliteTemporalGetter.$$$reportNull$$$0(1);
            }
            return set.getObject(idx);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "set";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "options";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/remote/jdbc/helpers/SqliteJdbcHelper$SqliteTemporalGetter";
            objectArray[2] = "get";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

